#!/usr/bin/env kjscmd

function write_page( name, body )
{
    var markUp = "";

    markUp += '<html>';

    markUp += '<head>';
    markUp += '<title>' + name + '</title>';
    markUp += '<link href="../kjsembed.css" rel="stylesheet" type="text/css">';
    markUp += '</head>';

    markUp += '<body>';
    markUp += '<h1>' + name + '</h1>';
    markUp += '<hr>';
    markUp += body;
    markUp += '<hr>';
    markUp += '</body>';

    markUp += '</html>';
    return markUp;
}

function write_classlist( title, intro, classlist )
{
    text = '<h3>'+title+'</h3>';
    text += intro;
    text += '<ul>\n';
    
    var hrefroot = '';
    for ( var i = 0; i < classlist.length; i++ )
    {
	text += '<li>';
	var href = classlist[i].toLowerCase() + '.html';
	var name = classlist[i];
	text += '<a href="' + hrefroot + href + '">' + name + '</a>\n';
    }
    text += '</ul>\n';

    return text;
}

function write_classes( title, desc, sections )
{
    var txt = desc;
    for ( var i = 0; i < sections.length; i += 3 ) {
	txt += write_classlist( sections[ i ], sections[ i+1 ], sections[ i+2 ] );
    }

    return write_page( title, txt );
}

function generate_docs_object( name, obj )
{
    var fileText = write_page( name,
	       'Bindings for the ' + name + ' class.<br />' + dump(obj) );
    System.writeFile("jsref/" + name.toLowerCase() + ".html", fileText);
}

//
// Document the static objects
//
function document_statics( statics )
{
    for ( var idx = 0; idx < statics.length; idx++ ) {
	var name = statics[idx];
	var obj = eval( name );
	var fileText = write_page( name,
		   'Bindings for the static ' + name + ' object.' + dump(obj) );
	System.writeFile("jsref/" + name.toLowerCase() + ".html", fileText);
    }
}

//
// Document the constructable objects
//
function document_constructable( objects )
{
    var withdocs = [ 'Yo' ];

    for ( var idx = 0; idx < objects.length; idx++ )
    {
	    System.out.print('Class: ' + objects[idx] );
	    
	    try {
		generate_docs_object( objects[idx], eval('new '+objects[idx]+'()') );
		withdocs.append( objects[idx] );

		System.out.println(', Success');
	    }
	    catch(x) {
		System.out.println(', ' + x );
	    }
    }

    return withdocs;
}

////
//// Main
////

var statics = [ 'Factory', 'System', 'Global',
		'StdDialog', 'StdAction', 'StdDirs', 'StdIcons' ];

var cons = Factory.constructors().sort();
var widg = Factory.widgets().sort();
var tps = Factory.types().sort();

//
// Generate object reference pages
//
document_statics( statics );
document_constructable( widg );
generate_docs_object( 'TextStream', System.in );

//
// Generate index pages
//
index = [ 'Static Objects',
	  'Statics that are available to scripts as JS objects.',
	  statics,

	  'Widget Objects',
	  'Widgets that are available to scripts as JS objects.',
	  widg,

	  'All Object Types',
	  'All the objects that are defined for scripts.',
	  tps
    ];

System.writeFile( "jsref/index.html",
		  write_classes( 'All Scriptable Objects',
				 'The full set of objects that can be accessed by scripts.',
				 index  ) );

System.writeFile( "jsref/index-static.html", write_classes( index[0], index[1], ['','',index[2]] ) );
System.writeFile( "jsref/index-widgets.html", write_classes( index[3], index[4], ['','',index[5]] ) );
System.writeFile( "jsref/index-objects.html", write_classes( index[6], index[7], ['','',index[8]] ) );

System.exit(0);
