/***************************************************************************
                            QGLWidget.h -  description
                             -------------------
    begin                : Wed Nov 21 12:08:37 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Nov 21 12:08:37 2001, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef QGLWIDGET_H
#define QGLWIDGET_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QGL.h>
#include <qtobjc/QWidget.h>

@interface QGLWidget : QGL 
- initWithWidget: (QWidget *)parent name: (NSString *)name shareWidget: (QGLWidget*)shareWidget f: (int)f;
- init;
- initWithGLFormat: (QGLFormat*)format parent: (QWidget *)parent name: (NSString *)name shareWidget: (QGLWidget*)shareWidget f: (int)f;
- initWithGLFormat: (QGLFormat*)format ;
- (void) dealloc;
- qglColor: (QColor *)c;
- qglClearColor: (QColor *)c;
- (BOOL) isValid;
- (BOOL) isSharing;
- makeCurrent;
- (BOOL) doubleBuffer;
- swapBuffers;
- (QGLFormat*) format;
- setFormat: (QGLFormat*)format;
- (QGLContext*) context;
- setContext: (QGLContext*)context shareContext: (QGLContext*)shareContext deleteOldContext: (BOOL)deleteOldContext;
- setContext: (QGLContext*)context ;
- (QPixmap*) renderPixmap: (int)w h: (int)h useContext: (BOOL)useContext;
- (QPixmap*) renderPixmap;
- (QImage*) grabFrameBuffer: (BOOL)withAlpha;
- (QImage*) grabFrameBuffer;
- makeOverlayCurrent;
- (QGLContext*) overlayContext;
- setMouseTracking: (BOOL)enable;
- reparent: (QWidget *)parent f: (int)f p: (QPoint*)p showIt: (BOOL)showIt;
- reparent: (QWidget *)parent f: (int)f p: (QPoint*)p ;
//- (QGLColormap*) colormap;
//- setColormap: (QGLColormap*)map;
- updateGL;
- updateOverlayGL;
+ (QImage*) convertToGLFormat: (QImage *)img;
- initializeGL;
- resizeGL: (int)w h: (int)h;
- paintGL;
- initializeOverlayGL;
- resizeOverlayGL: (int)w h: (int)h;
- paintOverlayGL;
- setAutoBufferSwap: (BOOL)on;
- (BOOL) autoBufferSwap;
- glInit;
- glDraw;
@end

/** Override these methods in subclasses of QGLWidget to customise event handling behaviour */
@protocol QGLWidgetEventHandling
- keyPressEvent:(QKeyEvent*) arg1;
- keyReleaseEvent:(QKeyEvent*) arg1;
- focusOutEvent:(QFocusEvent*) arg1;
- childEvent:(QChildEvent*) arg1;
- dragMoveEvent:(QDragMoveEvent*) arg1;
- leaveEvent:(QEvent*) arg1;
- tabletEvent:(QTabletEvent*) arg1;
- showEvent:(QShowEvent*) arg1;
- contextMenuEvent:(QContextMenuEvent*) arg1;
- mousePressEvent:(QMouseEvent*) arg1;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- mouseReleaseEvent:(QMouseEvent*) arg1;
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) arg1;
- enterEvent:(QEvent*) arg1;
- focusInEvent:(QFocusEvent*) arg1;
- imEndEvent:(QIMEvent*) arg1;
- dropEvent:(QDropEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) arg1;
- mouseMoveEvent:(QMouseEvent*) arg1;
- moveEvent:(QMoveEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;
- hideEvent:(QHideEvent*) arg1;
- imStartEvent:(QIMEvent*) arg1;
- closeEvent:(QCloseEvent*) arg1;
- paintEvent:(QPaintEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
- resizeEvent:(QResizeEvent*) arg1;
@end


#endif
