/***************************************************************************
                           quizwidget.h  -  description
                             -------------------
    begin                : Tue Feb 12 2002
    copyright            : (C) 2002 by Scott Wheeler
    email                : wheeler@kde.org
***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
***************************************************************************/

#ifndef QUIZWIDGET_H
#define QUIZWIDGET_H

#include <qwidget.h>

#include "card.h"

class KStatusBar;
class KProgress;
class QBoxLayout;
class QVBoxLayout;
class QLabel;

class QuizWidget : public QWidget
{
  Q_OBJECT

public: 
  virtual ~QuizWidget();

  void setCardList(const CardList &list);
  bool frontBackReversed() const;

  /**
   * These functions should rather obviously be implemented in subclasses where
   * useful.  I am providing empty default implementations for subclasses which
   * do not nead copy and paste functionality.
   */
  virtual void cut() {};
  virtual void copy() {};
  virtual void paste() {};
  virtual bool hasSelectedText() const { return false; }

public slots:
  Card nextCard(bool random = true);
  void setFrontBackReversed(bool reverse);
  void setShowAnswerLength(int length);

protected:
  QuizWidget(KStatusBar *statusBar, QWidget *parent, const char *name = 0);

  void setFeedbackMessage(const QString &message);
  void showFeedbackLabel(bool show = true);
  QBoxLayout *layout() const;
  virtual bool eventFilter(QObject *object, QEvent *event);
  int numberOfCards() const;
  int showAnswerLength() const;

private:
  void setupLayout();
  virtual void showCard(const Card &card) = 0;
  virtual QString completeMessage() const;

  KStatusBar *mainStatusBar;
  QVBoxLayout *mainLayout;
  QLabel *feedbackLabel;
  KProgress *progressBar;
  
  CardList completeCardList;
  CardList remainingCardList;

  Card currentCard;
  bool reversed;
  int showAnswer;
  
signals:
  void selectionChanged(); 
  void editWidgetFocusIn();
  void editWidgetFocusOut();
};

#endif
