/* ****************************************************************************
  This file is part of KMathTool

  Copyright (C) 2003 by Marco Wegner <mail@marcowegner.de>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

**************************************************************************** */


#ifndef KMTMAINWINDOW_H
#define KMTMAINWINDOW_H

#include <kmainwindow.h>

class KMathToolModule;
class KMathToolView;
class ModuleInterface;


class KMathTool : public KMainWindow
{
  Q_OBJECT

  public:
    KMathTool(QWidget* parent = 0, const char* name = 0);

  signals:
    void signalModuleLoaded(KMathToolModule*);

  protected:
    virtual bool queryExit( );

  private:
    void setupActions( );
    void readConfig( );
    void writeConfig( );

  private slots:
    void slotNoModules( );
    void slotConfigureKeys( );

  private:
    KMathToolView* m_view;
    ModuleInterface* iface;
};

#endif // KMTMAINWINDOW_H
