// $Id: pen.cpp,v 1.29 2003/01/12 22:42:19 nhasan Exp $

#include <qpainter.h>

#include <kdebug.h>
#include <klocale.h>

#include "pen.h"

Pen::Pen() : Tool( i18n( "Pen" ) )
{
  drawing= FALSE;
  props= Tool::HasLineProperties;
}

void Pen::activating()
{
  kdDebug(4400) << "Pen::activating() hook called canvas=" << canvas << "\n" << endl;
  drawing= FALSE;

  canvas->setCursor(crossCursor);
}

void Pen::mousePressEvent(QMouseEvent *e)
{
  int x,y;
  QPainter painter1;
  QPainter painter2;

  kdDebug(4400) << "Pen::mousePressEvent() handler called\n" << endl;

  if (isActive()) {
    if (drawing) {
      kdDebug(4400) << "Pen: Warning button press received while drawing\n" << endl;
    }
    canvas->markModified();
    x= (e->pos()).x();
    y= (e->pos()).y();
    activeButton= e->button();

    painter1.begin(canvas->pixmap());
    if (activeButton == LeftButton)
      painter1.setPen(leftpen);
    else
      painter1.setPen(rightpen);

    painter1.setWorldMatrix(canvas->zoomMatrix());
    painter1.drawPoint(x, y);
    painter1.end();

    canvas->updateZoomed();
    canvas->repaint(0);
    lastx= x;
    lasty= y;
    drawing= TRUE;
  } 
  if (!isActive()) {
    kdWarning(4400) << "Warning event received when inactive (ignoring)\n" << endl;
  }
}


void Pen::mouseMoveEvent(QMouseEvent *e)
{
  int x,y;
  QPainter painter1;
  QPainter painter2;

  if (isActive()) {
    x= (e->pos()).x();
    y= (e->pos()).y();

    if (drawing) {
      if ((x != lastx) || (y != lasty)) {
	painter1.begin(canvas->pixmap());

	if (activeButton == LeftButton)
	  painter1.setPen(leftpen);
	else
	  painter1.setPen(rightpen);

	painter1.setWorldMatrix(canvas->zoomMatrix());
	painter1.drawLine(lastx, lasty, x, y);

	lastx= x;
	lasty= y;

	painter1.end();
        canvas->updateZoomed();
	canvas->repaint(0);
      }
    }
  }
  else {
    kdWarning(4400) << "Warning event received when inactive (ignoring)\n" << endl;
  }
}

void Pen::mouseReleaseEvent(QMouseEvent *e)
{
  kdDebug(4400) << "Pen::mouseReleaseEvent() handler called\n" << endl;
  if (isActive() && (e->button() == activeButton) && drawing)
    drawing= FALSE;
  if (!isActive()) {
    kdWarning(4400) << "Warning event received when inactive (ignoring)\n" << endl;
  }
}

const char* Pen::pixmap() const
{
    return "pencil";
}

#include "pen.moc"
