// $Id: tool.cpp,v 1.16 2003/01/12 05:03:20 nhasan Exp $

#include <kdebug.h>
#include <stdio.h>
#include <assert.h>
#include <qpixmap.h>
#include "tool.h"

Tool::Tool()
  : id( -1 ), active( false ),
    pix( 0 ), canvas( 0 ), 
    props( 0 ), special( false )
{
}

Tool::Tool(const QString & name)
  : id( -1 ), active( false ),
  pix( 0 ), toolName(name), canvas( 0 ),
  props( 0 ), special( false )
{
}

void Tool::activate(Canvas *c)
{
  assert(!c->isActive());
  canvas= c;
  active= true;
  activating();
}

void Tool::deactivate()
{
  assert(active);
  deactivating();
  active= false;
  canvas= 0;
}

void Tool::setLeftPen(const QPen &p)
{
  kdDebug(4400) << "Tool::setLeftPen()" << endl;
  leftpen= p;
}

void Tool::setLeftBrush(const QBrush &b)
{
  kdDebug(4400) << "Tool::setLeftBrush()" << endl;
  leftbrush= b;
}

void Tool::setRightPen(const QPen &p)
{
  kdDebug(4400) << "Tool::setRightPen()" << endl;
  rightpen= p;
}

void Tool::setRightBrush(const QBrush &b)
{
  kdDebug(4400) << "Tool::setRightBrush()" << endl;
  rightbrush= b;
}

#include "tool.moc"
