//-*-C++-*-
/*
**************************************************************************
                                 description
                             --------------------
    copyright            : (C) 2003 by Luis Carvalho
    email                : lpassos@oninetspeed.pt
**************************************************************************

**************************************************************************
*                                                                        *
*  This program is free software; you can redistribute it and/or modify  *
*  it under the terms of the GNU General Public License as published by  *
*  the Free Software Foundation; either version 2 of the License, or     *
*  (at your option) any later version.                                   *
*                                                                        *
**************************************************************************/

#ifndef PMLIBRARYHANDLE_H
#define PMLIBRARYHANDLE_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qstring.h>

class QDomElement;

/**
 * Class that holds all the information about a specific library.
 * The class can also create the library if it doesn't exists.
 *
 */
class PMLibraryHandle 
{

public:
   enum PMResult { Ok, CouldNotCreateDir, ExistingDir, 
                   CouldNotCreateInfo, ReadOnlyLib, 
                   CouldNotCreateFile };
   /**
    * Constructor for an empty library
    */
   PMLibraryHandle( );

   /**
    * Constructor for a given directory.
    */
   PMLibraryHandle( const QString& path );

   /**
    * Destructor
    */
   ~PMLibraryHandle( );
   /**
    * Returns the library's name
    */
   QString name( ) const { return m_name; }

   /**
    * Returns the library's path
    */
   QString path( ) const { return m_path; }

   /**
    * Returns the library's author
    */
   QString author( ) const { return m_author; }

   /**
    * Returns the library's description
    */
   QString description( ) const { return m_description; }

   /**
    * Sets the library's name
    */
   void setName( const QString& name );

   /**
    * Sets the library's path
    */
   void setPath( const QString& path );

   /**
    * Sets the library's author
    */
   void setAuthor( const QString& author );

   /**
    * Sets the library's description
    */
   void setDescription( const QString& description );

   /**
    * Save the library's information file.
    */
   PMLibraryHandle::PMResult saveLibraryInfo( );

   /**
    * Create the library's information file.
    */
   PMLibraryHandle::PMResult createLibrary( );

   /**
    * Append a new object to the library.
    * Returns true kif successful and false otherwise.
    */
   PMLibraryHandle::PMResult createNewObject( );

   /**
    * Returns true if the library is set read-only
    */
   bool isReadOnly( ) const { return m_readOnly; }

private:
   
   void loadLibraryInfo( );

   QString m_name;
   QString m_path;
   QString m_author;
   QString m_description;
   bool    m_readOnly;
};

#endif
