//-*-C++-*-
/*
**************************************************************************
                                 description
                             --------------------
    copyright            : (C) 2001 by Luis Carvalho
    email                : lpassos@mail.telepac.pt
    copyright            : (C) 2001 by Andreas Zehender
    email                : zehender@kde.org
**************************************************************************

**************************************************************************
*                                                                        *
*  This program is free software; you can redistribute it and/or modify  *
*  it under the terms of the GNU General Public License as published by  *
*  the Free Software Foundation; either version 2 of the License, or     *
*  (at your option) any later version.                                   *
*                                                                        *
**************************************************************************/


#ifndef PMPATTERNEDIT_H
#define PMPATTERNEDIT_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "pmdialogeditbase.h"

class PMPattern;
class PMVectorEdit;
class QComboBox;
class PMFloatEdit;
class PMIntEdit;
class QLabel;
class QCheckBox;
class QWidget;
class QLineEdit;
class QPushButton;

/**
 * Dialog edit class for @ref PMPattern.
 */
class PMPatternEdit : public PMDialogEditBase
{
   Q_OBJECT
   typedef PMDialogEditBase Base;
public:
   /**
    * Creates a PMPatternEdit with parent and name
    */
   PMPatternEdit( QWidget* parent, const char* name = 0 );

   /** */
   virtual void displayObject( PMObject* o );

   /** */
   virtual bool isDataValid( );
protected:
   /** */
   virtual void createTopWidgets( );
   /** */
   virtual void saveContents( );

protected slots:
   /**
    * Slot called whenever a new pattern type is selected.
    */
   void slotComboChanged( int c );
   /**
    * Slot called when turbulence is activated/deactivated.
    */
   void slotTurbulenceClicked( );
   /**
    * Slot called whenever a new interpolation mode is selected.
    */
   void slotInterpolateChanged( int c );
   /**
    * Slot called whenever a new density file name is introduced.
    */
   void slotDensityFileNameChanged( const QString& c );
   /**
    * Slot called when the browse button is pressed for election of the
    * density file
    */
   void slotDensityFileBrowseClicked( );

private:
   /**
    * Set's the combo box and enables/disables widgets.
    */
   void setPatternType( int i );
   /**
    * m_noDepth is false is the editor must show the depth field
    */
   bool m_noDepth;
   PMPattern*     m_pDisplayedObject;
   QComboBox*     m_pTypeCombo;
   PMFloatEdit*   m_pAgateTurbulenceEdit;
   PMIntEdit*     m_pSpiralNumberEdit;
   PMIntEdit*     m_pMaxIterationsEdit;
   PMFloatEdit*   m_pQuiltControl0Edit;
   PMFloatEdit*   m_pQuiltControl1Edit;
   PMVectorEdit*  m_pGradientEdit;
   QLabel*        m_pAgateTurbulenceLabel;
   QLabel*        m_pSpiralNumberLabel;
   QLabel*        m_pGradientLabel;
   QLabel*        m_pQuiltControlsLabel;
   QLabel*        m_pMaxIterationsLabel;
   QLabel*        m_pNoiseGeneratorLabel;
   QComboBox*     m_pNoiseGenerator;
   QCheckBox*     m_pEnableTurbulenceEdit;
   PMVectorEdit*  m_pValueVectorEdit;
   PMIntEdit*     m_pOctavesEdit;
   PMFloatEdit*   m_pOmegaEdit;
   PMFloatEdit*   m_pLambdaEdit;
   QLabel*        m_pValueVectorLabel;
   QLabel*        m_pOmegaLabel;
   QLabel*        m_pLambdaLabel;
   QLabel*        m_pOctavesLabel;
   QLabel*        m_pDepthLabel;
   PMFloatEdit*   m_pDepthEdit;
   QWidget*       m_pDensityWidget;
   QLabel*        m_pDensityFileLabel;
   QLineEdit*     m_pDensityFile;
   QPushButton*   m_pDensityFileBrowse;
   QLabel*        m_pDensityInterpolateLabel;
   QComboBox*     m_pDensityInterpolate;
};


#endif
