#ifndef __KVIEWSHELL_H__
#define __KVIEWSHELL_H__


#include <qstring.h>
#include <qevent.h>


#include <kparts/mainwindow.h>
#include <kurl.h>


class KRecentFilesAction;
class ScrollBox;
class KViewPart_Iface;
class KHelpMenu;
class KAboutData;


class QLabel;

class KViewShell : public KParts::MainWindow
{
  Q_OBJECT

public:
  KStatusBar *statusbar;
  KStatusBar *action;

  KViewShell(QString partname, KAboutData *);
  virtual ~KViewShell();

public slots:
  void openURL(const KURL &url);


protected slots:
  void slotFileOpen();
  void slotFullScreen();
  void slotQuit();
  void slotConfigureKeys();
  void slotEditToolbar();
  void slotFileClose();
  void slotNewToolbarConfig();

  void slotChangeZoomText(const QString &);
  void slotChangePageText(const QString &);
  void slotChangeSizeText(const QString &);

protected:
  void readSettings();
  void writeSettings();

  void checkActions();

  void dragEnterEvent(QDragEnterEvent *event);
  void dropEvent(QDropEvent *event);
  void keyPressEvent(QKeyEvent * e);

private:
  QString _partname;
  KViewPart_Iface *view;

  KRecentFilesAction *recent;
  QString cwd;

  KAction *closeAction, *reloadAction;
  KToggleAction *fullScreenAction;
  KHelpMenu *m_helpMenu;

  // In the attribute, the status of the statusbar (shown of hidden)
  // is saved when the kviewshell switches to fullscreen mode. The
  // statusbar can then be restored when the application returns to normal mode.
  bool isStatusBarShownInNormalMode;
  // ditto, for the toolbar
  bool isToolBarShownInNormalMode;
};


#endif
