/*
 * Copyright (C) 2002 the xine-project
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 * $Id: log_window.c,v 1.7 2003/03/01 23:37:56 guenter Exp $
 *
 * log window implementation
 */

#include <config.h>
#include <X11/Xlib.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <glib.h>
#include <stdio.h>
#include <string.h>

#include "globals.h"
#include "gtkxine.h"
#include "log_window.h"

#define MAX_TEXT 100

static GtkWidget *win;
static GtkWidget *texts[MAX_TEXT];
static int        is_visible;

static void update_log_window () {

  int i;
  gchar **log;

  for (i=0; i<gtk_xine_get_log_section_count (GTK_XINE(gtx)); i++) {

    int j, length;

    gtk_editable_delete_text (GTK_EDITABLE (texts[i]),
			      0, -1);

    log = gtk_xine_get_log (GTK_XINE(gtx), i);

    if (!log)
      continue;

    j = 0; length = 0;
    while ( log[j] ) {
      int pos = length;

      gtk_editable_insert_text (GTK_EDITABLE (texts[i]),
				log[j], strlen (log[j]),
				&pos);

      length += strlen (log[j]); j++;
					      
    }
  }
}

static gboolean close_cb (GtkWidget* widget, gpointer data) {
  is_visible = FALSE;
  gtk_widget_destroy (win);

  return TRUE;
}

static void refresh_cb (GtkWidget* widget, gpointer data) {
  update_log_window ();
}

void log_window_init () {

  GtkWidget *vbox, *hbox, *tabs, *button, *label;
  int        i;
  gchar    **names;

  is_visible = FALSE;

  /* 
   * window 
   */

  win = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (win), "xine engine log output");
  gtk_window_set_default_size (GTK_WINDOW (win), 640, 400);
  g_signal_connect( GTK_OBJECT (win), "delete_event",
		      G_CALLBACK (close_cb), NULL );

  vbox = gtk_vbox_new (0,0);

  /*
   * notebook
   */

  tabs = gtk_notebook_new();

  names = gtk_xine_get_log_names (GTK_XINE(gtx));
  for (i=0; i<gtk_xine_get_log_section_count (GTK_XINE(gtx)); i++) {

    GtkWidget *scroller;

    label = gtk_label_new (names[i]);
    texts[i] = gtk_text_new (NULL, NULL);

    scroller = gtk_scrolled_window_new (NULL, NULL);
    gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW (scroller),
					   texts[i]);

    gtk_notebook_append_page (GTK_NOTEBOOK (tabs),
			      scroller, label);
  }
  gtk_box_pack_start (GTK_BOX(vbox), tabs, TRUE, TRUE, 2);

  /*
   * button bar
   */

  hbox = gtk_hbox_new (0,2);
  
  button = gtk_button_new_with_label ("close");
  g_signal_connect (button, "clicked", G_CALLBACK(close_cb), NULL);
  gtk_box_pack_start (GTK_BOX(hbox), button, TRUE, TRUE, 2);

  button = gtk_button_new_with_label ("refresh");
  g_signal_connect (button, "clicked", G_CALLBACK(refresh_cb), 
		    NULL);
  gtk_box_pack_end (GTK_BOX(hbox), button, TRUE, TRUE, 2);


  gtk_box_pack_start (GTK_BOX(vbox), hbox, FALSE, FALSE, 2);
  

  gtk_container_add (GTK_CONTAINER (win), vbox);

}

void log_window_show (void) {

  if (is_visible) {
    is_visible = FALSE;
    gtk_widget_hide (win);
  } else {
    is_visible = TRUE;
    gtk_widget_show_all (win);
    gtk_widget_map (win);
    update_log_window ();
  }
}



