/* 
 * Copyright (C) 2003 the xine project
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: open_mrl.c,v 1.5 2003/03/28 17:18:19 guenter Exp $
 *
 * open mrl dialog (plus file browser)
 */

#include <config.h>

#include <gtk/gtk.h>

#include "open_mrl.h"
#include "playlist.h"
#include "utils.h"

static GtkWidget      *mrl_dialog;
static int             mrl_visible;
static GtkWidget      *mrl_entry;

void file_dialog_show(void) {

  gchar **fnames;

  fnames = modal_multi_file_dialog ("Select file(s) to open", NULL);
  
  if (fnames) {
    int    pos, i;
    gchar *mrl;

    i = 0; pos = 0;
    while ( (mrl = fnames[i]) ) {

      if (i)
	playlist_add_mrl (mrl);
      else
	pos = playlist_add_mrl (mrl);
      
      i++;
    }

    playlist_play (pos);
  }

}

void file_dialog_init (void) {

  /* nothing to be done natm */
}

static gboolean open_mrl_ok_cb (GtkWidget* widget, gpointer data) {
  GtkWidget    *dlg = (GtkWidget *) data;
  const gchar  *mrl;
  int           item;

  gtk_widget_hide (dlg);
  mrl_visible = 0;

  mrl = gtk_entry_get_text (GTK_ENTRY (mrl_entry));

  item = playlist_add_mrl (mrl);
  playlist_play (item);

  return TRUE;
}

static gboolean open_mrl_cancel_cb (GtkWidget* widget, gpointer data) {

  gtk_widget_hide (mrl_dialog);
  mrl_visible = 0;

  return TRUE;
}

void open_mrl_init (void) {

  GtkWidget *label, *hbox;
  GtkWidget *button;

  mrl_dialog = gtk_dialog_new ();

  gtk_window_set_default_size (GTK_WINDOW (mrl_dialog), 400, 150);
  gtk_window_set_title (GTK_WINDOW (mrl_dialog), "open mrl...");
  gtk_window_set_position (GTK_WINDOW (mrl_dialog), GTK_WIN_POS_CENTER);
  g_signal_connect (GTK_OBJECT (mrl_dialog), "delete_event",
		    G_CALLBACK (open_mrl_cancel_cb), mrl_dialog );


  hbox = gtk_hbox_new (0, 2);

  label = gtk_label_new ("mrl:");

  gtk_box_pack_start (GTK_BOX(hbox), label, FALSE, FALSE, 0);

  mrl_entry = gtk_entry_new ();
  gtk_box_pack_start (GTK_BOX(hbox), mrl_entry, TRUE, TRUE, 2);

  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (mrl_dialog)->vbox),
		      hbox, TRUE, TRUE, 0);


  button = gtk_dialog_add_button (GTK_DIALOG (mrl_dialog), GTK_STOCK_OK, 0);
  g_signal_connect (GTK_OBJECT (button), "clicked",
		    G_CALLBACK (open_mrl_ok_cb), mrl_dialog);

  button = gtk_dialog_add_button (GTK_DIALOG (mrl_dialog), GTK_STOCK_CANCEL, 0);
  g_signal_connect (GTK_OBJECT (button), "clicked",
		    G_CALLBACK (open_mrl_cancel_cb), mrl_dialog);

  mrl_visible = 0;

}

void open_mrl_show (void) {
  if (mrl_visible) {
    mrl_visible = FALSE;
    gtk_widget_hide (mrl_dialog);
  } else {
    mrl_visible = TRUE;
    gtk_widget_show_all (mrl_dialog);
    gtk_widget_map (mrl_dialog);
    gtk_widget_grab_focus (mrl_entry);
  }
}

