/******************************************************************************
 * Copyright (c) 2003 Tobias Henle <tobias@page23.de>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ******************************************************************************/

#include <gtk/gtk.h>
#include "xfce_hvbox.h"

static void	xfce_hvbox_class_init(XfceHVBoxClass *klass);
static void	xfce_hvbox_init(XfceHVBox *box);
static void	xfce_hvbox_size_request(GtkWidget *widget,
    		  GtkRequisition *requisition);
static void	xfce_hvbox_size_allocate(GtkWidget *widget,
    		  GtkAllocation  *allocation);

static guint	signals[1] = { 0 };


GType
xfce_hvbox_get_type (void)
{
  static GType hvbox_type = 0;

  if (!hvbox_type)
  {
      static const GTypeInfo hvbox_info =
      {
	sizeof (XfceHVBoxClass),
	NULL,		/* base_init */
	NULL,		/* base_finalize */
	(GClassInitFunc) xfce_hvbox_class_init,
	NULL,		/* class_finalize */
	NULL,		/* class_data */
	sizeof (XfceHVBox),
	0,		/* n_preallocs */
	(GInstanceInitFunc) xfce_hvbox_init,
      };

      if ((hvbox_type = g_type_from_name("XfceHVBox")) != 0)
	      return(hvbox_type);

      hvbox_type =	g_type_register_static (GTK_TYPE_BOX, "XfceHVBox",
	  		  &hvbox_info, 0);
    }

  return hvbox_type;
};

static void xfce_hvbox_class_init (XfceHVBoxClass *class)
{
  GtkWidgetClass	*widget_class;
  GtkHBox		*hbox;
  GtkVBox		*vbox;

  widget_class 			= (GtkWidgetClass*) class;

  /* dirty workaround to get the classes for h and v box			*/
  vbox				= GTK_VBOX(gtk_vbox_new(FALSE, 0));
  hbox				= GTK_HBOX(gtk_hbox_new(FALSE, 0));
  
  class->parent_vbox		= GTK_VBOX_GET_CLASS(vbox);
  class->parent_hbox		= GTK_HBOX_GET_CLASS(hbox);


  gtk_widget_destroy(GTK_WIDGET(vbox));
  gtk_widget_destroy(GTK_WIDGET(hbox));
  /* dirty workaround to get the classes for h and v box			*/

  widget_class->size_request 	= xfce_hvbox_size_request;
  widget_class->size_allocate	= xfce_hvbox_size_allocate;

  signals[0] = 	g_signal_new("orientation_changed", 
      		  G_OBJECT_CLASS_TYPE(widget_class),
     		  G_SIGNAL_RUN_LAST, 
		  G_STRUCT_OFFSET(XfceHVBoxClass, orientation_changed),
		  NULL, NULL, g_cclosure_marshal_VOID__LONG, G_TYPE_NONE, 1, 
		  G_TYPE_LONG);
};

static void xfce_hvbox_init (XfceHVBox *hvbox)
{
};

GtkWidget* xfce_hvbox_new (
  gboolean homogeneous,
  gint spacing,
  XfceHVBoxOrientation orientation
) {
  XfceHVBox *hvbox;

  hvbox 			= XFCE_HVBOX(g_object_new(XFCE_TYPE_HVBOX, NULL));

  hvbox->orientation		= orientation;
  GTK_BOX(hvbox)->spacing	= spacing;
  GTK_BOX(hvbox)->homogeneous	= homogeneous ? TRUE : FALSE;

  return GTK_WIDGET(hvbox);
};

void xfce_hvbox_set_orientation(
  XfceHVBox *hvbox, 
  XfceHVBoxOrientation orientation
) {
  /* ignore requestes for current orientation					*/
  if(xfce_hvbox_get_orientation(hvbox) == orientation)
    return;

  hvbox->orientation = orientation;

  gtk_widget_queue_resize(GTK_WIDGET(hvbox));
  gtk_widget_queue_draw(GTK_WIDGET(hvbox));
  
  g_signal_emit(G_OBJECT(hvbox), signals[0], 0, orientation);

  return;
};

static void xfce_hvbox_size_request (
  GtkWidget      	*widget,
  GtkRequisition	*requisition
) {
  XfceHVBox		*hvbox;

  hvbox			= XFCE_HVBOX(widget);

  if(xfce_hvbox_get_orientation(hvbox)==XFCE_HVBOX_ORIENTATION_HORIZONTAL)
    GTK_WIDGET_CLASS(XFCE_HVBOX_GET_CLASS(hvbox)->parent_hbox)->size_request(widget, requisition);
  else if(xfce_hvbox_get_orientation(hvbox)==XFCE_HVBOX_ORIENTATION_VERTICAL)
    GTK_WIDGET_CLASS(XFCE_HVBOX_GET_CLASS(hvbox)->parent_vbox)->size_request(widget, requisition);

  return;
};

static void xfce_hvbox_size_allocate (
  GtkWidget		*widget,
  GtkAllocation		*allocation
) {
  XfceHVBox		*hvbox;

  hvbox			= XFCE_HVBOX(widget);
  
  if(xfce_hvbox_get_orientation(hvbox)==XFCE_HVBOX_ORIENTATION_HORIZONTAL)
    GTK_WIDGET_CLASS(XFCE_HVBOX_GET_CLASS(hvbox)->parent_hbox)->size_allocate(widget, allocation);
  else if(xfce_hvbox_get_orientation(hvbox)==XFCE_HVBOX_ORIENTATION_VERTICAL)
    GTK_WIDGET_CLASS(XFCE_HVBOX_GET_CLASS(hvbox)->parent_vbox)->size_allocate(widget, allocation);

  return;
};
