/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class Long
extends Number
implements Comparable {
    private static final long serialVersionUID = 4290774380558885855L;
    public static final long MIN_VALUE = -9223372036854775808L;
    public static final long MAX_VALUE = 0x7FFFFFFFFFFFFFFFL;
    public static final Class TYPE = VMClassLoader.getPrimitiveClass('J');
    private final long value;

    public Long(long value) {
        this.value = value;
    }

    public Long(String s) {
        this.value = Long.parseLong(s, 10, false);
    }

    public static String toString(long num, int radix) {
        if ((long)((int)num) == num) {
            return Integer.toString((int)num, radix);
        }
        if (radix < 2 || radix > 36) {
            radix = 10;
        }
        char[] buffer = new char[65];
        int i = 65;
        boolean isNeg = false;
        if (num < 0L) {
            isNeg = true;
            if ((num = -num) < 0L) {
                buffer[--i] = Number.digits[(int)(-((long)radix + num) % (long)radix)];
                num = -(num / (long)radix);
            }
        }
        do {
            buffer[--i] = Number.digits[(int)(num % (long)radix)];
        } while ((num /= (long)radix) > 0L);
        if (isNeg) {
            buffer[--i] = 45;
        }
        return new String(buffer, i, 65 - i, true);
    }

    public static String toHexString(long l) {
        return Long.toUnsignedString(l, 4);
    }

    public static String toOctalString(long l) {
        return Long.toUnsignedString(l, 3);
    }

    public static String toBinaryString(long l) {
        return Long.toUnsignedString(l, 1);
    }

    public static String toString(long num) {
        return Long.toString(num, 10);
    }

    public static long parseLong(String str, int radix) {
        return Long.parseLong(str, radix, false);
    }

    public static long parseLong(String s) {
        return Long.parseLong(s, 10, false);
    }

    public static Long valueOf(String s, int radix) {
        return new Long(Long.parseLong(s, radix, false));
    }

    public static Long valueOf(String s) {
        return new Long(Long.parseLong(s, 10, false));
    }

    public static Long decode(String str) {
        return new Long(Long.parseLong(str, 10, true));
    }

    public byte byteValue() {
        return (byte)this.value;
    }

    public short shortValue() {
        return (short)this.value;
    }

    public int intValue() {
        return (int)this.value;
    }

    public long longValue() {
        return this.value;
    }

    public float floatValue() {
        return this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public String toString() {
        return Long.toString(this.value, 10);
    }

    public int hashCode() {
        return (int)this.value ^ (int)(this.value >>> 32);
    }

    public boolean equals(Object obj) {
        return obj instanceof Long && this.value == ((Long)obj).value;
    }

    public static Long getLong(String nm) {
        return Long.getLong(nm, null);
    }

    public static Long getLong(String nm, long val) {
        Long result = Long.getLong(nm, null);
        if (result == null) {
            return new Long(val);
        }
        return result;
    }

    public static Long getLong(String nm, Long def) {
        if (nm == null || "".equals(nm)) {
            return def;
        }
        if ((nm = System.getProperty(nm)) == null) {
            return def;
        }
        try {
            return Long.decode(nm);
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    public int compareTo(Long l) {
        if (this.value == l.value) {
            return 0;
        }
        if (this.value > l.value) {
            return 1;
        }
        return -1;
    }

    public int compareTo(Object o) {
        return this.compareTo((Long)o);
    }

    private static String toUnsignedString(long num, int exp) {
        if (num >= 0L && (long)((int)num) == num) {
            return Integer.toUnsignedString((int)num, exp);
        }
        int mask = (1 << (exp & 0x1F)) - 1;
        char[] buffer = new char[64];
        int i = 64;
        do {
            buffer[--i] = Number.digits[(int)num & mask];
        } while ((num >>>= exp & 0x3F) != 0L);
        return new String(buffer, i, 64 - i, true);
    }

    private static long parseLong(String str, int radix, boolean decode) {
        if (!decode && str == null) {
            throw new NumberFormatException();
        }
        int index = 0;
        int len = str.length();
        boolean isNeg = false;
        if (len == 0) {
            throw new NumberFormatException();
        }
        int ch = str.charAt(index);
        if (ch == 45) {
            if (len == 1) {
                throw new NumberFormatException();
            }
            isNeg = true;
            ch = str.charAt(++index);
        }
        if (decode) {
            if (ch == 48) {
                if (++index == len) {
                    return 0L;
                }
                if ((str.charAt(index) & 0xFFFFFFDF) == 88) {
                    radix = 16;
                    ++index;
                } else {
                    radix = 8;
                }
            } else if (ch == 35) {
                radix = 16;
                ++index;
            }
        }
        if (index == len) {
            throw new NumberFormatException();
        }
        long max = Long.MAX_VALUE / (long)radix;
        if (isNeg && Long.MAX_VALUE % (long)radix == (long)(radix - 1)) {
            ++max;
        }
        long val = 0L;
        while (index < len) {
            if (val < 0L || val > max) {
                throw new NumberFormatException();
            }
            ch = Character.digit(str.charAt(index++), radix);
            val = val * (long)radix + (long)ch;
            if (ch >= 0 && (val >= 0L || isNeg && val == Long.MIN_VALUE)) continue;
            throw new NumberFormatException();
        }
        if (isNeg) {
            return -val;
        }
        return val;
    }
}

