/*
 * Decompiled with CFR 0.152.
 */
package java.rmi.server;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;

public class RMIClassLoader {
    private static Map cacheLoaders = new Hashtable(89);
    private static Map cacheAnnotations = new Hashtable(89);
    private static String defaultAnnotation = System.getProperty("java.rmi.server.defaultAnnotation");
    private static URL defaultCodebase;
    private static MyClassLoader defaultLoader;

    public static Class loadClass(String name) throws MalformedURLException, ClassNotFoundException {
        return RMIClassLoader.loadClass("", name);
    }

    public static Class loadClass(String codebases, String name) throws MalformedURLException, ClassNotFoundException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            return loader.loadClass(name);
        }
        catch (ClassNotFoundException classNotFoundException) {
            loader = codebases.length() == 0 ? defaultLoader : RMIClassLoader.getClassLoader(codebases);
            if (loader == null) {
                throw new ClassNotFoundException("Could not find class (" + name + ") at codebase (" + codebases + ")");
            }
            return loader.loadClass(name);
        }
    }

    private static ClassLoader getClassLoader(String codebases) throws MalformedURLException {
        CacheKey loaderKey = new CacheKey(codebases, Thread.currentThread().getContextClassLoader());
        ClassLoader loader = (ClassLoader)cacheLoaders.get(loaderKey);
        if (loader == null) {
            StringTokenizer tok = new StringTokenizer(codebases, " ");
            ArrayList urls = new ArrayList();
            while (tok.hasMoreTokens()) {
                urls.add(new URL(tok.nextToken()));
            }
            loader = new MyClassLoader((URL[])urls.toArray(new URL[urls.size()]), Thread.currentThread().getContextClassLoader(), codebases);
            cacheLoaders.put(loaderKey, loader);
        }
        return loader;
    }

    public static String getClassAnnotation(Class cl) {
        ClassLoader loader = cl.getClassLoader();
        if (loader == null || loader == ClassLoader.getSystemClassLoader()) {
            return System.getProperty("java.rmi.server.codebase");
        }
        if (loader instanceof MyClassLoader) {
            return ((MyClassLoader)loader).getClassAnnotation();
        }
        String s = (String)cacheAnnotations.get(loader);
        if (s != null) {
            return s;
        }
        if (loader instanceof URLClassLoader) {
            URL[] urls = ((URLClassLoader)loader).getURLs();
            if (urls.length == 0) {
                return null;
            }
            StringBuffer annotation = new StringBuffer(64 * urls.length);
            for (int i = 0; i < urls.length; ++i) {
                annotation.append(urls[i].toExternalForm());
                annotation.append(' ');
            }
            s = annotation.toString();
            cacheAnnotations.put(loader, s);
            return s;
        }
        return System.getProperty("java.rmi.server.codebase");
    }

    public static Object getSecurityContext(ClassLoader loader) {
        throw new Error("Not implemented");
    }

    static {
        try {
            if (defaultAnnotation != null) {
                defaultCodebase = new URL(defaultAnnotation);
            }
        }
        catch (Exception _) {
            defaultCodebase = null;
        }
        if (defaultCodebase != null) {
            defaultLoader = new MyClassLoader(new URL[]{defaultCodebase}, null, defaultAnnotation);
            cacheLoaders.put(new CacheKey(defaultAnnotation, Thread.currentThread().getContextClassLoader()), defaultLoader);
        }
    }

    private static class CacheKey {
        private String mCodeBase;
        private ClassLoader mContextClassLoader;

        public CacheKey(String theCodebase, ClassLoader theContextClassLoader) {
            this.mCodeBase = theCodebase;
            this.mContextClassLoader = theContextClassLoader;
        }

        public boolean equals(Object theOther) {
            if (theOther instanceof CacheKey) {
                CacheKey key = (CacheKey)theOther;
                return this.equals(this.mCodeBase, key.mCodeBase) && this.equals(this.mContextClassLoader, key.mContextClassLoader);
            }
            return false;
        }

        private boolean equals(Object theOne, Object theOther) {
            if (theOne != null) {
                return theOne.equals(theOther);
            }
            return theOther == null;
        }

        public int hashCode() {
            return (this.mCodeBase != null ? this.mCodeBase.hashCode() : 0) ^ (this.mContextClassLoader != null ? this.mContextClassLoader.hashCode() : -1);
        }

        public String toString() {
            return "[" + this.mCodeBase + "," + this.mContextClassLoader + "]";
        }
    }

    private static class MyClassLoader
    extends URLClassLoader {
        private final String annotation;

        private MyClassLoader(URL[] urls, ClassLoader parent, String annotation) {
            super(urls, parent);
            this.annotation = annotation;
        }

        private MyClassLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
            this.annotation = MyClassLoader.urlToAnnotation(urls);
        }

        public static String urlToAnnotation(URL[] urls) {
            if (urls.length == 0) {
                return null;
            }
            StringBuffer annotation = new StringBuffer(64 * urls.length);
            for (int i = 0; i < urls.length; ++i) {
                annotation.append(urls[i].toExternalForm());
                annotation.append(' ');
            }
            return annotation.toString();
        }

        public final String getClassAnnotation() {
            return this.annotation;
        }
    }
}

