/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.config.Config;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.CertificateDialog;
import com.sun.deploy.util.DeployUIManager;
import com.sun.deploy.util.DialogFactory;
import com.sun.deploy.util.Trace;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LookAndFeel;

class TrustDeciderDialog
implements ActionListener {
    public static final int TrustOption_GrantThisSession = 0;
    public static final int TrustOption_Deny = 1;
    public static final int TrustOption_GrantAlways = 2;
    private Certificate[] certs = null;
    private int start = 0;
    private int end = 0;
    private boolean rootCANotValid = false;
    private boolean timeNotValid = false;
    private boolean httpsDialog = false;
    private Date timeStampDate = null;
    private String codeTypeKey = null;

    public TrustDeciderDialog(Certificate[] certificateArray, int n, int n2, boolean bl, boolean bl2) {
        this(certificateArray, n, n2, bl, bl2, null, "trustdecider.code.type.applet");
    }

    public TrustDeciderDialog(Certificate[] certificateArray, int n, int n2, boolean bl, boolean bl2, Date date) {
        this(certificateArray, n, n2, bl, bl2, date, "trustdecider.code.type.applet");
    }

    public TrustDeciderDialog(Certificate[] certificateArray, int n, int n2, boolean bl, boolean bl2, Date date, String string) {
        this.certs = certificateArray;
        this.start = n;
        this.end = n2;
        this.rootCANotValid = bl;
        this.timeNotValid = bl2;
        this.timeStampDate = date;
        this.codeTypeKey = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int DoModal() {
        LookAndFeel lookAndFeel = null;
        try {
            lookAndFeel = DeployUIManager.setLookAndFeel();
            int n = -1;
            if (this.certs[this.start] instanceof X509Certificate && this.certs[this.end - 1] instanceof X509Certificate) {
                JComponent jComponent;
                Object[] objectArray;
                Object object;
                Object object2;
                X509Certificate x509Certificate = (X509Certificate)this.certs[this.start];
                X509Certificate x509Certificate2 = (X509Certificate)this.certs[this.end - 1];
                Principal principal = x509Certificate.getSubjectDN();
                Principal principal2 = x509Certificate2.getIssuerDN();
                String string = principal.getName();
                String string2 = null;
                int n2 = string.indexOf("CN=");
                int n3 = 0;
                if (n2 < 0) {
                    string2 = TrustDeciderDialog.getMessage("security.dialog.unknown.subject");
                } else {
                    try {
                        n3 = string.charAt(n2 += 3) == '\"' ? string.indexOf(34, ++n2) : string.indexOf(44, n2);
                        string2 = n3 < 0 ? string.substring(n2) : string.substring(n2, n3);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        string2 = TrustDeciderDialog.getMessage("security.dialog.unknown.subject");
                    }
                }
                String string3 = principal2.getName();
                String string4 = null;
                n2 = string3.indexOf("O=");
                n3 = 0;
                if (n2 < 0) {
                    string4 = TrustDeciderDialog.getMessage("security.dialog.unknown.issuer");
                } else {
                    try {
                        n3 = string3.charAt(n2 += 2) == '\"' ? string3.indexOf(34, ++n2) : string3.indexOf(44, n2);
                        string4 = n3 < 0 ? string3.substring(n2) : string3.substring(n2, n3);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        string4 = TrustDeciderDialog.getMessage("security.dialog.unknown.issuer");
                    }
                }
                ArrayList<Object> arrayList = new ArrayList<Object>();
                MessageFormat messageFormat = null;
                if (this.getHttpsDialog()) {
                    object2 = this.rootCANotValid ? "security.dialog_https.text0a" : "security.dialog_https.text0";
                    messageFormat = new MessageFormat(TrustDeciderDialog.getMessage((String)object2));
                    object = new Object[]{string2, string4};
                    arrayList.add(messageFormat.format(object));
                } else {
                    object2 = this.rootCANotValid ? "security.dialog.text0a" : "security.dialog.text0";
                    messageFormat = new MessageFormat(TrustDeciderDialog.getMessage((String)object2));
                    object = new Object[]{TrustDeciderDialog.getMessage(this.codeTypeKey), string2, string4};
                    arrayList.add(messageFormat.format(object));
                }
                if (Config.getBooleanProperty("deployment.security.notinca.warning")) {
                    arrayList.add("");
                    object2 = new JLabel();
                    if (this.rootCANotValid) {
                        ((JLabel)object2).setText(TrustDeciderDialog.getMessage("security.dialog.rootCANotValid"));
                        ((JLabel)object2).setIcon(DialogFactory.getWarningIcon());
                    } else {
                        ((JLabel)object2).setText(TrustDeciderDialog.getMessage("security.dialog.rootCAValid"));
                        ((JLabel)object2).setIcon(DialogFactory.getInfoIcon());
                    }
                    arrayList.add(object2);
                }
                if (Config.getBooleanProperty("deployment.security.expired.warning")) {
                    arrayList.add("");
                    if (this.timeNotValid) {
                        object2 = new JLabel(TrustDeciderDialog.getMessage("security.dialog.timeNotValid"));
                        ((JLabel)object2).setIcon(DialogFactory.getWarningIcon());
                        arrayList.add(object2);
                    } else if (this.timeStampDate != null) {
                        messageFormat = new MessageFormat(TrustDeciderDialog.getMessage("security.dialog.timeValidTS"));
                        object2 = new Object[]{TrustDeciderDialog.getMessage(this.codeTypeKey)};
                        object = new JLabel(messageFormat.format(object2));
                        ((JLabel)object).setIcon(DialogFactory.getInfoIcon());
                        arrayList.add(object);
                    } else {
                        object2 = new JLabel(TrustDeciderDialog.getMessage("security.dialog.timeValid"));
                        ((JLabel)object2).setIcon(DialogFactory.getInfoIcon());
                        arrayList.add(object2);
                    }
                    if (this.timeStampDate != null) {
                        arrayList.add("");
                        messageFormat = new MessageFormat(TrustDeciderDialog.getMessage("security.dialog.timestamp.text1"));
                        object2 = DateFormat.getDateTimeInstance(1, 1);
                        object = ((DateFormat)object2).format(this.timeStampDate);
                        objectArray = new Object[]{TrustDeciderDialog.getMessage(this.codeTypeKey), object};
                        jComponent = new JLabel(messageFormat.format(objectArray));
                        ((JLabel)jComponent).setIcon(DialogFactory.getInfoIcon());
                        arrayList.add(jComponent);
                    }
                }
                if (!this.rootCANotValid) {
                    messageFormat = new MessageFormat(TrustDeciderDialog.getMessage("security.dialog.text1"));
                    object2 = new Object[]{string2, string2};
                    arrayList.add(messageFormat.format(object2));
                }
                object2 = new JButton(TrustDeciderDialog.getMessage("security.dialog.buttonViewCert"));
                ((AbstractButton)object2).setMnemonic(TrustDeciderDialog.getAcceleratorKey("security.dialog.buttonViewCert"));
                ((AbstractButton)object2).addActionListener(this);
                object = new JPanel();
                ((Container)object).add((Component)object2);
                ((Container)object).setLayout(new FlowLayout(2));
                arrayList.add(object);
                objectArray = new JButton(TrustDeciderDialog.getMessage("security.dialog.buttonYes"));
                jComponent = new JButton(TrustDeciderDialog.getMessage("security.dialog.buttonNo"));
                JButton jButton = new JButton(TrustDeciderDialog.getMessage("security.dialog.buttonAlways"));
                objectArray.setMnemonic(TrustDeciderDialog.getAcceleratorKey("security.dialog.buttonYes"));
                ((AbstractButton)jComponent).setMnemonic(TrustDeciderDialog.getAcceleratorKey("security.dialog.buttonNo"));
                jButton.setMnemonic(TrustDeciderDialog.getAcceleratorKey("security.dialog.buttonAlways"));
                Object[] objectArray2 = new Object[]{objectArray, jComponent, jButton};
                if (!Trace.isAutomationEnabled()) {
                    n = this.rootCANotValid || this.timeNotValid ? DialogFactory.showOptionDialog(4, (Object)arrayList.toArray(), TrustDeciderDialog.getMessage("security.dialog.caption"), objectArray2, objectArray2[1]) : DialogFactory.showOptionDialog(4, (Object)arrayList.toArray(), TrustDeciderDialog.getMessage("security.dialog.caption"), objectArray2, objectArray2[0]);
                } else {
                    Trace.msgSecurityPrintln("trustdecider.automation.trustcert");
                    n = 0;
                }
            }
            int n4 = n;
            return n4;
        }
        finally {
            DeployUIManager.restoreLookAndFeel(lookAndFeel);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        CertificateDialog certificateDialog = new CertificateDialog(this.certs, this.start, this.end);
        certificateDialog.DoModal();
    }

    private static String getMessage(String string) {
        String string2 = ResourceManager.getMessage(string);
        return string2;
    }

    private static int getAcceleratorKey(String string) {
        return ResourceManager.getAcceleratorKey(string);
    }

    private boolean getHttpsDialog() {
        return this.httpsDialog;
    }

    public void setHttpsDialog(boolean bl) {
        this.httpsDialog = bl;
    }
}

