/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.net.protocol.http;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;

public class HttpUtils {
    private static final String CONNECTION_HEADER = "Connection";
    private static final String CONNECTION_KEEP_ALIVE = "Keep-Alive";
    private static final String PROTOCOL_VERSION_1_1 = "HTTP/1.1";

    public static HttpURLConnection followRedirects(URLConnection uRLConnection) throws IOException {
        boolean bl;
        int n = 0;
        InputStream inputStream = null;
        do {
            HttpURLConnection httpURLConnection;
            int n2;
            if (uRLConnection instanceof HttpURLConnection) {
                ((HttpURLConnection)uRLConnection).setInstanceFollowRedirects(false);
            }
            inputStream = uRLConnection.getInputStream();
            bl = false;
            if (!(uRLConnection instanceof HttpURLConnection) || (n2 = (httpURLConnection = (HttpURLConnection)uRLConnection).getResponseCode()) < 300 || n2 > 305 || n2 == 304) continue;
            URL uRL = httpURLConnection.getURL();
            String string = httpURLConnection.getHeaderField("Location");
            URL uRL2 = null;
            if (string != null) {
                uRL2 = new URL(uRL, string);
            }
            HttpUtils.cleanupConnection(httpURLConnection);
            if (uRL2 == null || !uRL.getProtocol().equals(uRL2.getProtocol()) || n >= 5) {
                throw new SecurityException("illegal URL redirect");
            }
            bl = true;
            uRLConnection = uRL2.openConnection();
            ++n;
        } while (bl);
        if (!(uRLConnection instanceof HttpURLConnection)) {
            throw new IOException(uRLConnection.getURL() + " redirected to non-http URL");
        }
        return (HttpURLConnection)uRLConnection;
    }

    public static void cleanupConnection(URLConnection uRLConnection) {
        if (uRLConnection == null || !(uRLConnection instanceof HttpURLConnection)) {
            return;
        }
        try {
            InputStream inputStream;
            int n;
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
            String string = httpURLConnection.getHeaderField(null);
            String string2 = httpURLConnection.getHeaderField(CONNECTION_HEADER);
            if ((string2 != null && string2.equalsIgnoreCase(CONNECTION_KEEP_ALIVE) || string != null && string.startsWith(PROTOCOL_VERSION_1_1) && string2 == null) && (n = httpURLConnection.getResponseCode()) < 400 && (inputStream = httpURLConnection.getInputStream()) != null) {
                byte[] byArray = new byte[8192];
                while (inputStream.read(byArray) > 0) {
                }
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

