/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap.sasl;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;

public class SaslInputStream
extends InputStream {
    private static final boolean debug = false;
    private byte[] saslBuffer;
    private byte[] lenBuf = new byte[4];
    private byte[] buf = new byte[0];
    private int bufPos = 0;
    private InputStream in;
    private SaslClient sc;
    private int recvMaxBufSize = 65536;

    SaslInputStream(SaslClient saslClient, InputStream inputStream) throws SaslException {
        this.in = inputStream;
        this.sc = saslClient;
        String string = (String)saslClient.getNegotiatedProperty("javax.security.sasl.maxbuffer");
        if (string != null) {
            try {
                this.recvMaxBufSize = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SaslException("javax.security.sasl.maxbuffer property must be numeric string: " + string);
            }
        }
        this.saslBuffer = new byte[this.recvMaxBufSize];
    }

    public int read() throws IOException {
        byte[] byArray = new byte[1];
        int n2 = this.read(byArray, 0, 1);
        if (n2 > 0) {
            return byArray[0];
        }
        return -1;
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        if (this.bufPos >= this.buf.length) {
            n4 = this.fill();
            while (n4 == 0) {
                n4 = this.fill();
            }
            if (n4 == -1) {
                return -1;
            }
        }
        if (n3 > (n4 = this.buf.length - this.bufPos)) {
            System.arraycopy(this.buf, this.bufPos, byArray, n2, n4);
            this.bufPos = this.buf.length;
            return n4;
        }
        System.arraycopy(this.buf, this.bufPos, byArray, n2, n3);
        this.bufPos += n3;
        return n3;
    }

    private int fill() throws IOException {
        int n2 = this.readFully(this.lenBuf, 4);
        if (n2 != 4) {
            return -1;
        }
        int n3 = SaslInputStream.networkByteOrderToInt(this.lenBuf, 0, 4);
        if (n3 > this.recvMaxBufSize) {
            throw new IOException(n3 + "exceeds the negotiated receive buffer size limit:" + this.recvMaxBufSize);
        }
        n2 = this.readFully(this.saslBuffer, n3);
        if (n2 != n3) {
            throw new EOFException("Expecting to read " + n3 + " bytes but got " + n2 + " bytes before EOF");
        }
        this.buf = this.sc.unwrap(this.saslBuffer, 0, n3);
        this.bufPos = 0;
        return this.buf.length;
    }

    private int readFully(byte[] byArray, int n2) throws IOException {
        int n3 = 0;
        while (n2 > 0) {
            int n4 = this.in.read(byArray, n3, n2);
            if (n4 == -1) {
                return n3 == 0 ? -1 : n3;
            }
            n3 += n4;
            n2 -= n4;
        }
        return n3;
    }

    public int available() throws IOException {
        return this.buf.length - this.bufPos;
    }

    public void close() throws IOException {
        SaslException saslException = null;
        try {
            this.sc.dispose();
        }
        catch (SaslException saslException2) {
            saslException = saslException2;
        }
        this.in.close();
        if (saslException != null) {
            throw saslException;
        }
    }

    private static int networkByteOrderToInt(byte[] byArray, int n2, int n3) {
        if (n3 > 4) {
            throw new IllegalArgumentException("Cannot handle more than 4 bytes");
        }
        int n4 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            n4 <<= 8;
            n4 |= byArray[n2 + i2] & 0xFF;
        }
        return n4;
    }
}

