/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.util;

import com.sun.org.apache.bcel.internal.Constants;
import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.Code;
import com.sun.org.apache.bcel.internal.classfile.CodeException;
import com.sun.org.apache.bcel.internal.classfile.Constant;
import com.sun.org.apache.bcel.internal.classfile.ConstantCP;
import com.sun.org.apache.bcel.internal.classfile.ConstantFieldref;
import com.sun.org.apache.bcel.internal.classfile.ConstantInterfaceMethodref;
import com.sun.org.apache.bcel.internal.classfile.ConstantMethodref;
import com.sun.org.apache.bcel.internal.classfile.ConstantNameAndType;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.LocalVariable;
import com.sun.org.apache.bcel.internal.classfile.LocalVariableTable;
import com.sun.org.apache.bcel.internal.classfile.Method;
import com.sun.org.apache.bcel.internal.classfile.Utility;
import com.sun.org.apache.bcel.internal.util.ByteSequence;
import com.sun.org.apache.bcel.internal.util.Class2HTML;
import com.sun.org.apache.bcel.internal.util.ConstantHTML;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.BitSet;

final class CodeHTML
implements Constants {
    private String class_name;
    private Method[] methods;
    private PrintWriter file;
    private BitSet goto_set;
    private ConstantPool constant_pool;
    private ConstantHTML constant_html;
    private static boolean wide = false;

    CodeHTML(String string, String string2, Method[] methodArray, ConstantPool constantPool, ConstantHTML constantHTML) throws IOException {
        this.class_name = string2;
        this.methods = methodArray;
        this.constant_pool = constantPool;
        this.constant_html = constantHTML;
        this.file = new PrintWriter(new FileOutputStream(string + string2 + "_code.html"));
        this.file.println("<HTML><BODY BGCOLOR=\"#C0C0C0\">");
        for (int i2 = 0; i2 < methodArray.length; ++i2) {
            this.writeMethod(methodArray[i2], i2);
        }
        this.file.println("</BODY></HTML>");
        this.file.close();
    }

    private final String codeToHTML(ByteSequence byteSequence, int n2) throws IOException {
        int n3;
        int n4;
        short s2 = (short)byteSequence.readUnsignedByte();
        int n5 = 0;
        int n6 = 0;
        StringBuffer stringBuffer = new StringBuffer("<TT>" + OPCODE_NAMES[s2] + "</TT></TD><TD>");
        if (s2 == 170 || s2 == 171) {
            n4 = byteSequence.getIndex() % 4;
            n6 = n4 == 0 ? 0 : 4 - n4;
            for (n3 = 0; n3 < n6; ++n3) {
                byteSequence.readByte();
            }
            n5 = byteSequence.readInt();
        }
        switch (s2) {
            case 170: {
                int n7 = byteSequence.readInt();
                int n8 = byteSequence.readInt();
                int n9 = byteSequence.getIndex() - 12 - n6 - 1;
                n5 += n9;
                stringBuffer.append("<TABLE BORDER=1><TR>");
                int[] nArray = new int[n8 - n7 + 1];
                for (n4 = 0; n4 < nArray.length; ++n4) {
                    nArray[n4] = n9 + byteSequence.readInt();
                    stringBuffer.append("<TH>" + (n7 + n4) + "</TH>");
                }
                stringBuffer.append("<TH>default</TH></TR>\n<TR>");
                for (n4 = 0; n4 < nArray.length; ++n4) {
                    stringBuffer.append("<TD><A HREF=\"#code" + n2 + "@" + nArray[n4] + "\">" + nArray[n4] + "</A></TD>");
                }
                stringBuffer.append("<TD><A HREF=\"#code" + n2 + "@" + n5 + "\">" + n5 + "</A></TD></TR>\n</TABLE>\n");
                break;
            }
            case 171: {
                n4 = byteSequence.readInt();
                int n10 = byteSequence.getIndex() - 8 - n6 - 1;
                int[] nArray = new int[n4];
                n5 += n10;
                stringBuffer.append("<TABLE BORDER=1><TR>");
                for (n3 = 0; n3 < n4; ++n3) {
                    int n11 = byteSequence.readInt();
                    nArray[n3] = n10 + byteSequence.readInt();
                    stringBuffer.append("<TH>" + n11 + "</TH>");
                }
                stringBuffer.append("<TH>default</TH></TR>\n<TR>");
                for (n3 = 0; n3 < n4; ++n3) {
                    stringBuffer.append("<TD><A HREF=\"#code" + n2 + "@" + nArray[n3] + "\">" + nArray[n3] + "</A></TD>");
                }
                stringBuffer.append("<TD><A HREF=\"#code" + n2 + "@" + n5 + "\">" + n5 + "</A></TD></TR>\n</TABLE>\n");
                break;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 198: 
            case 199: {
                int n12 = byteSequence.getIndex() + byteSequence.readShort() - 1;
                stringBuffer.append("<A HREF=\"#code" + n2 + "@" + n12 + "\">" + n12 + "</A>");
                break;
            }
            case 200: 
            case 201: {
                n3 = byteSequence.getIndex() + byteSequence.readInt() - 1;
                stringBuffer.append("<A HREF=\"#code" + n2 + "@" + n3 + "\">" + n3 + "</A>");
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 169: {
                int n13;
                if (wide) {
                    n13 = byteSequence.readShort();
                    wide = false;
                } else {
                    n13 = byteSequence.readUnsignedByte();
                }
                stringBuffer.append("%" + n13);
                break;
            }
            case 196: {
                wide = true;
                stringBuffer.append("(wide)");
                break;
            }
            case 188: {
                stringBuffer.append("<FONT COLOR=\"#00FF00\">" + TYPE_NAMES[byteSequence.readByte()] + "</FONT>");
                break;
            }
            case 178: 
            case 179: 
            case 180: 
            case 181: {
                int n14 = byteSequence.readShort();
                ConstantFieldref constantFieldref = (ConstantFieldref)this.constant_pool.getConstant(n14, (byte)9);
                int n15 = constantFieldref.getClassIndex();
                String string = this.constant_pool.getConstantString(n15, (byte)7);
                string = Utility.compactClassName(string, false);
                n14 = constantFieldref.getNameAndTypeIndex();
                String string2 = this.constant_pool.constantToString(n14, (byte)12);
                if (string.equals(this.class_name)) {
                    stringBuffer.append("<A HREF=\"" + this.class_name + "_methods.html#field" + string2 + "\" TARGET=Methods>" + string2 + "</A>\n");
                    break;
                }
                stringBuffer.append(this.constant_html.referenceConstant(n15) + "." + string2);
                break;
            }
            case 187: 
            case 192: 
            case 193: {
                short s3 = byteSequence.readShort();
                stringBuffer.append(this.constant_html.referenceConstant(s3));
                break;
            }
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                int n16;
                String string;
                int n17;
                Object object;
                short s4 = byteSequence.readShort();
                if (s2 == 185) {
                    int n18 = byteSequence.readUnsignedByte();
                    int n19 = byteSequence.readUnsignedByte();
                    object = (ConstantInterfaceMethodref)this.constant_pool.getConstant(s4, (byte)11);
                    n17 = ((ConstantCP)object).getClassIndex();
                    string = this.constant_pool.constantToString((Constant)object);
                    n16 = ((ConstantCP)object).getNameAndTypeIndex();
                } else {
                    ConstantMethodref constantMethodref = (ConstantMethodref)this.constant_pool.getConstant(s4, (byte)10);
                    n17 = constantMethodref.getClassIndex();
                    string = this.constant_pool.constantToString(constantMethodref);
                    n16 = constantMethodref.getNameAndTypeIndex();
                }
                String string3 = Class2HTML.referenceClass(n17);
                string = Class2HTML.toHTML(this.constant_pool.constantToString(this.constant_pool.getConstant(n16, (byte)12)));
                ConstantNameAndType constantNameAndType = (ConstantNameAndType)this.constant_pool.getConstant(n16, (byte)12);
                String string4 = this.constant_pool.constantToString(constantNameAndType.getSignatureIndex(), (byte)1);
                String[] stringArray = Utility.methodSignatureArgumentTypes(string4, false);
                object = Utility.methodSignatureReturnType(string4, false);
                stringBuffer.append(string3 + ".<A HREF=\"" + this.class_name + "_cp.html#cp" + s4 + "\" TARGET=ConstantPool>" + string + "</A>" + "(");
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    stringBuffer.append(Class2HTML.referenceType(stringArray[i2]));
                    if (i2 >= stringArray.length - 1) continue;
                    stringBuffer.append(", ");
                }
                stringBuffer.append("):" + Class2HTML.referenceType((String)object));
                break;
            }
            case 19: 
            case 20: {
                short s5 = byteSequence.readShort();
                stringBuffer.append("<A HREF=\"" + this.class_name + "_cp.html#cp" + s5 + "\" TARGET=\"ConstantPool\">" + Class2HTML.toHTML(this.constant_pool.constantToString(s5, this.constant_pool.getConstant(s5).getTag())) + "</a>");
                break;
            }
            case 18: {
                int n20 = byteSequence.readUnsignedByte();
                stringBuffer.append("<A HREF=\"" + this.class_name + "_cp.html#cp" + n20 + "\" TARGET=\"ConstantPool\">" + Class2HTML.toHTML(this.constant_pool.constantToString(n20, this.constant_pool.getConstant(n20).getTag())) + "</a>");
                break;
            }
            case 189: {
                short s6 = byteSequence.readShort();
                stringBuffer.append(this.constant_html.referenceConstant(s6));
                break;
            }
            case 197: {
                short s7 = byteSequence.readShort();
                byte by = byteSequence.readByte();
                stringBuffer.append(this.constant_html.referenceConstant(s7) + ":" + by + "-dimensional");
                break;
            }
            case 132: {
                short s8;
                int n21;
                if (wide) {
                    n21 = byteSequence.readShort();
                    s8 = byteSequence.readShort();
                    wide = false;
                } else {
                    n21 = byteSequence.readUnsignedByte();
                    s8 = byteSequence.readByte();
                }
                stringBuffer.append("%" + n21 + " " + s8);
                break;
            }
            default: {
                if (NO_OF_OPERANDS[s2] <= 0) break;
                for (int i3 = 0; i3 < TYPE_OF_OPERANDS[s2].length; ++i3) {
                    switch (TYPE_OF_OPERANDS[s2][i3]) {
                        case 8: {
                            stringBuffer.append(byteSequence.readUnsignedByte());
                            break;
                        }
                        case 9: {
                            stringBuffer.append(byteSequence.readShort());
                            break;
                        }
                        case 10: {
                            stringBuffer.append(byteSequence.readInt());
                            break;
                        }
                        default: {
                            System.err.println("Unreachable default case reached!");
                            System.exit(-1);
                        }
                    }
                    stringBuffer.append("&nbsp;");
                }
            }
        }
        stringBuffer.append("</TD>");
        return stringBuffer.toString();
    }

    private final void findGotos(ByteSequence byteSequence, Method method, Code code) throws IOException {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        this.goto_set = new BitSet(byteSequence.available());
        if (code != null) {
            CodeException[] codeExceptionArray = code.getExceptionTable();
            n6 = codeExceptionArray.length;
            for (int i2 = 0; i2 < n6; ++i2) {
                this.goto_set.set(codeExceptionArray[i2].getStartPC());
                this.goto_set.set(codeExceptionArray[i2].getEndPC());
                this.goto_set.set(codeExceptionArray[i2].getHandlerPC());
            }
            Attribute[] attributeArray = code.getAttributes();
            for (n5 = 0; n5 < attributeArray.length; ++n5) {
                if (attributeArray[n5].getTag() != 5) continue;
                LocalVariable[] localVariableArray = ((LocalVariableTable)attributeArray[n5]).getLocalVariableTable();
                for (n4 = 0; n4 < localVariableArray.length; ++n4) {
                    n3 = localVariableArray[n4].getStartPC();
                    n2 = n3 + localVariableArray[n4].getLength();
                    this.goto_set.set(n3);
                    this.goto_set.set(n2);
                }
                break;
            }
        }
        int n7 = 0;
        while (byteSequence.available() > 0) {
            int n8 = byteSequence.readUnsignedByte();
            switch (n8) {
                case 170: 
                case 171: {
                    int n9;
                    n6 = byteSequence.getIndex() % 4;
                    int n10 = n6 == 0 ? 0 : 4 - n6;
                    for (n4 = 0; n4 < n10; ++n4) {
                        byteSequence.readByte();
                    }
                    n5 = byteSequence.readInt();
                    if (n8 == 170) {
                        n4 = byteSequence.readInt();
                        n3 = byteSequence.readInt();
                        int n11 = byteSequence.getIndex() - 12 - n10 - 1;
                        this.goto_set.set(n5 += n11);
                        for (n2 = 0; n2 < n3 - n4 + 1; ++n2) {
                            n9 = n11 + byteSequence.readInt();
                            this.goto_set.set(n9);
                        }
                    } else {
                        n4 = byteSequence.readInt();
                        int n12 = byteSequence.getIndex() - 8 - n10 - 1;
                        this.goto_set.set(n5 += n12);
                        for (n3 = 0; n3 < n4; ++n3) {
                            n2 = byteSequence.readInt();
                            n9 = n12 + byteSequence.readInt();
                            this.goto_set.set(n9);
                        }
                    }
                    break;
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 167: 
                case 168: 
                case 198: 
                case 199: {
                    int n9 = byteSequence.getIndex() + byteSequence.readShort() - 1;
                    this.goto_set.set(n9);
                    break;
                }
                case 200: 
                case 201: {
                    int n9 = byteSequence.getIndex() + byteSequence.readInt() - 1;
                    this.goto_set.set(n9);
                    break;
                }
                default: {
                    byteSequence.unreadByte();
                    this.codeToHTML(byteSequence, 0);
                }
            }
            ++n7;
        }
    }

    private void writeMethod(Method method, int n2) throws IOException {
        int n3;
        String string = method.getSignature();
        String[] stringArray = Utility.methodSignatureArgumentTypes(string, false);
        String string2 = Utility.methodSignatureReturnType(string, false);
        String string3 = method.getName();
        String string4 = Class2HTML.toHTML(string3);
        String string5 = Utility.accessToString(method.getAccessFlags());
        string5 = Utility.replace(string5, " ", "&nbsp;");
        Attribute[] attributeArray = method.getAttributes();
        this.file.print("<P><B><FONT COLOR=\"#FF0000\">" + string5 + "</FONT>&nbsp;" + "<A NAME=method" + n2 + ">" + Class2HTML.referenceType(string2) + "</A>&nbsp<A HREF=\"" + this.class_name + "_methods.html#method" + n2 + "\" TARGET=Methods>" + string4 + "</A>(");
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            this.file.print(Class2HTML.referenceType(stringArray[i2]));
            if (i2 >= stringArray.length - 1) continue;
            this.file.print(",&nbsp;");
        }
        this.file.println(")</B></P>");
        Code code = null;
        byte[] byArray = null;
        if (attributeArray.length > 0) {
            this.file.print("<H4>Attributes</H4><UL>\n");
            for (int i3 = 0; i3 < attributeArray.length; ++i3) {
                n3 = attributeArray[i3].getTag();
                if (n3 != -1) {
                    this.file.print("<LI><A HREF=\"" + this.class_name + "_attributes.html#method" + n2 + "@" + i3 + "\" TARGET=Attributes>" + ATTRIBUTE_NAMES[n3] + "</A></LI>\n");
                } else {
                    this.file.print("<LI>" + attributeArray[i3] + "</LI>");
                }
                if (n3 != 2) continue;
                code = (Code)attributeArray[i3];
                Attribute[] attributeArray2 = code.getAttributes();
                byArray = code.getCode();
                this.file.print("<UL>");
                for (int i4 = 0; i4 < attributeArray2.length; ++i4) {
                    n3 = attributeArray2[i4].getTag();
                    this.file.print("<LI><A HREF=\"" + this.class_name + "_attributes.html#" + "method" + n2 + "@" + i3 + "@" + i4 + "\" TARGET=Attributes>" + ATTRIBUTE_NAMES[n3] + "</A></LI>\n");
                }
                this.file.print("</UL>");
            }
            this.file.println("</UL>");
        }
        if (byArray != null) {
            ByteSequence byteSequence = new ByteSequence(byArray);
            byteSequence.mark(byteSequence.available());
            this.findGotos(byteSequence, method, code);
            byteSequence.reset();
            this.file.println("<TABLE BORDER=0><TR><TH ALIGN=LEFT>Byte<BR>offset</TH><TH ALIGN=LEFT>Instruction</TH><TH ALIGN=LEFT>Argument</TH>");
            n3 = 0;
            while (byteSequence.available() > 0) {
                int n4 = byteSequence.getIndex();
                String string6 = this.codeToHTML(byteSequence, n2);
                String string7 = "";
                if (this.goto_set.get(n4)) {
                    string7 = "<A NAME=code" + n2 + "@" + n4 + "></A>";
                }
                String string8 = byteSequence.getIndex() == byArray.length ? "<A NAME=code" + n2 + "@" + byArray.length + ">" + n4 + "</A>" : "" + n4;
                this.file.println("<TR VALIGN=TOP><TD>" + string8 + "</TD><TD>" + string7 + string6 + "</TR>");
                ++n3;
            }
            this.file.println("<TR><TD> </A></TD></TR>");
            this.file.println("</TABLE>");
        }
    }
}

