/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Bits;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.DirectFloatBufferRU;
import java.nio.FloatBuffer;
import sun.misc.Cleaner;
import sun.misc.Unsafe;
import sun.nio.ch.DirectBuffer;

class DirectFloatBufferU
extends FloatBuffer
implements DirectBuffer {
    protected static final Unsafe unsafe = Bits.unsafe();
    protected static final boolean unaligned = Bits.unaligned();
    protected Object viewedBuffer = null;

    public Object viewedBuffer() {
        return this.viewedBuffer;
    }

    public Cleaner cleaner() {
        return null;
    }

    DirectFloatBufferU(DirectBuffer directBuffer, int n2, int n3, int n4, int n5, int n6) {
        super(n2, n3, n4, n5);
        this.address = directBuffer.address() + (long)n6;
        this.viewedBuffer = directBuffer;
    }

    public FloatBuffer slice() {
        int n2 = this.position();
        int n3 = this.limit();
        assert (n2 <= n3);
        int n4 = n2 <= n3 ? n3 - n2 : 0;
        int n5 = n2 << 2;
        assert (n5 >= 0);
        return new DirectFloatBufferU(this, -1, 0, n4, n4, n5);
    }

    public FloatBuffer duplicate() {
        return new DirectFloatBufferU(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    public FloatBuffer asReadOnlyBuffer() {
        return new DirectFloatBufferRU(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    public long address() {
        return this.address;
    }

    private long ix(int n2) {
        return this.address + (long)(n2 << 2);
    }

    public float get() {
        return unsafe.getFloat(this.ix(this.nextGetIndex()));
    }

    public float get(int n2) {
        return unsafe.getFloat(this.ix(this.checkIndex(n2)));
    }

    public FloatBuffer get(float[] fArray, int n2, int n3) {
        if (n3 << 2 > 6) {
            int n4;
            DirectFloatBufferU.checkBounds(n2, n3, fArray.length);
            int n5 = this.position();
            int n6 = this.limit();
            assert (n5 <= n6);
            int n7 = n4 = n5 <= n6 ? n6 - n5 : 0;
            if (n3 > n4) {
                throw new BufferUnderflowException();
            }
            if (this.order() != ByteOrder.nativeOrder()) {
                Bits.copyToIntArray(this.ix(n5), fArray, n2 << 2, n3 << 2);
            } else {
                Bits.copyToByteArray(this.ix(n5), fArray, n2 << 2, n3 << 2);
            }
            this.position(n5 + n3);
        } else {
            super.get(fArray, n2, n3);
        }
        return this;
    }

    public FloatBuffer put(float f2) {
        unsafe.putFloat(this.ix(this.nextPutIndex()), f2);
        return this;
    }

    public FloatBuffer put(int n2, float f2) {
        unsafe.putFloat(this.ix(this.checkIndex(n2)), f2);
        return this;
    }

    public FloatBuffer put(FloatBuffer floatBuffer) {
        if (floatBuffer instanceof DirectFloatBufferU) {
            int n2;
            if (floatBuffer == this) {
                throw new IllegalArgumentException();
            }
            DirectFloatBufferU directFloatBufferU = (DirectFloatBufferU)floatBuffer;
            int n3 = directFloatBufferU.position();
            int n4 = directFloatBufferU.limit();
            assert (n3 <= n4);
            int n5 = n3 <= n4 ? n4 - n3 : 0;
            int n6 = this.position();
            int n7 = this.limit();
            assert (n6 <= n7);
            int n8 = n2 = n6 <= n7 ? n7 - n6 : 0;
            if (n5 > n2) {
                throw new BufferOverflowException();
            }
            unsafe.copyMemory(directFloatBufferU.ix(n3), this.ix(n6), n5 << 2);
            directFloatBufferU.position(n3 + n5);
            this.position(n6 + n5);
        } else if (!floatBuffer.isDirect()) {
            int n9 = floatBuffer.position();
            int n10 = floatBuffer.limit();
            assert (n9 <= n10);
            int n11 = n9 <= n10 ? n10 - n9 : 0;
            this.put(floatBuffer.hb, floatBuffer.offset + n9, n11);
            floatBuffer.position(n9 + n11);
        } else {
            super.put(floatBuffer);
        }
        return this;
    }

    public FloatBuffer put(float[] fArray, int n2, int n3) {
        if (n3 << 2 > 6) {
            int n4;
            DirectFloatBufferU.checkBounds(n2, n3, fArray.length);
            int n5 = this.position();
            int n6 = this.limit();
            assert (n5 <= n6);
            int n7 = n4 = n5 <= n6 ? n6 - n5 : 0;
            if (n3 > n4) {
                throw new BufferOverflowException();
            }
            if (this.order() != ByteOrder.nativeOrder()) {
                Bits.copyFromIntArray(fArray, n2 << 2, this.ix(n5), n3 << 2);
            } else {
                Bits.copyFromByteArray(fArray, n2 << 2, this.ix(n5), n3 << 2);
            }
            this.position(n5 + n3);
        } else {
            super.put(fArray, n2, n3);
        }
        return this;
    }

    public FloatBuffer compact() {
        int n2 = this.position();
        int n3 = this.limit();
        assert (n2 <= n3);
        int n4 = n2 <= n3 ? n3 - n2 : 0;
        unsafe.copyMemory(this.ix(n2), this.ix(0), n4 << 2);
        this.position(n4);
        this.limit(this.capacity());
        return this;
    }

    public boolean isDirect() {
        return true;
    }

    public boolean isReadOnly() {
        return false;
    }

    public ByteOrder order() {
        return ByteOrder.nativeOrder() != ByteOrder.BIG_ENDIAN ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
    }
}

