/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.BreakIterator;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.MissingResourceException;
import sun.text.CompactByteArray;
import sun.text.SupplementaryCharacterData;

class RuleBasedBreakIterator
extends BreakIterator {
    protected static final byte IGNORE = -1;
    private static final short START_STATE = 1;
    private static final short STOP_STATE = 0;
    static final byte[] LABEL = new byte[]{66, 73, 100, 97, 116, 97, 0};
    static final int LABEL_LENGTH = LABEL.length;
    static final byte supportedVersion = 1;
    private static final int HEADER_LENGTH = 36;
    private static final int BMP_INDICES_LENGTH = 512;
    private CompactByteArray charCategoryTable = null;
    private SupplementaryCharacterData supplementaryCharCategoryTable = null;
    private short[] stateTable = null;
    private short[] backwardsStateTable = null;
    private boolean[] endStates = null;
    private boolean[] lookaheadStates = null;
    private byte[] additionalData = null;
    private int numCategories;
    private CharacterIterator text = null;
    private long checksum;

    public RuleBasedBreakIterator(String string) throws IOException, MissingResourceException {
        this.readTables(string);
    }

    protected void readTables(String string) throws IOException, MissingResourceException {
        byte[] byArray = this.readFile(string);
        int n2 = BreakIterator.getInt(byArray, 0);
        int n3 = BreakIterator.getInt(byArray, 4);
        int n4 = BreakIterator.getInt(byArray, 8);
        int n5 = BreakIterator.getInt(byArray, 12);
        int n6 = BreakIterator.getInt(byArray, 16);
        int n7 = BreakIterator.getInt(byArray, 20);
        int n8 = BreakIterator.getInt(byArray, 24);
        this.checksum = BreakIterator.getLong(byArray, 28);
        this.stateTable = new short[n2];
        int n9 = 36;
        int n10 = 0;
        while (n10 < n2) {
            this.stateTable[n10] = BreakIterator.getShort(byArray, n9);
            ++n10;
            n9 += 2;
        }
        this.backwardsStateTable = new short[n3];
        n10 = 0;
        while (n10 < n3) {
            this.backwardsStateTable[n10] = BreakIterator.getShort(byArray, n9);
            ++n10;
            n9 += 2;
        }
        this.endStates = new boolean[n4];
        n10 = 0;
        while (n10 < n4) {
            this.endStates[n10] = byArray[n9] == 1;
            ++n10;
            ++n9;
        }
        this.lookaheadStates = new boolean[n5];
        n10 = 0;
        while (n10 < n5) {
            this.lookaheadStates[n10] = byArray[n9] == 1;
            ++n10;
            ++n9;
        }
        short[] sArray = new short[512];
        int n11 = 0;
        while (n11 < 512) {
            sArray[n11] = BreakIterator.getShort(byArray, n9);
            ++n11;
            n9 += 2;
        }
        byte[] byArray2 = new byte[n6];
        System.arraycopy(byArray, n9, byArray2, 0, n6);
        n9 += n6;
        this.charCategoryTable = new CompactByteArray(sArray, byArray2);
        int[] nArray = new int[n7];
        int n12 = 0;
        while (n12 < n7) {
            nArray[n12] = BreakIterator.getInt(byArray, n9);
            ++n12;
            n9 += 4;
        }
        this.supplementaryCharCategoryTable = new SupplementaryCharacterData(nArray);
        if (n8 > 0) {
            this.additionalData = new byte[n8];
            System.arraycopy(byArray, n9, this.additionalData, 0, n8);
        }
        this.numCategories = this.stateTable.length / this.endStates.length;
    }

    protected byte[] readFile(final String string) throws IOException, MissingResourceException {
        BufferedInputStream bufferedInputStream;
        try {
            bufferedInputStream = (BufferedInputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return new BufferedInputStream(this.getClass().getResourceAsStream("/sun/text/resources/" + string));
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new InternalError(privilegedActionException.toString());
        }
        int n2 = 0;
        int n3 = LABEL_LENGTH + 5;
        byte[] byArray = new byte[n3];
        if (bufferedInputStream.read(byArray) != n3) {
            throw new MissingResourceException("Wrong header length", string, "");
        }
        int n4 = 0;
        while (n4 < LABEL_LENGTH) {
            if (byArray[n2] != LABEL[n2]) {
                throw new MissingResourceException("Wrong magic number", string, "");
            }
            ++n4;
            ++n2;
        }
        if (byArray[n2] != 1) {
            throw new MissingResourceException("Unsupported version(" + byArray[n2] + ")", string, "");
        }
        if (bufferedInputStream.read(byArray = new byte[n3 = BreakIterator.getInt(byArray, ++n2)]) != n3) {
            throw new MissingResourceException("Wrong data length", string, "");
        }
        bufferedInputStream.close();
        return byArray;
    }

    byte[] getAdditionalData() {
        return this.additionalData;
    }

    void setAdditionalData(byte[] byArray) {
        this.additionalData = byArray;
    }

    public Object clone() {
        RuleBasedBreakIterator ruleBasedBreakIterator = (RuleBasedBreakIterator)super.clone();
        if (this.text != null) {
            ruleBasedBreakIterator.text = (CharacterIterator)this.text.clone();
        }
        return ruleBasedBreakIterator;
    }

    public boolean equals(Object object) {
        try {
            if (object == null) {
                return false;
            }
            RuleBasedBreakIterator ruleBasedBreakIterator = (RuleBasedBreakIterator)object;
            if (this.checksum != ruleBasedBreakIterator.checksum) {
                return false;
            }
            if (this.text == null) {
                return ruleBasedBreakIterator.text == null;
            }
            return this.text.equals(ruleBasedBreakIterator.text);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[');
        stringBuffer.append("checksum=0x" + Long.toHexString(this.checksum));
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public int hashCode() {
        return (int)this.checksum;
    }

    public int first() {
        CharacterIterator characterIterator = this.getText();
        characterIterator.first();
        return characterIterator.getIndex();
    }

    public int last() {
        CharacterIterator characterIterator = this.getText();
        characterIterator.setIndex(characterIterator.getEndIndex());
        return characterIterator.getIndex();
    }

    public int next(int n2) {
        int n3 = this.current();
        while (n2 > 0) {
            n3 = this.handleNext();
            --n2;
        }
        while (n2 < 0) {
            n3 = this.previous();
            ++n2;
        }
        return n3;
    }

    public int next() {
        return this.handleNext();
    }

    public int previous() {
        int n2;
        CharacterIterator characterIterator = this.getText();
        if (this.current() == characterIterator.getBeginIndex()) {
            return -1;
        }
        int n3 = this.current();
        this.getPrevious();
        int n4 = n2 = this.handlePrevious();
        while (n4 != -1 && n4 < n3) {
            n2 = n4;
            n4 = this.handleNext();
        }
        characterIterator.setIndex(n2);
        return n2;
    }

    private int getPrevious() {
        char c2 = this.text.previous();
        if (Character.isLowSurrogate(c2) && this.text.getIndex() > this.text.getBeginIndex()) {
            char c3 = this.text.previous();
            if (Character.isHighSurrogate(c3)) {
                return Character.toCodePoint(c3, c2);
            }
            this.text.next();
        }
        return c2;
    }

    int getCurrent() {
        char c2 = this.text.current();
        if (Character.isHighSurrogate(c2) && this.text.getIndex() < this.text.getEndIndex()) {
            char c3 = this.text.next();
            this.text.previous();
            if (Character.isLowSurrogate(c3)) {
                return Character.toCodePoint(c2, c3);
            }
        }
        return c2;
    }

    private int getCurrentCodePointCount() {
        char c2 = this.text.current();
        if (Character.isHighSurrogate(c2) && this.text.getIndex() < this.text.getEndIndex()) {
            char c3 = this.text.next();
            this.text.previous();
            if (Character.isLowSurrogate(c3)) {
                return 2;
            }
        }
        return 1;
    }

    int getNext() {
        int n2;
        int n3 = this.text.getIndex();
        if (n3 == (n2 = this.text.getEndIndex()) || (n3 += this.getCurrentCodePointCount()) >= n2) {
            return 65535;
        }
        this.text.setIndex(n3);
        return this.getCurrent();
    }

    private int getNextIndex() {
        int n2;
        int n3 = this.text.getIndex() + this.getCurrentCodePointCount();
        if (n3 > (n2 = this.text.getEndIndex())) {
            return n2;
        }
        return n3;
    }

    protected static final void checkOffset(int n2, CharacterIterator characterIterator) {
        if (n2 < characterIterator.getBeginIndex() || n2 >= characterIterator.getEndIndex()) {
            throw new IllegalArgumentException("offset out of bounds");
        }
    }

    public int following(int n2) {
        CharacterIterator characterIterator = this.getText();
        RuleBasedBreakIterator.checkOffset(n2, characterIterator);
        characterIterator.setIndex(n2);
        if (n2 == characterIterator.getBeginIndex()) {
            return this.handleNext();
        }
        int n3 = this.handlePrevious();
        while (n3 != -1 && n3 <= n2) {
            n3 = this.handleNext();
        }
        return n3;
    }

    public int preceding(int n2) {
        CharacterIterator characterIterator = this.getText();
        RuleBasedBreakIterator.checkOffset(n2, characterIterator);
        characterIterator.setIndex(n2);
        return this.previous();
    }

    public boolean isBoundary(int n2) {
        CharacterIterator characterIterator = this.getText();
        RuleBasedBreakIterator.checkOffset(n2, characterIterator);
        if (n2 == characterIterator.getBeginIndex()) {
            return true;
        }
        return this.following(n2 - 1) == n2;
    }

    public int current() {
        return this.getText().getIndex();
    }

    public CharacterIterator getText() {
        if (this.text == null) {
            this.text = new StringCharacterIterator("");
        }
        return this.text;
    }

    public void setText(CharacterIterator characterIterator) {
        boolean bl2;
        int n2 = characterIterator.getEndIndex();
        try {
            characterIterator.setIndex(n2);
            bl2 = characterIterator.getIndex() == n2;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            bl2 = false;
        }
        this.text = bl2 ? characterIterator : new SafeCharIterator(characterIterator);
        this.text.first();
    }

    protected int handleNext() {
        CharacterIterator characterIterator = this.getText();
        if (characterIterator.getIndex() == characterIterator.getEndIndex()) {
            return -1;
        }
        int n2 = this.getNextIndex();
        int n3 = 0;
        int n4 = 1;
        int n5 = this.getCurrent();
        while (n5 != 65535 && n4 != 0) {
            int n6 = this.lookupCategory(n5);
            if (n6 != -1) {
                n4 = this.lookupState(n4, n6);
            }
            if (this.lookaheadStates[n4]) {
                if (this.endStates[n4]) {
                    n2 = n3;
                } else {
                    n3 = this.getNextIndex();
                }
            } else if (this.endStates[n4]) {
                n2 = this.getNextIndex();
            }
            n5 = this.getNext();
        }
        if (n5 == 65535 && n3 == characterIterator.getEndIndex()) {
            n2 = n3;
        }
        characterIterator.setIndex(n2);
        return n2;
    }

    protected int handlePrevious() {
        CharacterIterator characterIterator = this.getText();
        int n2 = 1;
        int n3 = 0;
        int n4 = 0;
        int n5 = this.getCurrent();
        while (n5 != 65535 && n2 != 0) {
            n4 = n3;
            n3 = this.lookupCategory(n5);
            if (n3 != -1) {
                n2 = this.lookupBackwardState(n2, n3);
            }
            n5 = this.getPrevious();
        }
        if (n5 != 65535) {
            if (n4 != -1) {
                this.getNext();
                this.getNext();
            } else {
                this.getNext();
            }
        }
        return characterIterator.getIndex();
    }

    protected int lookupCategory(int n2) {
        if (n2 < 65536) {
            return this.charCategoryTable.elementAt((char)n2);
        }
        return this.supplementaryCharCategoryTable.getValue(n2);
    }

    protected int lookupState(int n2, int n3) {
        return this.stateTable[n2 * this.numCategories + n3];
    }

    protected int lookupBackwardState(int n2, int n3) {
        return this.backwardsStateTable[n2 * this.numCategories + n3];
    }

    private static final class SafeCharIterator
    implements CharacterIterator,
    Cloneable {
        private CharacterIterator base;
        private int rangeStart;
        private int rangeLimit;
        private int currentIndex;

        SafeCharIterator(CharacterIterator characterIterator) {
            this.base = characterIterator;
            this.rangeStart = characterIterator.getBeginIndex();
            this.rangeLimit = characterIterator.getEndIndex();
            this.currentIndex = characterIterator.getIndex();
        }

        public char first() {
            return this.setIndex(this.rangeStart);
        }

        public char last() {
            return this.setIndex(this.rangeLimit - 1);
        }

        public char current() {
            if (this.currentIndex < this.rangeStart || this.currentIndex >= this.rangeLimit) {
                return '\uffff';
            }
            return this.base.setIndex(this.currentIndex);
        }

        public char next() {
            ++this.currentIndex;
            if (this.currentIndex >= this.rangeLimit) {
                this.currentIndex = this.rangeLimit;
                return '\uffff';
            }
            return this.base.setIndex(this.currentIndex);
        }

        public char previous() {
            --this.currentIndex;
            if (this.currentIndex < this.rangeStart) {
                this.currentIndex = this.rangeStart;
                return '\uffff';
            }
            return this.base.setIndex(this.currentIndex);
        }

        public char setIndex(int n2) {
            if (n2 < this.rangeStart || n2 > this.rangeLimit) {
                throw new IllegalArgumentException("Invalid position");
            }
            this.currentIndex = n2;
            return this.current();
        }

        public int getBeginIndex() {
            return this.rangeStart;
        }

        public int getEndIndex() {
            return this.rangeLimit;
        }

        public int getIndex() {
            return this.currentIndex;
        }

        public Object clone() {
            CharacterIterator characterIterator;
            SafeCharIterator safeCharIterator = null;
            try {
                safeCharIterator = (SafeCharIterator)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new Error("Clone not supported: " + cloneNotSupportedException);
            }
            safeCharIterator.base = characterIterator = (CharacterIterator)this.base.clone();
            return safeCharIterator;
        }
    }
}

