/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.RandomAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Vector<E>
extends AbstractList<E>
implements List<E>,
RandomAccess,
Cloneable,
Serializable {
    protected Object[] elementData;
    protected int elementCount;
    protected int capacityIncrement;
    private static final long serialVersionUID = -2767605614048989439L;

    public Vector(int n2, int n3) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + n2);
        }
        this.elementData = new Object[n2];
        this.capacityIncrement = n3;
    }

    public Vector(int n2) {
        this(n2, 0);
    }

    public Vector() {
        this(10);
    }

    public Vector(Collection<? extends E> collection) {
        this.elementCount = collection.size();
        this.elementData = new Object[(int)Math.min((long)this.elementCount * 110L / 100L, Integer.MAX_VALUE)];
        collection.toArray(this.elementData);
    }

    public synchronized void copyInto(Object[] objectArray) {
        System.arraycopy(this.elementData, 0, objectArray, 0, this.elementCount);
    }

    public synchronized void trimToSize() {
        ++this.modCount;
        int n2 = this.elementData.length;
        if (this.elementCount < n2) {
            Object[] objectArray = this.elementData;
            this.elementData = new Object[this.elementCount];
            System.arraycopy(objectArray, 0, this.elementData, 0, this.elementCount);
        }
    }

    public synchronized void ensureCapacity(int n2) {
        ++this.modCount;
        this.ensureCapacityHelper(n2);
    }

    private void ensureCapacityHelper(int n2) {
        int n3 = this.elementData.length;
        if (n2 > n3) {
            int n4;
            Object[] objectArray = this.elementData;
            int n5 = n4 = this.capacityIncrement > 0 ? n3 + this.capacityIncrement : n3 * 2;
            if (n4 < n2) {
                n4 = n2;
            }
            this.elementData = new Object[n4];
            System.arraycopy(objectArray, 0, this.elementData, 0, this.elementCount);
        }
    }

    public synchronized void setSize(int n2) {
        ++this.modCount;
        if (n2 > this.elementCount) {
            this.ensureCapacityHelper(n2);
        } else {
            for (int i2 = n2; i2 < this.elementCount; ++i2) {
                this.elementData[i2] = null;
            }
        }
        this.elementCount = n2;
    }

    public synchronized int capacity() {
        return this.elementData.length;
    }

    @Override
    public synchronized int size() {
        return this.elementCount;
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.elementCount == 0;
    }

    public Enumeration<E> elements() {
        return new Enumeration<E>(){
            int count = 0;

            @Override
            public boolean hasMoreElements() {
                return this.count < Vector.this.elementCount;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public E nextElement() {
                Vector vector = Vector.this;
                synchronized (vector) {
                    if (this.count < Vector.this.elementCount) {
                        return Vector.this.elementData[this.count++];
                    }
                }
                throw new NoSuchElementException("Vector Enumeration");
            }
        };
    }

    @Override
    public boolean contains(Object object) {
        return this.indexOf(object, 0) >= 0;
    }

    @Override
    public int indexOf(Object object) {
        return this.indexOf(object, 0);
    }

    public synchronized int indexOf(Object object, int n2) {
        if (object == null) {
            for (int i2 = n2; i2 < this.elementCount; ++i2) {
                if (this.elementData[i2] != null) continue;
                return i2;
            }
        } else {
            for (int i3 = n2; i3 < this.elementCount; ++i3) {
                if (!object.equals(this.elementData[i3])) continue;
                return i3;
            }
        }
        return -1;
    }

    @Override
    public synchronized int lastIndexOf(Object object) {
        return this.lastIndexOf(object, this.elementCount - 1);
    }

    public synchronized int lastIndexOf(Object object, int n2) {
        if (n2 >= this.elementCount) {
            throw new IndexOutOfBoundsException(n2 + " >= " + this.elementCount);
        }
        if (object == null) {
            for (int i2 = n2; i2 >= 0; --i2) {
                if (this.elementData[i2] != null) continue;
                return i2;
            }
        } else {
            for (int i3 = n2; i3 >= 0; --i3) {
                if (!object.equals(this.elementData[i3])) continue;
                return i3;
            }
        }
        return -1;
    }

    public synchronized E elementAt(int n2) {
        if (n2 >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n2 + " >= " + this.elementCount);
        }
        return (E)this.elementData[n2];
    }

    public synchronized E firstElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return (E)this.elementData[0];
    }

    public synchronized E lastElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return (E)this.elementData[this.elementCount - 1];
    }

    public synchronized void setElementAt(E e2, int n2) {
        if (n2 >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n2 + " >= " + this.elementCount);
        }
        this.elementData[n2] = e2;
    }

    public synchronized void removeElementAt(int n2) {
        ++this.modCount;
        if (n2 >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n2 + " >= " + this.elementCount);
        }
        if (n2 < 0) {
            throw new ArrayIndexOutOfBoundsException(n2);
        }
        int n3 = this.elementCount - n2 - 1;
        if (n3 > 0) {
            System.arraycopy(this.elementData, n2 + 1, this.elementData, n2, n3);
        }
        --this.elementCount;
        this.elementData[this.elementCount] = null;
    }

    public synchronized void insertElementAt(E e2, int n2) {
        ++this.modCount;
        if (n2 > this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n2 + " > " + this.elementCount);
        }
        this.ensureCapacityHelper(this.elementCount + 1);
        System.arraycopy(this.elementData, n2, this.elementData, n2 + 1, this.elementCount - n2);
        this.elementData[n2] = e2;
        ++this.elementCount;
    }

    public synchronized void addElement(E e2) {
        ++this.modCount;
        this.ensureCapacityHelper(this.elementCount + 1);
        this.elementData[this.elementCount++] = e2;
    }

    public synchronized boolean removeElement(Object object) {
        ++this.modCount;
        int n2 = this.indexOf(object);
        if (n2 >= 0) {
            this.removeElementAt(n2);
            return true;
        }
        return false;
    }

    public synchronized void removeAllElements() {
        ++this.modCount;
        for (int i2 = 0; i2 < this.elementCount; ++i2) {
            this.elementData[i2] = null;
        }
        this.elementCount = 0;
    }

    public synchronized Object clone() {
        try {
            Vector vector = (Vector)super.clone();
            vector.elementData = new Object[this.elementCount];
            System.arraycopy(this.elementData, 0, vector.elementData, 0, this.elementCount);
            vector.modCount = 0;
            return vector;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    @Override
    public synchronized Object[] toArray() {
        Object[] objectArray = new Object[this.elementCount];
        System.arraycopy(this.elementData, 0, objectArray, 0, this.elementCount);
        return objectArray;
    }

    @Override
    public synchronized <T> T[] toArray(T[] objectArray) {
        if (objectArray.length < this.elementCount) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this.elementCount);
        }
        System.arraycopy(this.elementData, 0, objectArray, 0, this.elementCount);
        if (objectArray.length > this.elementCount) {
            objectArray[this.elementCount] = null;
        }
        return objectArray;
    }

    @Override
    public synchronized E get(int n2) {
        if (n2 >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n2);
        }
        return (E)this.elementData[n2];
    }

    @Override
    public synchronized E set(int n2, E e2) {
        if (n2 >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n2);
        }
        Object object = this.elementData[n2];
        this.elementData[n2] = e2;
        return (E)object;
    }

    @Override
    public synchronized boolean add(E e2) {
        ++this.modCount;
        this.ensureCapacityHelper(this.elementCount + 1);
        this.elementData[this.elementCount++] = e2;
        return true;
    }

    @Override
    public boolean remove(Object object) {
        return this.removeElement(object);
    }

    @Override
    public void add(int n2, E e2) {
        this.insertElementAt(e2, n2);
    }

    @Override
    public synchronized E remove(int n2) {
        ++this.modCount;
        if (n2 >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n2);
        }
        Object object = this.elementData[n2];
        int n3 = this.elementCount - n2 - 1;
        if (n3 > 0) {
            System.arraycopy(this.elementData, n2 + 1, this.elementData, n2, n3);
        }
        this.elementData[--this.elementCount] = null;
        return (E)object;
    }

    @Override
    public void clear() {
        this.removeAllElements();
    }

    @Override
    public synchronized boolean containsAll(Collection<?> collection) {
        return super.containsAll(collection);
    }

    @Override
    public synchronized boolean addAll(Collection<? extends E> collection) {
        ++this.modCount;
        Object[] objectArray = collection.toArray();
        int n2 = objectArray.length;
        this.ensureCapacityHelper(this.elementCount + n2);
        System.arraycopy(objectArray, 0, this.elementData, this.elementCount, n2);
        this.elementCount += n2;
        return n2 != 0;
    }

    @Override
    public synchronized boolean removeAll(Collection<?> collection) {
        return super.removeAll(collection);
    }

    @Override
    public synchronized boolean retainAll(Collection<?> collection) {
        return super.retainAll(collection);
    }

    @Override
    public synchronized boolean addAll(int n2, Collection<? extends E> collection) {
        ++this.modCount;
        if (n2 < 0 || n2 > this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n2);
        }
        Object[] objectArray = collection.toArray();
        int n3 = objectArray.length;
        this.ensureCapacityHelper(this.elementCount + n3);
        int n4 = this.elementCount - n2;
        if (n4 > 0) {
            System.arraycopy(this.elementData, n2, this.elementData, n2 + n3, n4);
        }
        System.arraycopy(objectArray, 0, this.elementData, n2, n3);
        this.elementCount += n3;
        return n3 != 0;
    }

    @Override
    public synchronized boolean equals(Object object) {
        return super.equals(object);
    }

    @Override
    public synchronized int hashCode() {
        return super.hashCode();
    }

    @Override
    public synchronized String toString() {
        return super.toString();
    }

    @Override
    public synchronized List<E> subList(int n2, int n3) {
        return Collections.synchronizedList(super.subList(n2, n3), this);
    }

    @Override
    protected synchronized void removeRange(int n2, int n3) {
        ++this.modCount;
        int n4 = this.elementCount - n3;
        System.arraycopy(this.elementData, n3, this.elementData, n2, n4);
        int n5 = this.elementCount - (n3 - n2);
        while (this.elementCount != n5) {
            this.elementData[--this.elementCount] = null;
        }
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }
}

