/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import com.sun.jmx.mbeanserver.GetPropertyAction;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.QueryExp;

public class ObjectName
implements QueryExp,
Serializable {
    private static final long oldSerialVersionUID = -5467795090068647408L;
    private static final long newSerialVersionUID = 1081892073854801359L;
    private static final ObjectStreamField[] oldSerialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("domain", String.class), new ObjectStreamField("propertyList", Hashtable.class), new ObjectStreamField("propertyListString", String.class), new ObjectStreamField("canonicalName", String.class), new ObjectStreamField("pattern", Boolean.TYPE), new ObjectStreamField("propertyPattern", Boolean.TYPE)};
    private static final ObjectStreamField[] newSerialPersistentFields = new ObjectStreamField[0];
    private static final long serialVersionUID;
    private static final ObjectStreamField[] serialPersistentFields;
    private static boolean compat;
    private static final Property[] _Empty_property_array;
    private static final Hashtable _EmptyPropertyList;
    private transient String _canonicalName;
    private transient Property[] _kp_array;
    private transient Property[] _ca_array;
    private transient int _domain_length = 0;
    private transient Hashtable _propertyList;
    private transient boolean _domain_pattern = false;
    private transient boolean _property_pattern = false;

    private void construct(String string) throws MalformedObjectNameException, NullPointerException {
        char c2;
        if (string == null) {
            throw new NullPointerException("name cannot be null");
        }
        if (string.length() == 0) {
            this._canonicalName = "*:*";
            this._kp_array = _Empty_property_array;
            this._ca_array = _Empty_property_array;
            this._domain_length = 1;
            this._propertyList = null;
            this._domain_pattern = true;
            this._property_pattern = true;
            return;
        }
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        char[] cArray2 = new char[n2];
        int n3 = 0;
        int n4 = 0;
        block18: while (n4 < n2) {
            c2 = cArray[n4];
            switch (c2) {
                case ':': {
                    this._domain_length = n4++;
                    break block18;
                }
                case '=': {
                    int n5 = ++n4;
                    while (n5 < n2 && cArray[n5++] != ':') {
                        if (n5 != n2) continue;
                        throw new MalformedObjectNameException("Domain part must be specified");
                    }
                    continue block18;
                }
                case '\n': {
                    throw new MalformedObjectNameException("Invalid character '\\n' in domain name");
                }
                case '*': 
                case '?': {
                    this._domain_pattern = true;
                }
                default: {
                    ++n4;
                    continue block18;
                }
            }
        }
        if (n4 == n2) {
            throw new MalformedObjectNameException("Key properties cannot be empty");
        }
        System.arraycopy(cArray, 0, cArray2, 0, this._domain_length);
        cArray2[this._domain_length] = 58;
        n3 = this._domain_length + 1;
        HashMap hashMap = new HashMap();
        int n6 = 0;
        String[] stringArray = new String[10];
        this._kp_array = new Property[10];
        this._property_pattern = false;
        while (n4 < n2) {
            int n7;
            boolean bl2;
            String[] stringArray2;
            char c3;
            int n8;
            c2 = cArray[n4];
            if (c2 == '*') {
                if (this._property_pattern) {
                    throw new MalformedObjectNameException("Cannot have several '*' characters in pattern properties");
                }
                this._property_pattern = true;
                if (++n4 < n2 && cArray[n4] != ',') {
                    throw new MalformedObjectNameException("Invalid character found after '*': end of name or ',' expected");
                }
                if (n4 == n2) {
                    if (n6 != 0) break;
                    this._kp_array = _Empty_property_array;
                    this._ca_array = _Empty_property_array;
                    this._propertyList = _EmptyPropertyList;
                    break;
                }
                ++n4;
                continue;
            }
            int n9 = n8 = n4;
            while (n8 < n2 && (c3 = cArray[n8++]) != '=') {
                switch (c3) {
                    case '\n': 
                    case '*': 
                    case ',': 
                    case ':': 
                    case '?': {
                        stringArray2 = c3 == '\n' ? "\\n" : "" + c3;
                        throw new MalformedObjectNameException("Invalid character '" + (String)stringArray2 + "' in key part of property");
                    }
                }
            }
            if (n8 == n2) {
                throw new MalformedObjectNameException("Unterminated key property part");
            }
            if (n8 == n4) {
                throw new MalformedObjectNameException("Invalid key (empty)");
            }
            int n10 = n8;
            int n11 = n10 - n9 - 1;
            if (cArray[n8] == '\"') {
                bl2 = true;
                block22: while (++n8 < n2 && (c3 = cArray[n8]) != '\"') {
                    if (c3 == '\\') {
                        if (++n8 == n2) {
                            throw new MalformedObjectNameException("Unterminated quoted value");
                        }
                        c3 = cArray[n8];
                        switch (c3) {
                            case '\"': 
                            case '*': 
                            case '?': 
                            case '\\': 
                            case 'n': {
                                continue block22;
                            }
                        }
                        throw new MalformedObjectNameException("Invalid escape sequence '\\" + c3 + "' in quoted value");
                    }
                    if (c3 == '\n') {
                        throw new MalformedObjectNameException("Newline in quoted value");
                    }
                    switch (c3) {
                        case '*': 
                        case '?': {
                            throw new MalformedObjectNameException("Invalid unescaped reserved character '" + c3 + "' in quoted value");
                        }
                    }
                }
                if (n8 == n2) {
                    throw new MalformedObjectNameException("Unterminated quoted value");
                }
                n7 = ++n8 - n10;
            } else {
                bl2 = false;
                while (n8 < n2 && (c3 = cArray[n8]) != ',') {
                    switch (c3) {
                        case '\n': 
                        case '\"': 
                        case '*': 
                        case ':': 
                        case '=': 
                        case '?': {
                            stringArray2 = c3 == '\n' ? "\\n" : "" + c3;
                            throw new MalformedObjectNameException("Invalid character '" + c3 + "' in value part of property");
                        }
                    }
                    ++n8;
                }
                n7 = n8 - n10;
            }
            if (n8 == n2 - 1) {
                if (bl2) {
                    throw new MalformedObjectNameException("Invalid ending character `" + cArray[n8] + "'");
                }
                throw new MalformedObjectNameException("Invalid ending comma");
            }
            ++n8;
            Property property = new Property(n9, n11, n7);
            String string2 = string.substring(n9, n9 + n11);
            if (n6 == stringArray.length) {
                stringArray2 = new String[n6 + 10];
                System.arraycopy(stringArray, 0, stringArray2, 0, n6);
                stringArray = stringArray2;
            }
            stringArray[n6] = string2;
            this.addProperty(property, n6, hashMap, string2);
            ++n6;
            n4 = n8;
        }
        this.setCanonicalName(cArray, cArray2, stringArray, hashMap, n3, n6);
    }

    private void construct(String string, Hashtable hashtable) throws MalformedObjectNameException, NullPointerException {
        Object object;
        Object object2;
        if (string == null) {
            throw new NullPointerException("domain cannot be null");
        }
        if (hashtable == null) {
            throw new NullPointerException("key property list cannot be null");
        }
        if (hashtable.isEmpty()) {
            throw new MalformedObjectNameException("key property list cannot be empty");
        }
        if (!this.isDomain(string)) {
            throw new MalformedObjectNameException("Invalid domain: " + string);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string).append(':');
        this._domain_length = string.length();
        int n2 = hashtable.size();
        this._kp_array = new Property[n2];
        String[] stringArray = new String[n2];
        Enumeration enumeration = hashtable.keys();
        HashMap hashMap = new HashMap();
        int n3 = 0;
        while (enumeration.hasMoreElements()) {
            if (n3 > 0) {
                stringBuffer.append(",");
            }
            object2 = "";
            try {
                object2 = (String)enumeration.nextElement();
            }
            catch (Exception exception) {
                throw new MalformedObjectNameException("Invalid key `" + (String)object2 + "'");
            }
            object = "";
            try {
                object = (String)hashtable.get(object2);
            }
            catch (Exception exception) {
                throw new MalformedObjectNameException("Invalid value `" + (String)object + "'");
            }
            int n4 = stringBuffer.length();
            this.checkKey((String)object2);
            stringBuffer.append((String)object2);
            stringArray[n3] = object2;
            stringBuffer.append("=");
            this.checkValue((String)object);
            stringBuffer.append((String)object);
            Property property = new Property(n4, ((String)object2).length(), ((String)object).length());
            this.addProperty(property, n3, hashMap, (String)object2);
            ++n3;
        }
        n3 = stringBuffer.length();
        object2 = new char[n3];
        stringBuffer.getChars(0, n3, (char[])object2, 0);
        object = new char[n3];
        System.arraycopy(object2, 0, object, 0, this._domain_length + 1);
        this.setCanonicalName((char[])object2, (char[])object, stringArray, hashMap, this._domain_length + 1, this._kp_array.length);
    }

    private void addProperty(Property property, int n2, HashMap hashMap, String string) throws MalformedObjectNameException {
        if (hashMap.containsKey(string)) {
            throw new MalformedObjectNameException("key `" + string + "' already defined");
        }
        if (n2 == this._kp_array.length) {
            Property[] propertyArray = new Property[n2 + 10];
            System.arraycopy(this._kp_array, 0, propertyArray, 0, n2);
            this._kp_array = propertyArray;
        }
        this._kp_array[n2] = property;
        hashMap.put(string, property);
    }

    private void setCanonicalName(char[] cArray, char[] cArray2, String[] objectArray, HashMap hashMap, int n2, int n3) {
        if (this._kp_array != _Empty_property_array) {
            int n4;
            Object[] objectArray2 = new String[n3];
            Property[] propertyArray = new Property[n3];
            System.arraycopy(objectArray, 0, objectArray2, 0, n3);
            Arrays.sort(objectArray2);
            objectArray = objectArray2;
            System.arraycopy(this._kp_array, 0, propertyArray, 0, n3);
            this._kp_array = propertyArray;
            this._ca_array = new Property[n3];
            for (n4 = 0; n4 < n3; ++n4) {
                this._ca_array[n4] = (Property)hashMap.get(objectArray[n4]);
            }
            n4 = n3 - 1;
            for (int i2 = 0; i2 <= n4; ++i2) {
                Property property = this._ca_array[i2];
                int n5 = property._key_length + property._value_length + 1;
                System.arraycopy(cArray, property._key_index, cArray2, n2, n5);
                property.setKeyIndex(n2);
                n2 += n5;
                if (i2 == n4) continue;
                cArray2[n2] = 44;
                ++n2;
            }
        }
        if (this._property_pattern) {
            if (this._kp_array != _Empty_property_array) {
                cArray2[n2++] = 44;
            }
            cArray2[n2++] = 42;
        }
        this._canonicalName = new String(cArray2, 0, n2).intern();
    }

    private static final int parseKey(char[] cArray, int n2) throws MalformedObjectNameException {
        int n3 = n2;
        int n4 = n2;
        int n5 = cArray.length;
        block4: while (n3 < n5) {
            char c2 = cArray[n3++];
            switch (c2) {
                case '\n': 
                case '*': 
                case ',': 
                case ':': 
                case '?': {
                    String string = c2 == '\n' ? "\\n" : "" + c2;
                    throw new MalformedObjectNameException("Invalid character in key: `" + string + "'");
                }
                case '=': {
                    n4 = n3 - 1;
                    break block4;
                }
                default: {
                    if (n3 < n5) continue block4;
                    n4 = n3;
                    break block4;
                }
            }
        }
        return n4;
    }

    private static final int parseValue(char[] cArray, int n2) throws MalformedObjectNameException {
        int n3;
        block22: {
            int n4;
            int n5;
            block19: {
                n5 = n2;
                n3 = n2;
                n4 = cArray.length;
                char c2 = cArray[n2];
                if (c2 != '\"') break block19;
                if (++n5 == n4) {
                    throw new MalformedObjectNameException("Invalid quote");
                }
                while (n5 < n4) {
                    char c3;
                    block21: {
                        block20: {
                            c3 = cArray[n5];
                            if (c3 != '\\') break block20;
                            if (++n5 == n4) {
                                throw new MalformedObjectNameException("Invalid unterminated quoted character sequence");
                            }
                            c3 = cArray[n5];
                            switch (c3) {
                                case '*': 
                                case '?': 
                                case '\\': 
                                case 'n': {
                                    break block21;
                                }
                                case '\"': {
                                    if (n5 + 1 == n4) {
                                        throw new MalformedObjectNameException("Missing termination quote");
                                    }
                                    break block21;
                                }
                                default: {
                                    throw new MalformedObjectNameException("Invalid quoted character sequence '\\" + c3 + "'");
                                }
                            }
                        }
                        if (c3 == '\n') {
                            throw new MalformedObjectNameException("Newline in quoted value");
                        }
                        if (c3 == '\"') {
                            ++n5;
                            break;
                        }
                        switch (c3) {
                            case '*': 
                            case '?': {
                                throw new MalformedObjectNameException("Invalid unescaped reserved character '" + c3 + "' in quoted value");
                            }
                        }
                    }
                    if (++n5 < n4 || c3 == '\"') continue;
                    throw new MalformedObjectNameException("Missing termination quote");
                }
                n3 = n5;
                if (n5 < n4 && cArray[n5++] != ',') {
                    throw new MalformedObjectNameException("Invalid quote");
                }
                break block22;
            }
            block12: while (n5 < n4) {
                char c4 = cArray[n5++];
                switch (c4) {
                    case '\n': 
                    case '*': 
                    case ':': 
                    case '=': 
                    case '?': {
                        String string = c4 == '\n' ? "\\n" : "" + c4;
                        throw new MalformedObjectNameException("Invalid character `" + string + "' in value");
                    }
                    case ',': {
                        n3 = n5 - 1;
                        break block12;
                    }
                    default: {
                        if (n5 < n4) continue block12;
                        n3 = n5;
                        break block12;
                    }
                }
            }
        }
        return n3;
    }

    private String checkValue(String string) throws MalformedObjectNameException {
        if (string == null) {
            throw new MalformedObjectNameException("Invalid value (null)");
        }
        int n2 = string.length();
        if (n2 == 0) {
            throw new MalformedObjectNameException("Invalid value (empty)");
        }
        char[] cArray = string.toCharArray();
        int n3 = ObjectName.parseValue(cArray, 0);
        if (n3 < n2) {
            throw new MalformedObjectNameException("Invalid character in value: `" + cArray[n3] + "'");
        }
        return string;
    }

    private String checkKey(String string) throws MalformedObjectNameException {
        if (string == null) {
            throw new MalformedObjectNameException("Invalid key (null)");
        }
        int n2 = string.length();
        if (n2 == 0) {
            throw new MalformedObjectNameException("Invalid key (empty)");
        }
        char[] cArray = string.toCharArray();
        int n3 = ObjectName.parseKey(cArray, 0);
        if (n3 < n2) {
            throw new MalformedObjectNameException("Invalid character in value: `" + cArray[n3] + "'");
        }
        return string;
    }

    private static boolean wildmatch(char[] cArray, char[] cArray2, int n2, int n3) {
        int n4 = cArray.length;
        int n5 = cArray2.length;
        while (n3 < n5) {
            char c2;
            if ((c2 = cArray2[n3++]) == '?') {
                if (++n2 <= n4) continue;
                return false;
            }
            if (c2 == '*') {
                if (n3 >= n5) {
                    return true;
                }
                do {
                    if (!ObjectName.wildmatch(cArray, cArray2, n2, n3)) continue;
                    return true;
                } while (++n2 < n4);
                return false;
            }
            if (n2 < n4 && c2 == cArray[n2++]) continue;
            return false;
        }
        return n2 == n4;
    }

    private boolean isDomain(String string) {
        if (string == null) {
            return true;
        }
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        int n3 = 0;
        while (n3 < n2) {
            char c2 = cArray[n3++];
            switch (c2) {
                case '\n': 
                case ':': {
                    return false;
                }
                case '*': 
                case '?': {
                    this._domain_pattern = true;
                }
            }
        }
        return true;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        if (compat) {
            objectInputStream.defaultReadObject();
        } else {
            objectInputStream.defaultReadObject();
            String string = (String)objectInputStream.readObject();
            try {
                this.construct(string);
            }
            catch (NullPointerException nullPointerException) {
                throw new InvalidObjectException(nullPointerException.toString());
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                throw new InvalidObjectException(malformedObjectNameException.toString());
            }
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (compat) {
            ObjectOutputStream.PutField putField = objectOutputStream.putFields();
            putField.put("domain", this._canonicalName.substring(0, this._domain_length));
            putField.put("propertyList", this.getKeyPropertyList());
            putField.put("propertyListString", this.getKeyPropertyListString());
            putField.put("canonicalName", this._canonicalName);
            putField.put("pattern", this._domain_pattern || this._property_pattern);
            putField.put("propertyPattern", this._property_pattern);
            objectOutputStream.writeFields();
        } else {
            objectOutputStream.defaultWriteObject();
            objectOutputStream.writeObject(this.getSerializedNameString());
        }
    }

    public static ObjectName getInstance(String string) throws MalformedObjectNameException, NullPointerException {
        return new ObjectName(string);
    }

    public static ObjectName getInstance(String string, String string2, String string3) throws MalformedObjectNameException, NullPointerException {
        return new ObjectName(string, string2, string3);
    }

    public static ObjectName getInstance(String string, Hashtable hashtable) throws MalformedObjectNameException, NullPointerException {
        return new ObjectName(string, hashtable);
    }

    public static ObjectName getInstance(ObjectName objectName) throws NullPointerException {
        if (objectName.getClass().equals(ObjectName.class)) {
            return objectName;
        }
        try {
            return new ObjectName(objectName.getSerializedNameString());
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw new IllegalArgumentException("Unexpected: " + malformedObjectNameException);
        }
    }

    public ObjectName(String string) throws MalformedObjectNameException, NullPointerException {
        this.construct(string);
    }

    public ObjectName(String string, String string2, String string3) throws MalformedObjectNameException, NullPointerException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>(1);
        hashtable.put(string2, string3);
        this.construct(string, hashtable);
    }

    public ObjectName(String string, Hashtable hashtable) throws MalformedObjectNameException, NullPointerException {
        this.construct(string, hashtable);
    }

    public boolean isPattern() {
        return this._domain_pattern || this._property_pattern;
    }

    public boolean isDomainPattern() {
        return this._domain_pattern;
    }

    public boolean isPropertyPattern() {
        return this._property_pattern;
    }

    public String getCanonicalName() {
        return this._canonicalName;
    }

    public String getDomain() {
        return this._canonicalName.substring(0, this._domain_length);
    }

    public String getKeyProperty(String string) throws NullPointerException {
        return (String)this._getKeyPropertyList().get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Hashtable _getKeyPropertyList() {
        ObjectName objectName = this;
        synchronized (objectName) {
            if (this._propertyList == null) {
                this._propertyList = new Hashtable();
                int n2 = this._ca_array.length;
                for (int i2 = n2 - 1; i2 >= 0; --i2) {
                    Property property = this._ca_array[i2];
                    this._propertyList.put(property.getKeyString(this._canonicalName), property.getValueString(this._canonicalName));
                }
            }
        }
        return this._propertyList;
    }

    public Hashtable getKeyPropertyList() {
        return (Hashtable)this._getKeyPropertyList().clone();
    }

    public String getKeyPropertyListString() {
        if (this._kp_array.length == 0) {
            return "";
        }
        int n2 = this._canonicalName.length() - this._domain_length - 1 - (this._property_pattern ? 2 : 0);
        char[] cArray = new char[n2];
        char[] cArray2 = this._canonicalName.toCharArray();
        this.writeKeyPropertyListString(cArray2, cArray, 0);
        return new String(cArray);
    }

    private String getSerializedNameString() {
        int n2 = this._canonicalName.length();
        char[] cArray = new char[n2];
        char[] cArray2 = this._canonicalName.toCharArray();
        int n3 = this._domain_length + 1;
        System.arraycopy(cArray2, 0, cArray, 0, n3);
        int n4 = this.writeKeyPropertyListString(cArray2, cArray, n3);
        if (this._property_pattern) {
            if (n4 == n3) {
                cArray[n4] = 42;
            } else {
                cArray[n4] = 44;
                cArray[n4 + 1] = 42;
            }
        }
        return new String(cArray);
    }

    private int writeKeyPropertyListString(char[] cArray, char[] cArray2, int n2) {
        if (this._kp_array.length == 0) {
            return n2;
        }
        char[] cArray3 = cArray2;
        char[] cArray4 = this._canonicalName.toCharArray();
        int n3 = n2;
        int n4 = this._kp_array.length;
        int n5 = n4 - 1;
        for (int i2 = 0; i2 < n4; ++i2) {
            Property property = this._kp_array[i2];
            int n6 = property._key_length + property._value_length + 1;
            System.arraycopy(cArray4, property._key_index, cArray3, n3, n6);
            n3 += n6;
            if (i2 >= n5) continue;
            cArray3[n3++] = 44;
        }
        return n3;
    }

    public String getCanonicalKeyPropertyListString() {
        if (this._ca_array.length == 0) {
            return "";
        }
        int n2 = this._canonicalName.length();
        if (this._property_pattern) {
            n2 -= 2;
        }
        return this._canonicalName.substring(this._domain_length + 1, n2);
    }

    public String toString() {
        return this.getSerializedNameString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ObjectName)) {
            return false;
        }
        ObjectName objectName = (ObjectName)object;
        String string = objectName._canonicalName;
        return this._canonicalName == string;
    }

    public int hashCode() {
        return this._canonicalName.hashCode();
    }

    public static String quote(String string) throws NullPointerException {
        StringBuffer stringBuffer = new StringBuffer("\"");
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            switch (c2) {
                case '\n': {
                    c2 = 'n';
                }
                case '\"': 
                case '*': 
                case '?': 
                case '\\': {
                    stringBuffer.append('\\');
                }
            }
            stringBuffer.append(c2);
        }
        stringBuffer.append('\"');
        return stringBuffer.toString();
    }

    public static String unquote(String string) throws IllegalArgumentException, NullPointerException {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = string.length();
        if (n2 < 2 || string.charAt(0) != '\"' || string.charAt(n2 - 1) != '\"') {
            throw new IllegalArgumentException("Argument not quoted");
        }
        for (int i2 = 1; i2 < n2 - 1; ++i2) {
            char c2;
            block11: {
                block10: {
                    c2 = string.charAt(i2);
                    if (c2 != '\\') break block10;
                    if (i2 == n2 - 2) {
                        throw new IllegalArgumentException("Trailing backslash");
                    }
                    c2 = string.charAt(++i2);
                    switch (c2) {
                        case 'n': {
                            c2 = '\n';
                            break block11;
                        }
                        case '\"': 
                        case '*': 
                        case '?': 
                        case '\\': {
                            break block11;
                        }
                        default: {
                            throw new IllegalArgumentException("Bad character '" + c2 + "' after backslash");
                        }
                    }
                }
                switch (c2) {
                    case '\n': 
                    case '\"': 
                    case '*': 
                    case '?': {
                        throw new IllegalArgumentException("Invalid unescaped character '" + c2 + "' in the string to unquote");
                    }
                }
            }
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    public boolean apply(ObjectName objectName) throws NullPointerException {
        if (objectName == null) {
            throw new NullPointerException();
        }
        if (objectName._domain_pattern || objectName._property_pattern) {
            return false;
        }
        if (!this._domain_pattern && !this._property_pattern) {
            return this._canonicalName.equals(objectName._canonicalName);
        }
        return this.matchDomains(objectName) && this.matchKeys(objectName);
    }

    private final boolean matchDomains(ObjectName objectName) {
        if (this._domain_pattern) {
            char[] cArray = this.getDomain().toCharArray();
            char[] cArray2 = objectName.getDomain().toCharArray();
            return ObjectName.wildmatch(cArray2, cArray, 0, 0);
        }
        return this.getDomain().equals(objectName.getDomain());
    }

    private final boolean matchKeys(ObjectName objectName) {
        if (this._property_pattern) {
            Hashtable hashtable = objectName._getKeyPropertyList();
            Property[] propertyArray = this._ca_array;
            String string = this._canonicalName;
            for (int i2 = propertyArray.length - 1; i2 >= 0; --i2) {
                Property property = propertyArray[i2];
                String string2 = property.getKeyString(string);
                String string3 = (String)hashtable.get(string2);
                if (string3 == null) {
                    return false;
                }
                if (string3.equals(property.getValueString(string))) continue;
                return false;
            }
            return true;
        }
        String string = objectName.getCanonicalKeyPropertyListString();
        String string4 = this.getCanonicalKeyPropertyListString();
        return string.equals(string4);
    }

    public void setMBeanServer(MBeanServer mBeanServer) {
    }

    static {
        compat = false;
        try {
            GetPropertyAction getPropertyAction = new GetPropertyAction("jmx.serial.form");
            String string = (String)AccessController.doPrivileged(getPropertyAction);
            compat = string != null && string.equals("1.0");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (compat) {
            serialPersistentFields = oldSerialPersistentFields;
            serialVersionUID = -5467795090068647408L;
        } else {
            serialPersistentFields = newSerialPersistentFields;
            serialVersionUID = 1081892073854801359L;
        }
        _Empty_property_array = new Property[0];
        _EmptyPropertyList = new Hashtable(1);
    }

    private static final class Property {
        int _key_index;
        int _key_length;
        int _value_length;

        Property(int n2, int n3, int n4) {
            this._key_index = n2;
            this._key_length = n3;
            this._value_length = n4;
        }

        void setKeyIndex(int n2) {
            this._key_index = n2;
        }

        String getKeyString(String string) {
            return string.substring(this._key_index, this._key_index + this._key_length);
        }

        String getValueString(String string) {
            int n2 = this._key_index + this._key_length + 1;
            int n3 = n2 + this._value_length;
            return string.substring(n2, n3);
        }
    }
}

