/*
 * Decompiled with CFR 0.152.
 */
package javax.naming;

import javax.naming.RefAddr;

public class BinaryRefAddr
extends RefAddr {
    private byte[] buf = null;
    private static final long serialVersionUID = -3415254970957330361L;

    public BinaryRefAddr(String string, byte[] byArray) {
        this(string, byArray, 0, byArray.length);
    }

    public BinaryRefAddr(String string, byte[] byArray, int n2, int n3) {
        super(string);
        this.buf = new byte[n3];
        System.arraycopy(byArray, n2, this.buf, 0, n3);
    }

    public Object getContent() {
        return this.buf;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof BinaryRefAddr) {
            BinaryRefAddr binaryRefAddr = (BinaryRefAddr)object;
            if (this.addrType.compareTo(binaryRefAddr.addrType) == 0) {
                if (this.buf == null && binaryRefAddr.buf == null) {
                    return true;
                }
                if (this.buf == null || binaryRefAddr.buf == null || this.buf.length != binaryRefAddr.buf.length) {
                    return false;
                }
                for (int i2 = 0; i2 < this.buf.length; ++i2) {
                    if (this.buf[i2] == binaryRefAddr.buf[i2]) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int n2 = this.addrType.hashCode();
        for (int i2 = 0; i2 < this.buf.length; ++i2) {
            n2 += this.buf[i2];
        }
        return n2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Address Type: " + this.addrType + "\n");
        stringBuffer.append("AddressContents: ");
        for (int i2 = 0; i2 < this.buf.length && i2 < 32; ++i2) {
            stringBuffer.append(Integer.toHexString(this.buf[i2]) + " ");
        }
        if (this.buf.length >= 32) {
            stringBuffer.append(" ...\n");
        }
        return stringBuffer.toString();
    }
}

