/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.io.Serializable;

public class SizeRequirements
implements Serializable {
    public int minimum;
    public int preferred;
    public int maximum;
    public float alignment;

    public SizeRequirements() {
        this.minimum = 0;
        this.preferred = 0;
        this.maximum = 0;
        this.alignment = 0.5f;
    }

    public SizeRequirements(int n2, int n3, int n4, float f2) {
        this.minimum = n2;
        this.preferred = n3;
        this.maximum = n4;
        this.alignment = f2 > 1.0f ? 1.0f : (f2 < 0.0f ? 0.0f : f2);
    }

    public String toString() {
        return "[" + this.minimum + "," + this.preferred + "," + this.maximum + "]@" + this.alignment;
    }

    public static SizeRequirements getTiledSizeRequirements(SizeRequirements[] sizeRequirementsArray) {
        SizeRequirements sizeRequirements = new SizeRequirements();
        for (int i2 = 0; i2 < sizeRequirementsArray.length; ++i2) {
            SizeRequirements sizeRequirements2 = sizeRequirementsArray[i2];
            sizeRequirements.minimum = (int)Math.min((long)sizeRequirements.minimum + (long)sizeRequirements2.minimum, Integer.MAX_VALUE);
            sizeRequirements.preferred = (int)Math.min((long)sizeRequirements.preferred + (long)sizeRequirements2.preferred, Integer.MAX_VALUE);
            sizeRequirements.maximum = (int)Math.min((long)sizeRequirements.maximum + (long)sizeRequirements2.maximum, Integer.MAX_VALUE);
        }
        return sizeRequirements;
    }

    public static SizeRequirements getAlignedSizeRequirements(SizeRequirements[] sizeRequirementsArray) {
        int n2;
        int n3;
        SizeRequirements sizeRequirements = new SizeRequirements();
        SizeRequirements sizeRequirements2 = new SizeRequirements();
        for (n3 = 0; n3 < sizeRequirementsArray.length; ++n3) {
            SizeRequirements sizeRequirements3 = sizeRequirementsArray[n3];
            n2 = (int)(sizeRequirements3.alignment * (float)sizeRequirements3.minimum);
            int n4 = sizeRequirements3.minimum - n2;
            sizeRequirements.minimum = Math.max(n2, sizeRequirements.minimum);
            sizeRequirements2.minimum = Math.max(n4, sizeRequirements2.minimum);
            n2 = (int)(sizeRequirements3.alignment * (float)sizeRequirements3.preferred);
            n4 = sizeRequirements3.preferred - n2;
            sizeRequirements.preferred = Math.max(n2, sizeRequirements.preferred);
            sizeRequirements2.preferred = Math.max(n4, sizeRequirements2.preferred);
            n2 = (int)(sizeRequirements3.alignment * (float)sizeRequirements3.maximum);
            n4 = sizeRequirements3.maximum - n2;
            sizeRequirements.maximum = Math.max(n2, sizeRequirements.maximum);
            sizeRequirements2.maximum = Math.max(n4, sizeRequirements2.maximum);
        }
        n3 = (int)Math.min((long)sizeRequirements.minimum + (long)sizeRequirements2.minimum, Integer.MAX_VALUE);
        int n5 = (int)Math.min((long)sizeRequirements.preferred + (long)sizeRequirements2.preferred, Integer.MAX_VALUE);
        n2 = (int)Math.min((long)sizeRequirements.maximum + (long)sizeRequirements2.maximum, Integer.MAX_VALUE);
        float f2 = 0.0f;
        if (n3 > 0) {
            f2 = (float)sizeRequirements.minimum / (float)n3;
            f2 = f2 > 1.0f ? 1.0f : (f2 < 0.0f ? 0.0f : f2);
        }
        return new SizeRequirements(n3, n5, n2, f2);
    }

    public static void calculateTiledPositions(int n2, SizeRequirements sizeRequirements, SizeRequirements[] sizeRequirementsArray, int[] nArray, int[] nArray2) {
        SizeRequirements.calculateTiledPositions(n2, sizeRequirements, sizeRequirementsArray, nArray, nArray2, true);
    }

    public static void calculateTiledPositions(int n2, SizeRequirements sizeRequirements, SizeRequirements[] sizeRequirementsArray, int[] nArray, int[] nArray2, boolean bl2) {
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        for (int i2 = 0; i2 < sizeRequirementsArray.length; ++i2) {
            l2 += (long)sizeRequirementsArray[i2].minimum;
            l3 += (long)sizeRequirementsArray[i2].preferred;
            l4 += (long)sizeRequirementsArray[i2].maximum;
        }
        if ((long)n2 >= l3) {
            SizeRequirements.expandedTile(n2, l2, l3, l4, sizeRequirementsArray, nArray, nArray2, bl2);
        } else {
            SizeRequirements.compressedTile(n2, l2, l3, l4, sizeRequirementsArray, nArray, nArray2, bl2);
        }
    }

    private static void compressedTile(int n2, long l2, long l3, long l4, SizeRequirements[] sizeRequirementsArray, int[] nArray, int[] nArray2, boolean bl2) {
        float f2;
        float f3 = Math.min(l3 - (long)n2, l3 - l2);
        float f4 = f2 = l3 - l2 == 0L ? 0.0f : f3 / (float)(l3 - l2);
        if (bl2) {
            int n3 = 0;
            for (int i2 = 0; i2 < nArray2.length; ++i2) {
                nArray[i2] = n3;
                SizeRequirements sizeRequirements = sizeRequirementsArray[i2];
                float f5 = f2 * (float)(sizeRequirements.preferred - sizeRequirements.minimum);
                nArray2[i2] = (int)((float)sizeRequirements.preferred - f5);
                n3 = (int)Math.min((long)n3 + (long)nArray2[i2], Integer.MAX_VALUE);
            }
        } else {
            int n4 = n2;
            for (int i3 = 0; i3 < nArray2.length; ++i3) {
                SizeRequirements sizeRequirements = sizeRequirementsArray[i3];
                float f6 = f2 * (float)(sizeRequirements.preferred - sizeRequirements.minimum);
                nArray2[i3] = (int)((float)sizeRequirements.preferred - f6);
                nArray[i3] = n4 - nArray2[i3];
                n4 = (int)Math.max((long)n4 - (long)nArray2[i3], 0L);
            }
        }
    }

    private static void expandedTile(int n2, long l2, long l3, long l4, SizeRequirements[] sizeRequirementsArray, int[] nArray, int[] nArray2, boolean bl2) {
        float f2;
        float f3 = Math.min((long)n2 - l3, l4 - l3);
        float f4 = f2 = l4 - l3 == 0L ? 0.0f : f3 / (float)(l4 - l3);
        if (bl2) {
            int n3 = 0;
            for (int i2 = 0; i2 < nArray2.length; ++i2) {
                nArray[i2] = n3;
                SizeRequirements sizeRequirements = sizeRequirementsArray[i2];
                int n4 = (int)(f2 * (float)(sizeRequirements.maximum - sizeRequirements.preferred));
                nArray2[i2] = (int)Math.min((long)sizeRequirements.preferred + (long)n4, Integer.MAX_VALUE);
                n3 = (int)Math.min((long)n3 + (long)nArray2[i2], Integer.MAX_VALUE);
            }
        } else {
            int n5 = n2;
            for (int i3 = 0; i3 < nArray2.length; ++i3) {
                SizeRequirements sizeRequirements = sizeRequirementsArray[i3];
                int n6 = (int)(f2 * (float)(sizeRequirements.maximum - sizeRequirements.preferred));
                nArray2[i3] = (int)Math.min((long)sizeRequirements.preferred + (long)n6, Integer.MAX_VALUE);
                nArray[i3] = n5 - nArray2[i3];
                n5 = (int)Math.max((long)n5 - (long)nArray2[i3], 0L);
            }
        }
    }

    public static void calculateAlignedPositions(int n2, SizeRequirements sizeRequirements, SizeRequirements[] sizeRequirementsArray, int[] nArray, int[] nArray2) {
        SizeRequirements.calculateAlignedPositions(n2, sizeRequirements, sizeRequirementsArray, nArray, nArray2, true);
    }

    public static void calculateAlignedPositions(int n2, SizeRequirements sizeRequirements, SizeRequirements[] sizeRequirementsArray, int[] nArray, int[] nArray2, boolean bl2) {
        float f2 = bl2 ? sizeRequirements.alignment : 1.0f - sizeRequirements.alignment;
        int n3 = (int)((float)n2 * f2);
        int n4 = n2 - n3;
        for (int i2 = 0; i2 < sizeRequirementsArray.length; ++i2) {
            SizeRequirements sizeRequirements2 = sizeRequirementsArray[i2];
            float f3 = bl2 ? sizeRequirements2.alignment : 1.0f - sizeRequirements2.alignment;
            int n5 = (int)((float)sizeRequirements2.maximum * f3);
            int n6 = sizeRequirements2.maximum - n5;
            int n7 = Math.min(n3, n5);
            int n8 = Math.min(n4, n6);
            nArray[i2] = n3 - n7;
            nArray2[i2] = (int)Math.min((long)n7 + (long)n8, Integer.MAX_VALUE);
        }
    }

    public static int[] adjustSizes(int n2, SizeRequirements[] sizeRequirementsArray) {
        return new int[0];
    }
}

