/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.filechooser.FileSystemView;
import sun.awt.shell.ShellFolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicDirectoryModel
extends AbstractListModel
implements PropertyChangeListener {
    private JFileChooser filechooser = null;
    private Vector fileCache = new Vector(50);
    private LoadFilesThread loadThread = null;
    private Vector files = null;
    private Vector directories = null;
    private int fetchID = 0;

    public BasicDirectoryModel(JFileChooser jFileChooser) {
        this.filechooser = jFileChooser;
        this.validateFileCache();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string == "directoryChanged" || string == "fileViewChanged" || string == "fileFilterChanged" || string == "FileHidingChanged" || string == "fileSelectionChanged") {
            this.validateFileCache();
        }
    }

    public void invalidateFileCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<File> getDirectories() {
        Vector vector = this.fileCache;
        synchronized (vector) {
            if (this.directories != null) {
                return this.directories;
            }
            Vector<File> vector2 = this.getFiles();
            return this.directories;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<File> getFiles() {
        Vector vector = this.fileCache;
        synchronized (vector) {
            if (this.files != null) {
                return this.files;
            }
            this.files = new Vector();
            this.directories = new Vector();
            this.directories.addElement(this.filechooser.getFileSystemView().createFileObject(this.filechooser.getCurrentDirectory(), ".."));
            for (int i2 = 0; i2 < this.getSize(); ++i2) {
                File file = (File)this.fileCache.get(i2);
                if (this.filechooser.isTraversable(file)) {
                    this.directories.add(file);
                    continue;
                }
                this.files.add(file);
            }
            return this.files;
        }
    }

    public void validateFileCache() {
        File file = this.filechooser.getCurrentDirectory();
        if (file == null) {
            return;
        }
        if (this.loadThread != null) {
            this.loadThread.interrupt();
            this.loadThread.cancelRunnables();
        }
        ++this.fetchID;
        this.loadThread = new LoadFilesThread(file, this.fetchID);
        this.loadThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean renameFile(File file, File file2) {
        Vector vector = this.fileCache;
        synchronized (vector) {
            if (file.renameTo(file2)) {
                this.validateFileCache();
                return true;
            }
            return false;
        }
    }

    public void fireContentsChanged() {
        this.fireContentsChanged(this, 0, this.getSize() - 1);
    }

    @Override
    public int getSize() {
        return this.fileCache.size();
    }

    public boolean contains(Object object) {
        return this.fileCache.contains(object);
    }

    public int indexOf(Object object) {
        return this.fileCache.indexOf(object);
    }

    @Override
    public Object getElementAt(int n2) {
        return this.fileCache.get(n2);
    }

    public void intervalAdded(ListDataEvent listDataEvent) {
    }

    public void intervalRemoved(ListDataEvent listDataEvent) {
    }

    protected void sort(Vector<? extends File> vector) {
        ShellFolder.sortFiles(vector);
    }

    protected boolean lt(File file, File file2) {
        int n2 = file.getName().toLowerCase().compareTo(file2.getName().toLowerCase());
        if (n2 != 0) {
            return n2 < 0;
        }
        return file.getName().compareTo(file2.getName()) < 0;
    }

    class DoChangeContents
    implements Runnable {
        private List addFiles;
        private List remFiles;
        private boolean doFire = true;
        private int fid;
        private int addStart = 0;
        private int remStart = 0;
        private int change;

        public DoChangeContents(List list, int n2, List list2, int n3, int n4) {
            this.addFiles = list;
            this.addStart = n2;
            this.remFiles = list2;
            this.remStart = n3;
            this.fid = n4;
        }

        synchronized void cancel() {
            this.doFire = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void run() {
            if (BasicDirectoryModel.this.fetchID == this.fid && this.doFire) {
                int n2 = this.remFiles == null ? 0 : this.remFiles.size();
                int n3 = this.addFiles == null ? 0 : this.addFiles.size();
                Vector vector = BasicDirectoryModel.this.fileCache;
                synchronized (vector) {
                    if (n2 > 0) {
                        BasicDirectoryModel.this.fileCache.removeAll(this.remFiles);
                    }
                    if (n3 > 0) {
                        BasicDirectoryModel.this.fileCache.addAll(this.addStart, this.addFiles);
                    }
                    BasicDirectoryModel.this.files = null;
                    BasicDirectoryModel.this.directories = null;
                }
                if (n2 > 0 && n3 == 0) {
                    BasicDirectoryModel.this.fireIntervalRemoved(BasicDirectoryModel.this, this.remStart, this.remStart + n2 - 1);
                } else if (n3 > 0 && n2 == 0 && BasicDirectoryModel.this.fileCache.size() > n3) {
                    BasicDirectoryModel.this.fireIntervalAdded(BasicDirectoryModel.this, this.addStart, this.addStart + n3 - 1);
                } else {
                    BasicDirectoryModel.this.fireContentsChanged();
                }
            }
        }
    }

    class LoadFilesThread
    extends Thread {
        File currentDirectory;
        int fid;
        Vector runnables;

        public LoadFilesThread(File file, int n2) {
            super("Basic L&F File Loading Thread");
            this.currentDirectory = null;
            this.runnables = new Vector(10);
            this.currentDirectory = file;
            this.fid = n2;
        }

        private void invokeLater(Runnable runnable) {
            this.runnables.addElement(runnable);
            SwingUtilities.invokeLater(runnable);
        }

        public void run() {
            int n2;
            FileSystemView fileSystemView = BasicDirectoryModel.this.filechooser.getFileSystemView();
            File[] fileArray = fileSystemView.getFiles(this.currentDirectory, BasicDirectoryModel.this.filechooser.isFileHidingEnabled());
            Vector<File> vector = new Vector<File>();
            if (this.isInterrupted()) {
                return;
            }
            for (int i2 = 0; i2 < fileArray.length; ++i2) {
                if (!BasicDirectoryModel.this.filechooser.accept(fileArray[i2])) continue;
                vector.addElement(fileArray[i2]);
            }
            if (this.isInterrupted()) {
                return;
            }
            BasicDirectoryModel.this.sort(vector);
            Vector<File> vector2 = new Vector<File>(50);
            Vector<File> vector3 = new Vector<File>();
            for (int i3 = 0; i3 < vector.size(); ++i3) {
                File file = (File)vector.elementAt(i3);
                n2 = BasicDirectoryModel.this.filechooser.isTraversable(file);
                if (n2 != 0) {
                    vector2.addElement(file);
                } else if (n2 == 0 && BasicDirectoryModel.this.filechooser.isFileSelectionEnabled()) {
                    vector3.addElement(file);
                }
                if (!this.isInterrupted()) continue;
                return;
            }
            Vector<File> vector4 = new Vector<File>(vector2);
            vector4.addAll(vector3);
            int n3 = vector4.size();
            n2 = BasicDirectoryModel.this.fileCache.size();
            if (n3 > n2) {
                int n4 = n2;
                int n5 = n3;
                block2: for (int i4 = 0; i4 < n2; ++i4) {
                    if (vector4.get(i4).equals(BasicDirectoryModel.this.fileCache.get(i4))) continue;
                    n4 = i4;
                    for (int i5 = i4; i5 < n3; ++i5) {
                        if (!vector4.get(i5).equals(BasicDirectoryModel.this.fileCache.get(i4))) continue;
                        n5 = i5;
                        break block2;
                    }
                    break;
                }
                if (n4 >= 0 && n5 > n4 && ((Object)vector4.subList(n5, n3)).equals(BasicDirectoryModel.this.fileCache.subList(n4, n2))) {
                    if (this.isInterrupted()) {
                        return;
                    }
                    this.invokeLater(new DoChangeContents(vector4.subList(n4, n5), n4, null, 0, this.fid));
                    vector4 = null;
                }
            } else if (n3 < n2) {
                int n6 = -1;
                int n7 = -1;
                for (int i6 = 0; i6 < n3; ++i6) {
                    if (vector4.get(i6).equals(BasicDirectoryModel.this.fileCache.get(i6))) continue;
                    n6 = i6;
                    n7 = i6 + n2 - n3;
                    break;
                }
                if (n6 >= 0 && n7 > n6 && ((Object)BasicDirectoryModel.this.fileCache.subList(n7, n2)).equals(vector4.subList(n6, n3))) {
                    if (this.isInterrupted()) {
                        return;
                    }
                    this.invokeLater(new DoChangeContents(null, 0, new Vector(BasicDirectoryModel.this.fileCache.subList(n6, n7)), n6, this.fid));
                    vector4 = null;
                }
            }
            if (vector4 != null && !BasicDirectoryModel.this.fileCache.equals(vector4)) {
                if (this.isInterrupted()) {
                    this.cancelRunnables(this.runnables);
                }
                this.invokeLater(new DoChangeContents(vector4, 0, BasicDirectoryModel.this.fileCache, 0, this.fid));
            }
        }

        public void cancelRunnables(Vector vector) {
            for (int i2 = 0; i2 < vector.size(); ++i2) {
                ((DoChangeContents)vector.elementAt(i2)).cancel();
            }
        }

        public void cancelRunnables() {
            this.cancelRunnables(this.runnables);
        }
    }
}

