/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.beans.PropertyChangeEvent;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.FieldView;
import javax.swing.text.GlyphView;
import javax.swing.text.JTextComponent;
import javax.swing.text.ParagraphView;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import sun.swing.DefaultLookup;

public class BasicTextFieldUI
extends BasicTextUI {
    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicTextFieldUI();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.updateBackground((JTextComponent)jComponent);
    }

    protected void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("editable") || propertyChangeEvent.getPropertyName().equals("enabled")) {
            this.updateBackground((JTextComponent)propertyChangeEvent.getSource());
        }
    }

    private void updateBackground(JTextComponent jTextComponent) {
        Color color = jTextComponent.getBackground();
        if (color instanceof UIResource) {
            Color color2 = null;
            String string = this.getPropertyPrefix();
            if (!jTextComponent.isEnabled()) {
                color2 = DefaultLookup.getColor(jTextComponent, this, string + ".disabledBackground", null);
            }
            if (color2 == null && !jTextComponent.isEditable()) {
                color2 = DefaultLookup.getColor(jTextComponent, this, string + ".inactiveBackground", null);
            }
            if (color2 == null) {
                color2 = DefaultLookup.getColor(jTextComponent, this, string + ".background", null);
            }
            if (color2 != null && color2 != color) {
                jTextComponent.setBackground(color2);
            }
        }
    }

    protected String getPropertyPrefix() {
        return "TextField";
    }

    public View create(Element element) {
        String string;
        Document document = element.getDocument();
        Object object = document.getProperty("i18n");
        if (object != null && object.equals(Boolean.TRUE) && (string = element.getName()) != null) {
            if (string.equals("content")) {
                return new GlyphView(element);
            }
            if (string.equals("paragraph")) {
                return new I18nFieldView(element);
            }
        }
        return new FieldView(element);
    }

    static class I18nFieldView
    extends ParagraphView {
        I18nFieldView(Element element) {
            super(element);
        }

        public int getFlowSpan(int n2) {
            return Integer.MAX_VALUE;
        }

        protected void setJustification(int n2) {
        }

        static boolean isLeftToRight(Component component) {
            return component.getComponentOrientation().isLeftToRight();
        }

        Shape adjustAllocation(Shape shape) {
            if (shape != null) {
                Container container;
                Rectangle rectangle = shape.getBounds();
                int n2 = (int)this.getPreferredSpan(1);
                int n3 = (int)this.getPreferredSpan(0);
                if (rectangle.height != n2) {
                    int n4 = rectangle.height - n2;
                    rectangle.y += n4 / 2;
                    rectangle.height -= n4;
                }
                if ((container = this.getContainer()) instanceof JTextField) {
                    int n5;
                    JTextField jTextField = (JTextField)container;
                    BoundedRangeModel boundedRangeModel = jTextField.getHorizontalVisibility();
                    int n6 = Math.max(n3, rectangle.width);
                    int n7 = boundedRangeModel.getValue();
                    if (n7 + (n5 = Math.min(n6, rectangle.width - 1)) > n6) {
                        n7 = n6 - n5;
                    }
                    boundedRangeModel.setRangeProperties(n7, n5, boundedRangeModel.getMinimum(), n6, false);
                    if (n3 < rectangle.width) {
                        int n8 = rectangle.width - 1 - n3;
                        int n9 = ((JTextField)container).getHorizontalAlignment();
                        if (I18nFieldView.isLeftToRight(container)) {
                            if (n9 == 10) {
                                n9 = 2;
                            } else if (n9 == 11) {
                                n9 = 4;
                            }
                        } else if (n9 == 10) {
                            n9 = 4;
                        } else if (n9 == 11) {
                            n9 = 2;
                        }
                        switch (n9) {
                            case 0: {
                                rectangle.x += n8 / 2;
                                rectangle.width -= n8;
                                break;
                            }
                            case 4: {
                                rectangle.x += n8;
                                rectangle.width -= n8;
                            }
                        }
                    } else {
                        rectangle.width = n3;
                        rectangle.x -= boundedRangeModel.getValue();
                    }
                }
                return rectangle;
            }
            return null;
        }

        void updateVisibilityModel() {
            Container container = this.getContainer();
            if (container instanceof JTextField) {
                JTextField jTextField = (JTextField)container;
                BoundedRangeModel boundedRangeModel = jTextField.getHorizontalVisibility();
                int n2 = (int)this.getPreferredSpan(0);
                int n3 = boundedRangeModel.getExtent();
                int n4 = Math.max(n2, n3);
                n3 = n3 == 0 ? n4 : n3;
                int n5 = n4 - n3;
                int n6 = boundedRangeModel.getValue();
                if (n6 + n3 > n4) {
                    n6 = n4 - n3;
                }
                n5 = Math.max(0, Math.min(n5, n6));
                boundedRangeModel.setRangeProperties(n5, n3, 0, n4, false);
            }
        }

        public void paint(Graphics graphics, Shape shape) {
            Rectangle rectangle = (Rectangle)shape;
            graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            super.paint(graphics, this.adjustAllocation(shape));
        }

        public int getResizeWeight(int n2) {
            if (n2 == 0) {
                return 1;
            }
            return 0;
        }

        public Shape modelToView(int n2, Shape shape, Position.Bias bias) throws BadLocationException {
            return super.modelToView(n2, this.adjustAllocation(shape), bias);
        }

        public Shape modelToView(int n2, Position.Bias bias, int n3, Position.Bias bias2, Shape shape) throws BadLocationException {
            return super.modelToView(n2, bias, n3, bias2, this.adjustAllocation(shape));
        }

        public int viewToModel(float f2, float f3, Shape shape, Position.Bias[] biasArray) {
            return super.viewToModel(f2, f3, this.adjustAllocation(shape), biasArray);
        }

        public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            super.insertUpdate(documentEvent, this.adjustAllocation(shape), viewFactory);
            this.updateVisibilityModel();
        }

        public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            super.removeUpdate(documentEvent, this.adjustAllocation(shape), viewFactory);
            this.updateVisibilityModel();
        }
    }
}

