/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalUtils;

public class MetalSliderUI
extends BasicSliderUI {
    protected final int TICK_BUFFER = 4;
    protected boolean filledSlider = false;
    protected static Color thumbColor;
    protected static Color highlightColor;
    protected static Color darkShadowColor;
    protected static int trackWidth;
    protected static int tickLength;
    protected static Icon horizThumbIcon;
    protected static Icon vertThumbIcon;
    protected final String SLIDER_FILL = "JSlider.isFilled";

    public static ComponentUI createUI(JComponent jComponent) {
        return new MetalSliderUI();
    }

    public MetalSliderUI() {
        super(null);
    }

    public void installUI(JComponent jComponent) {
        trackWidth = (Integer)UIManager.get("Slider.trackWidth");
        tickLength = (Integer)UIManager.get("Slider.majorTickLength");
        horizThumbIcon = UIManager.getIcon("Slider.horizontalThumbIcon");
        vertThumbIcon = UIManager.getIcon("Slider.verticalThumbIcon");
        super.installUI(jComponent);
        thumbColor = UIManager.getColor("Slider.thumb");
        highlightColor = UIManager.getColor("Slider.highlight");
        darkShadowColor = UIManager.getColor("Slider.darkShadow");
        this.scrollListener.setScrollByBlock(false);
        Object object = jComponent.getClientProperty("JSlider.isFilled");
        if (object != null) {
            this.filledSlider = (Boolean)object;
        }
    }

    protected PropertyChangeListener createPropertyChangeListener(JSlider jSlider) {
        return new MetalPropertyListener();
    }

    public void paintThumb(Graphics graphics) {
        Rectangle rectangle = this.thumbRect;
        graphics.translate(rectangle.x, rectangle.y);
        if (this.slider.getOrientation() == 0) {
            horizThumbIcon.paintIcon(this.slider, graphics, 0, 0);
        } else {
            vertThumbIcon.paintIcon(this.slider, graphics, 0, 0);
        }
        graphics.translate(-rectangle.x, -rectangle.y);
    }

    private Color chooseColor(boolean bl2, Color color, Color color2) {
        if (bl2) {
            return color2;
        }
        return color;
    }

    private Rectangle getPaintTrackRect() {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (this.slider.getOrientation() == 0) {
            n5 = this.trackRect.height - 1 - this.getThumbOverhang();
            n4 = n5 - (this.getTrackWidth() - 1);
            n3 = this.trackRect.width - 1;
        } else {
            if (MetalUtils.isLeftToRight(this.slider)) {
                n2 = this.trackRect.width - this.getThumbOverhang() - this.getTrackWidth();
                n3 = this.trackRect.width - this.getThumbOverhang() - 1;
            } else {
                n2 = this.getThumbOverhang();
                n3 = this.getThumbOverhang() + this.getTrackWidth() - 1;
            }
            n5 = this.trackRect.height - 1;
        }
        return new Rectangle(this.trackRect.x + n2, this.trackRect.y + n4, n3 - n2, n5 - n4);
    }

    public void paintTrack(Graphics graphics) {
        if (MetalLookAndFeel.usingOcean()) {
            this.oceanPaintTrack(graphics);
            return;
        }
        ColorUIResource colorUIResource = !this.slider.isEnabled() ? MetalLookAndFeel.getControlShadow() : this.slider.getForeground();
        boolean bl2 = MetalUtils.isLeftToRight(this.slider);
        graphics.translate(this.trackRect.x, this.trackRect.y);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (this.slider.getOrientation() == 0) {
            n5 = this.trackRect.height - 1 - this.getThumbOverhang();
            n3 = n5 - (this.getTrackWidth() - 1);
            n4 = this.trackRect.width - 1;
        } else {
            if (bl2) {
                n2 = this.trackRect.width - this.getThumbOverhang() - this.getTrackWidth();
                n4 = this.trackRect.width - this.getThumbOverhang() - 1;
            } else {
                n2 = this.getThumbOverhang();
                n4 = this.getThumbOverhang() + this.getTrackWidth() - 1;
            }
            n5 = this.trackRect.height - 1;
        }
        if (this.slider.isEnabled()) {
            graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
            graphics.drawRect(n2, n3, n4 - n2 - 1, n5 - n3 - 1);
            graphics.setColor(MetalLookAndFeel.getControlHighlight());
            graphics.drawLine(n2 + 1, n5, n4, n5);
            graphics.drawLine(n4, n3 + 1, n4, n5);
            graphics.setColor(MetalLookAndFeel.getControlShadow());
            graphics.drawLine(n2 + 1, n3 + 1, n4 - 2, n3 + 1);
            graphics.drawLine(n2 + 1, n3 + 1, n2 + 1, n5 - 2);
        } else {
            graphics.setColor(MetalLookAndFeel.getControlShadow());
            graphics.drawRect(n2, n3, n4 - n2 - 1, n5 - n3 - 1);
        }
        if (this.filledSlider) {
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            if (this.slider.getOrientation() == 0) {
                n6 = this.thumbRect.x + this.thumbRect.width / 2;
                n6 -= this.trackRect.x;
                n7 = !this.slider.isEnabled() ? n3 : n3 + 1;
                int n11 = n9 = !this.slider.isEnabled() ? n5 - 1 : n5 - 2;
                if (!this.drawInverted()) {
                    n8 = !this.slider.isEnabled() ? n2 : n2 + 1;
                    n10 = n6;
                } else {
                    n8 = n6;
                    n10 = !this.slider.isEnabled() ? n4 - 1 : n4 - 2;
                }
            } else {
                n6 = this.thumbRect.y + this.thumbRect.height / 2;
                n6 -= this.trackRect.y;
                n8 = !this.slider.isEnabled() ? n2 : n2 + 1;
                int n12 = n10 = !this.slider.isEnabled() ? n4 - 1 : n4 - 2;
                if (!this.drawInverted()) {
                    n7 = n6;
                    n9 = !this.slider.isEnabled() ? n5 - 1 : n5 - 2;
                } else {
                    n7 = !this.slider.isEnabled() ? n3 : n3 + 1;
                    n9 = n6;
                }
            }
            if (this.slider.isEnabled()) {
                graphics.setColor(this.slider.getBackground());
                graphics.drawLine(n8, n7, n10, n7);
                graphics.drawLine(n8, n7, n8, n9);
                graphics.setColor(MetalLookAndFeel.getControlShadow());
                graphics.fillRect(n8 + 1, n7 + 1, n10 - n8, n9 - n7);
            } else {
                graphics.setColor(MetalLookAndFeel.getControlShadow());
                graphics.fillRect(n8, n7, n10 - n8, n5 - n3);
            }
        }
        graphics.translate(-this.trackRect.x, -this.trackRect.y);
    }

    private void oceanPaintTrack(Graphics graphics) {
        boolean bl2 = MetalUtils.isLeftToRight(this.slider);
        boolean bl3 = this.drawInverted();
        Color color = (Color)UIManager.get("Slider.altTrackColor");
        Rectangle rectangle = this.getPaintTrackRect();
        graphics.translate(rectangle.x, rectangle.y);
        int n2 = rectangle.width;
        int n3 = rectangle.height;
        if (!this.slider.isEnabled()) {
            graphics.setColor(MetalLookAndFeel.getControlShadow());
            graphics.drawRect(0, 0, n2 - 1, n3 - 1);
        } else if (this.slider.getOrientation() == 0) {
            int n4;
            int n5;
            int n6 = this.thumbRect.x + this.thumbRect.width / 2 - rectangle.x;
            if (n6 > 0) {
                graphics.setColor(this.chooseColor(bl3, MetalLookAndFeel.getPrimaryControlDarkShadow(), MetalLookAndFeel.getControlDarkShadow()));
                graphics.drawRect(0, 0, n6 - 1, n3 - 1);
            }
            if (n6 < n2) {
                graphics.setColor(this.chooseColor(bl3, MetalLookAndFeel.getControlDarkShadow(), MetalLookAndFeel.getPrimaryControlDarkShadow()));
                graphics.drawRect(n6, 0, n2 - n6 - 1, n3 - 1);
            }
            graphics.setColor(MetalLookAndFeel.getPrimaryControlShadow());
            if (bl3) {
                n5 = n6;
                n4 = n2 - 2;
                graphics.drawLine(1, 1, n6, 1);
            } else {
                n5 = 1;
                n4 = n6;
                graphics.drawLine(n6, 1, n2 - 1, 1);
            }
            if (n3 == 6) {
                graphics.setColor(MetalLookAndFeel.getWhite());
                graphics.drawLine(n5, 1, n4, 1);
                graphics.setColor(color);
                graphics.drawLine(n5, 2, n4, 2);
                graphics.setColor(MetalLookAndFeel.getControlShadow());
                graphics.drawLine(n5, 3, n4, 3);
                graphics.setColor(MetalLookAndFeel.getPrimaryControlShadow());
                graphics.drawLine(n5, 4, n4, 4);
            }
        } else {
            int n7;
            int n8;
            int n9 = this.thumbRect.y + this.thumbRect.height / 2 - rectangle.y;
            if (n9 > 0) {
                graphics.setColor(this.chooseColor(bl3, MetalLookAndFeel.getControlDarkShadow(), MetalLookAndFeel.getPrimaryControlDarkShadow()));
                graphics.drawRect(0, 0, n2 - 1, n9 - 1);
            }
            if (n9 < n3) {
                graphics.setColor(this.chooseColor(bl3, MetalLookAndFeel.getPrimaryControlDarkShadow(), MetalLookAndFeel.getControlDarkShadow()));
                graphics.drawRect(0, n9, n2 - 1, n3 - n9 - 1);
            }
            graphics.setColor(MetalLookAndFeel.getPrimaryControlShadow());
            if (this.drawInverted()) {
                n8 = 1;
                n7 = n9;
                if (bl2) {
                    graphics.drawLine(1, n9, 1, n3 - 1);
                } else {
                    graphics.drawLine(n2 - 2, n9, n2 - 2, n3 - 1);
                }
            } else {
                n8 = n9;
                n7 = n3 - 2;
                if (bl2) {
                    graphics.drawLine(1, 1, 1, n9);
                } else {
                    graphics.drawLine(n2 - 2, 1, n2 - 2, n9);
                }
            }
            if (n2 == 6) {
                graphics.setColor(this.chooseColor(!bl2, MetalLookAndFeel.getWhite(), MetalLookAndFeel.getPrimaryControlShadow()));
                graphics.drawLine(1, n8, 1, n7);
                graphics.setColor(this.chooseColor(!bl2, color, MetalLookAndFeel.getControlShadow()));
                graphics.drawLine(2, n8, 2, n7);
                graphics.setColor(this.chooseColor(!bl2, MetalLookAndFeel.getControlShadow(), color));
                graphics.drawLine(3, n8, 3, n7);
                graphics.setColor(this.chooseColor(!bl2, MetalLookAndFeel.getPrimaryControlShadow(), MetalLookAndFeel.getWhite()));
                graphics.drawLine(4, n8, 4, n7);
            }
        }
        graphics.translate(-rectangle.x, -rectangle.y);
    }

    public void paintFocus(Graphics graphics) {
    }

    protected Dimension getThumbSize() {
        Dimension dimension = new Dimension();
        if (this.slider.getOrientation() == 1) {
            dimension.width = vertThumbIcon.getIconWidth();
            dimension.height = vertThumbIcon.getIconHeight();
        } else {
            dimension.width = horizThumbIcon.getIconWidth();
            dimension.height = horizThumbIcon.getIconHeight();
        }
        return dimension;
    }

    public int getTickLength() {
        return this.slider.getOrientation() == 0 ? tickLength + 4 + 1 : tickLength + 4 + 3;
    }

    protected int getTrackWidth() {
        if (this.slider.getOrientation() == 0) {
            return (int)(0.4375 * (double)this.thumbRect.height);
        }
        return (int)(0.4375 * (double)this.thumbRect.width);
    }

    protected int getTrackLength() {
        if (this.slider.getOrientation() == 0) {
            return this.trackRect.width;
        }
        return this.trackRect.height;
    }

    protected int getThumbOverhang() {
        return (int)(this.getThumbSize().getHeight() - (double)this.getTrackWidth()) / 2;
    }

    protected void scrollDueToClickInTrack(int n2) {
        this.scrollByUnit(n2);
    }

    protected void paintMinorTickForHorizSlider(Graphics graphics, Rectangle rectangle, int n2) {
        graphics.setColor(this.slider.isEnabled() ? this.slider.getForeground() : MetalLookAndFeel.getControlShadow());
        graphics.drawLine(n2, 4, n2, 4 + tickLength / 2);
    }

    protected void paintMajorTickForHorizSlider(Graphics graphics, Rectangle rectangle, int n2) {
        graphics.setColor(this.slider.isEnabled() ? this.slider.getForeground() : MetalLookAndFeel.getControlShadow());
        graphics.drawLine(n2, 4, n2, 4 + (tickLength - 1));
    }

    protected void paintMinorTickForVertSlider(Graphics graphics, Rectangle rectangle, int n2) {
        graphics.setColor(this.slider.isEnabled() ? this.slider.getForeground() : MetalLookAndFeel.getControlShadow());
        if (MetalUtils.isLeftToRight(this.slider)) {
            graphics.drawLine(4, n2, 4 + tickLength / 2, n2);
        } else {
            graphics.drawLine(0, n2, tickLength / 2, n2);
        }
    }

    protected void paintMajorTickForVertSlider(Graphics graphics, Rectangle rectangle, int n2) {
        graphics.setColor(this.slider.isEnabled() ? this.slider.getForeground() : MetalLookAndFeel.getControlShadow());
        if (MetalUtils.isLeftToRight(this.slider)) {
            graphics.drawLine(4, n2, 4 + tickLength, n2);
        } else {
            graphics.drawLine(0, n2, tickLength, n2);
        }
    }

    protected class MetalPropertyListener
    extends BasicSliderUI.PropertyChangeHandler {
        protected MetalPropertyListener() {
            super(MetalSliderUI.this);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            super.propertyChange(propertyChangeEvent);
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("JSlider.isFilled")) {
                MetalSliderUI.this.filledSlider = propertyChangeEvent.getNewValue() != null ? (Boolean)propertyChangeEvent.getNewValue() : false;
            }
        }
    }
}

