/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import javax.swing.DefaultDesktopManager;
import javax.swing.DesktopManager;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicDesktopPaneUI;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import sun.swing.plaf.synth.SynthUI;

class SynthDesktopPaneUI
extends BasicDesktopPaneUI
implements PropertyChangeListener,
SynthUI {
    private SynthStyle style;
    private TaskBar taskBar;
    private DesktopManager oldDesktopManager;

    SynthDesktopPaneUI() {
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new SynthDesktopPaneUI();
    }

    protected void installListeners() {
        super.installListeners();
        this.desktop.addPropertyChangeListener(this);
        if (this.taskBar != null) {
            this.desktop.addComponentListener(this.taskBar);
            this.desktop.addContainerListener(this.taskBar);
        }
    }

    protected void installDefaults() {
        this.updateStyle(this.desktop);
        if (UIManager.getBoolean("InternalFrame.useTaskBar")) {
            this.taskBar = new TaskBar();
            for (Component component : this.desktop.getComponents()) {
                JInternalFrame.JDesktopIcon jDesktopIcon;
                if (component instanceof JInternalFrame.JDesktopIcon) {
                    jDesktopIcon = (JInternalFrame.JDesktopIcon)component;
                } else {
                    if (!(component instanceof JInternalFrame)) continue;
                    jDesktopIcon = ((JInternalFrame)component).getDesktopIcon();
                }
                if (jDesktopIcon.getParent() == this.desktop) {
                    this.desktop.remove(jDesktopIcon);
                }
                if (jDesktopIcon.getParent() == this.taskBar) continue;
                this.taskBar.add(jDesktopIcon);
                jDesktopIcon.getInternalFrame().addComponentListener(this.taskBar);
            }
            this.taskBar.setBackground(this.desktop.getBackground());
            this.desktop.add((Component)this.taskBar, new Integer(JLayeredPane.PALETTE_LAYER + 1));
            if (this.desktop.isShowing()) {
                this.taskBar.adjustSize();
            }
        }
    }

    private void updateStyle(JDesktopPane jDesktopPane) {
        SynthStyle synthStyle = this.style;
        SynthContext synthContext = this.getContext(jDesktopPane, 1);
        this.style = SynthLookAndFeel.updateStyle(synthContext, this);
        if (synthStyle != null) {
            this.uninstallKeyboardActions();
            this.installKeyboardActions();
        }
        synthContext.dispose();
    }

    protected void uninstallListeners() {
        if (this.taskBar != null) {
            this.desktop.removeComponentListener(this.taskBar);
            this.desktop.removeContainerListener(this.taskBar);
        }
        this.desktop.removePropertyChangeListener(this);
        super.uninstallListeners();
    }

    protected void uninstallDefaults() {
        SynthContext synthContext = this.getContext(this.desktop, 1);
        this.style.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.style = null;
        if (this.taskBar != null) {
            for (Component component : this.taskBar.getComponents()) {
                JInternalFrame.JDesktopIcon jDesktopIcon = (JInternalFrame.JDesktopIcon)component;
                this.taskBar.remove(jDesktopIcon);
                jDesktopIcon.setPreferredSize(null);
                JInternalFrame jInternalFrame = jDesktopIcon.getInternalFrame();
                if (jInternalFrame.isIcon()) {
                    this.desktop.add(jDesktopIcon);
                }
                jInternalFrame.removeComponentListener(this.taskBar);
            }
            this.desktop.remove(this.taskBar);
            this.taskBar = null;
        }
    }

    protected void installDesktopManager() {
        if (UIManager.getBoolean("InternalFrame.useTaskBar")) {
            this.desktopManager = this.oldDesktopManager = this.desktop.getDesktopManager();
            if (!(this.desktopManager instanceof SynthDesktopManager)) {
                this.desktopManager = new SynthDesktopManager();
                this.desktop.setDesktopManager(this.desktopManager);
            }
        } else {
            super.installDesktopManager();
        }
    }

    protected void uninstallDesktopManager() {
        if (this.oldDesktopManager != null && !(this.oldDesktopManager instanceof UIResource)) {
            this.desktopManager = this.desktop.getDesktopManager();
            if (this.desktopManager == null || this.desktopManager instanceof UIResource) {
                this.desktop.setDesktopManager(this.oldDesktopManager);
            }
        }
        this.oldDesktopManager = null;
        super.uninstallDesktopManager();
    }

    public SynthContext getContext(JComponent jComponent) {
        return this.getContext(jComponent, this.getComponentState(jComponent));
    }

    private SynthContext getContext(JComponent jComponent, int n2) {
        return SynthContext.getContext(SynthContext.class, jComponent, SynthLookAndFeel.getRegion(jComponent), this.style, n2);
    }

    private Region getRegion(JComponent jComponent) {
        return SynthLookAndFeel.getRegion(jComponent);
    }

    private int getComponentState(JComponent jComponent) {
        return SynthLookAndFeel.getComponentState(jComponent);
    }

    public void update(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        SynthLookAndFeel.update(synthContext, graphics);
        synthContext.getPainter().paintDesktopPaneBackground(synthContext, graphics, 0, 0, jComponent.getWidth(), jComponent.getHeight());
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    protected void paint(SynthContext synthContext, Graphics graphics) {
    }

    public void paintBorder(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
        synthContext.getPainter().paintDesktopPaneBorder(synthContext, graphics, n2, n3, n4, n5);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (SynthLookAndFeel.shouldUpdateStyle(propertyChangeEvent)) {
            this.updateStyle((JDesktopPane)propertyChangeEvent.getSource());
        }
        if (propertyChangeEvent.getPropertyName() == "ancestor" && this.taskBar != null) {
            this.taskBar.adjustSize();
        }
    }

    class SynthDesktopManager
    extends DefaultDesktopManager
    implements UIResource {
        SynthDesktopManager() {
        }

        public void maximizeFrame(JInternalFrame jInternalFrame) {
            if (jInternalFrame.isIcon()) {
                try {
                    jInternalFrame.setIcon(false);
                }
                catch (PropertyVetoException propertyVetoException) {}
            } else {
                jInternalFrame.setNormalBounds(jInternalFrame.getBounds());
                Container container = jInternalFrame.getParent();
                this.setBoundsForFrame(jInternalFrame, 0, 0, container.getWidth(), container.getHeight() - SynthDesktopPaneUI.this.taskBar.getHeight());
            }
            try {
                jInternalFrame.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }

        public void iconifyFrame(JInternalFrame jInternalFrame) {
            Container container = jInternalFrame.getParent();
            JDesktopPane jDesktopPane = jInternalFrame.getDesktopPane();
            boolean bl2 = jInternalFrame.isSelected();
            if (container == null) {
                return;
            }
            JInternalFrame.JDesktopIcon jDesktopIcon = jInternalFrame.getDesktopIcon();
            if (!jInternalFrame.isMaximum()) {
                jInternalFrame.setNormalBounds(jInternalFrame.getBounds());
            }
            container.remove(jInternalFrame);
            container.repaint(jInternalFrame.getX(), jInternalFrame.getY(), jInternalFrame.getWidth(), jInternalFrame.getHeight());
            try {
                jInternalFrame.setSelected(false);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            if (bl2) {
                for (Component component : container.getComponents()) {
                    if (!(component instanceof JInternalFrame)) continue;
                    try {
                        ((JInternalFrame)component).setSelected(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                    ((JInternalFrame)component).moveToFront();
                    return;
                }
            }
        }

        public void deiconifyFrame(JInternalFrame jInternalFrame) {
            JInternalFrame.JDesktopIcon jDesktopIcon = jInternalFrame.getDesktopIcon();
            Container container = jDesktopIcon.getParent();
            if (container != null && (container = container.getParent()) != null) {
                container.add(jInternalFrame);
                if (jInternalFrame.isMaximum()) {
                    int n2 = container.getWidth();
                    int n3 = container.getHeight() - SynthDesktopPaneUI.this.taskBar.getHeight();
                    if (jInternalFrame.getWidth() != n2 || jInternalFrame.getHeight() != n3) {
                        this.setBoundsForFrame(jInternalFrame, 0, 0, n2, n3);
                    }
                }
                if (jInternalFrame.isSelected()) {
                    jInternalFrame.moveToFront();
                } else {
                    try {
                        jInternalFrame.setSelected(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                }
            }
        }

        protected void removeIconFor(JInternalFrame jInternalFrame) {
            super.removeIconFor(jInternalFrame);
            SynthDesktopPaneUI.this.taskBar.validate();
        }

        public void setBoundsForFrame(JComponent jComponent, int n2, int n3, int n4, int n5) {
            super.setBoundsForFrame(jComponent, n2, n3, n4, n5);
            if (SynthDesktopPaneUI.this.taskBar != null && n3 >= SynthDesktopPaneUI.this.taskBar.getY()) {
                jComponent.setLocation(jComponent.getX(), SynthDesktopPaneUI.this.taskBar.getY() - jComponent.getInsets().top);
            }
        }
    }

    static class TaskBar
    extends JPanel
    implements ComponentListener,
    ContainerListener {
        TaskBar() {
            this.setOpaque(true);
            this.setLayout(new FlowLayout(0, 0, 0){

                public void layoutContainer(Container container) {
                    Component[] componentArray = container.getComponents();
                    int n2 = componentArray.length;
                    if (n2 > 0) {
                        int n3 = 0;
                        for (Component component : componentArray) {
                            component.setPreferredSize(null);
                            Dimension dimension = component.getPreferredSize();
                            if (dimension.width <= n3) continue;
                            n3 = dimension.width;
                        }
                        Insets insets = container.getInsets();
                        int n4 = container.getWidth() - insets.left - insets.right;
                        int n5 = Math.min(n3, Math.max(10, n4 / n2));
                        for (Component component : componentArray) {
                            Dimension dimension = component.getPreferredSize();
                            component.setPreferredSize(new Dimension(n5, dimension.height));
                        }
                    }
                    super.layoutContainer(container);
                }
            });
            this.setBorder(new BevelBorder(0){

                protected void paintRaisedBevel(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
                    Color color = graphics.getColor();
                    graphics.translate(n2, n3);
                    graphics.setColor(this.getHighlightOuterColor(component));
                    graphics.drawLine(0, 0, 0, n5 - 2);
                    graphics.drawLine(1, 0, n4 - 2, 0);
                    graphics.setColor(this.getShadowOuterColor(component));
                    graphics.drawLine(0, n5 - 1, n4 - 1, n5 - 1);
                    graphics.drawLine(n4 - 1, 0, n4 - 1, n5 - 2);
                    graphics.translate(-n2, -n3);
                    graphics.setColor(color);
                }
            });
        }

        void adjustSize() {
            JDesktopPane jDesktopPane = (JDesktopPane)this.getParent();
            if (jDesktopPane != null) {
                int n2 = this.getPreferredSize().height;
                Insets insets = this.getInsets();
                if (n2 == insets.top + insets.bottom) {
                    n2 = this.getHeight() <= n2 ? (n2 += 21) : this.getHeight();
                }
                this.setBounds(0, jDesktopPane.getHeight() - n2, jDesktopPane.getWidth(), n2);
                this.revalidate();
                this.repaint();
            }
        }

        public void componentResized(ComponentEvent componentEvent) {
            if (componentEvent.getSource() instanceof JDesktopPane) {
                this.adjustSize();
            }
        }

        public void componentMoved(ComponentEvent componentEvent) {
        }

        public void componentShown(ComponentEvent componentEvent) {
            if (componentEvent.getSource() instanceof JInternalFrame) {
                this.adjustSize();
            }
        }

        public void componentHidden(ComponentEvent componentEvent) {
            if (componentEvent.getSource() instanceof JInternalFrame) {
                ((JInternalFrame)componentEvent.getSource()).getDesktopIcon().setVisible(false);
                this.revalidate();
            }
        }

        public void componentAdded(ContainerEvent containerEvent) {
            if (containerEvent.getChild() instanceof JInternalFrame) {
                JDesktopPane jDesktopPane = (JDesktopPane)containerEvent.getSource();
                JInternalFrame jInternalFrame = (JInternalFrame)containerEvent.getChild();
                JInternalFrame.JDesktopIcon jDesktopIcon = jInternalFrame.getDesktopIcon();
                for (Component component : this.getComponents()) {
                    if (component != jDesktopIcon) continue;
                    return;
                }
                this.add(jDesktopIcon);
                jInternalFrame.addComponentListener(this);
                if (this.getComponentCount() == 1) {
                    this.adjustSize();
                }
            }
        }

        public void componentRemoved(ContainerEvent containerEvent) {
            JInternalFrame jInternalFrame;
            if (containerEvent.getChild() instanceof JInternalFrame && !(jInternalFrame = (JInternalFrame)containerEvent.getChild()).isIcon()) {
                this.remove(jInternalFrame.getDesktopIcon());
                jInternalFrame.removeComponentListener(this);
                this.revalidate();
                this.repaint();
            }
        }
    }
}

