/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthGraphicsUtils;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import sun.swing.plaf.synth.SynthUI;

class SynthInternalFrameTitlePane
extends BasicInternalFrameTitlePane
implements SynthUI,
PropertyChangeListener {
    protected JPopupMenu systemPopupMenu;
    protected JButton menuButton;
    private SynthStyle style;

    public SynthInternalFrameTitlePane(JInternalFrame jInternalFrame) {
        super(jInternalFrame);
    }

    public String getUIClassID() {
        return "InternalFrameTitlePaneUI";
    }

    public SynthContext getContext(JComponent jComponent) {
        return this.getContext(jComponent, this.getComponentState(jComponent));
    }

    public SynthContext getContext(JComponent jComponent, int n2) {
        return SynthContext.getContext(SynthContext.class, jComponent, SynthLookAndFeel.getRegion(jComponent), this.style, n2);
    }

    private Region getRegion(JComponent jComponent) {
        return SynthLookAndFeel.getRegion(jComponent);
    }

    private int getComponentState(JComponent jComponent) {
        if (this.frame != null && this.frame.isSelected()) {
            return 512;
        }
        return SynthLookAndFeel.getComponentState(jComponent);
    }

    protected void addSubComponents() {
        this.menuButton.setName("InternalFrameTitlePane.menuButton");
        this.iconButton.setName("InternalFrameTitlePane.iconifyButton");
        this.maxButton.setName("InternalFrameTitlePane.maximizeButton");
        this.closeButton.setName("InternalFrameTitlePane.closeButton");
        this.add(this.menuButton);
        this.add(this.iconButton);
        this.add(this.maxButton);
        this.add(this.closeButton);
    }

    protected void installListeners() {
        super.installListeners();
        this.frame.addPropertyChangeListener(this);
    }

    protected void uninstallListeners() {
        this.frame.removePropertyChangeListener(this);
        super.uninstallListeners();
    }

    private void updateStyle(JComponent jComponent) {
        SynthContext synthContext = this.getContext(this, 1);
        SynthStyle synthStyle = this.style;
        this.style = SynthLookAndFeel.updateStyle(synthContext, this);
        if (this.style != synthStyle) {
            this.maxIcon = this.style.getIcon(synthContext, "InternalFrameTitlePane.maximizeIcon");
            this.minIcon = this.style.getIcon(synthContext, "InternalFrameTitlePane.minimizeIcon");
            this.iconIcon = this.style.getIcon(synthContext, "InternalFrameTitlePane.iconifyIcon");
            this.closeIcon = this.style.getIcon(synthContext, "InternalFrameTitlePane.closeIcon");
        }
        synthContext.dispose();
    }

    protected void installDefaults() {
        super.installDefaults();
        this.updateStyle(this);
    }

    protected void uninstallDefaults() {
        SynthContext synthContext = this.getContext(this, 1);
        this.style.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.style = null;
        JInternalFrame.JDesktopIcon jDesktopIcon = this.frame.getDesktopIcon();
        if (jDesktopIcon != null && jDesktopIcon.getComponentPopupMenu() == this.systemPopupMenu) {
            jDesktopIcon.setComponentPopupMenu(null);
        }
        super.uninstallDefaults();
    }

    protected void assembleSystemMenu() {
        this.systemPopupMenu = new JPopupMenuUIResource();
        this.addSystemMenuItems(this.systemPopupMenu);
        this.enableActions();
        this.menuButton = this.createNoFocusButton();
        this.menuButton.setIcon(this.frame.getFrameIcon());
        this.menuButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                SynthInternalFrameTitlePane.this.showSystemMenu();
            }
        });
        JPopupMenu jPopupMenu = this.frame.getComponentPopupMenu();
        if (jPopupMenu == null || jPopupMenu instanceof UIResource) {
            this.frame.setComponentPopupMenu(this.systemPopupMenu);
        }
        if (this.frame.getDesktopIcon() != null && ((jPopupMenu = this.frame.getDesktopIcon().getComponentPopupMenu()) == null || jPopupMenu instanceof UIResource)) {
            this.frame.getDesktopIcon().setComponentPopupMenu(this.systemPopupMenu);
        }
        this.setInheritsPopupMenu(true);
    }

    protected void addSystemMenuItems(JPopupMenu jPopupMenu) {
        JMenuItem jMenuItem = jPopupMenu.add(this.restoreAction);
        jMenuItem.setMnemonic('R');
        jMenuItem = jPopupMenu.add(this.moveAction);
        jMenuItem.setMnemonic('M');
        jMenuItem = jPopupMenu.add(this.sizeAction);
        jMenuItem.setMnemonic('S');
        jMenuItem = jPopupMenu.add(this.iconifyAction);
        jMenuItem.setMnemonic('n');
        jMenuItem = jPopupMenu.add(this.maximizeAction);
        jMenuItem.setMnemonic('x');
        jPopupMenu.add(new JSeparator());
        jMenuItem = jPopupMenu.add(this.closeAction);
        jMenuItem.setMnemonic('C');
    }

    protected void showSystemMenu() {
        Dimension dimension = new Dimension();
        Insets insets = this.frame.getInsets();
        dimension.width += insets.left + insets.right;
        dimension.height += insets.bottom + insets.top;
        if (!this.frame.isIcon()) {
            this.systemPopupMenu.show(this.menuButton, this.getX() - dimension.width, this.getY() + this.getHeight() - dimension.height);
        } else {
            this.systemPopupMenu.show(this.menuButton, this.getX() - dimension.width, this.getY() - this.systemPopupMenu.getPreferredSize().height - dimension.height);
        }
    }

    public void paintComponent(Graphics graphics) {
        SynthContext synthContext = this.getContext(this);
        SynthLookAndFeel.update(synthContext, graphics);
        synthContext.getPainter().paintInternalFrameTitlePaneBackground(synthContext, graphics, 0, 0, this.getWidth(), this.getHeight());
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    protected void paint(SynthContext synthContext, Graphics graphics) {
    }

    public void paintBorder(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
        synthContext.getPainter().paintInternalFrameTitlePaneBorder(synthContext, graphics, n2, n3, n4, n5);
    }

    protected LayoutManager createLayout() {
        SynthContext synthContext = this.getContext(this);
        LayoutManager layoutManager = (LayoutManager)this.style.get(synthContext, "InternalFrameTitlePane.titlePaneLayout");
        synthContext.dispose();
        return layoutManager != null ? layoutManager : new SynthTitlePaneLayout();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (SynthLookAndFeel.shouldUpdateStyle(propertyChangeEvent)) {
            this.updateStyle(this);
        }
    }

    private JButton createNoFocusButton() {
        JButton jButton = new JButton();
        jButton.setFocusable(false);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        return jButton;
    }

    private static class JPopupMenuUIResource
    extends JPopupMenu
    implements UIResource {
        private JPopupMenuUIResource() {
        }
    }

    class SynthTitlePaneLayout
    implements LayoutManager {
        SynthTitlePaneLayout() {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            return this.minimumLayoutSize(container);
        }

        public Dimension minimumLayoutSize(Container container) {
            int n2;
            int n3;
            int n4 = 22;
            if (SynthInternalFrameTitlePane.this.frame.isClosable()) {
                n4 += 19;
            }
            if (SynthInternalFrameTitlePane.this.frame.isMaximizable()) {
                n4 += 19;
            }
            if (SynthInternalFrameTitlePane.this.frame.isIconifiable()) {
                n4 += 19;
            }
            FontMetrics fontMetrics = SynthInternalFrameTitlePane.this.frame.getFontMetrics(SynthInternalFrameTitlePane.this.getFont());
            SynthContext synthContext = SynthInternalFrameTitlePane.this.getContext(SynthInternalFrameTitlePane.this.frame);
            SynthGraphicsUtils synthGraphicsUtils = synthContext.getStyle().getGraphicsUtils(synthContext);
            String string = SynthInternalFrameTitlePane.this.frame.getTitle();
            int n5 = string != null ? synthGraphicsUtils.computeStringWidth(synthContext, fontMetrics.getFont(), fontMetrics, string) : 0;
            int n6 = n3 = string != null ? string.length() : 0;
            n4 = n3 > 3 ? (n4 += n5 < (n2 = synthGraphicsUtils.computeStringWidth(synthContext, fontMetrics.getFont(), fontMetrics, string.substring(0, 3) + "...")) ? n5 : n2) : (n4 += n5);
            Icon icon = SynthInternalFrameTitlePane.this.frame.getFrameIcon();
            int n7 = fontMetrics.getHeight();
            n7 += 2;
            int n8 = 0;
            if (icon != null) {
                n8 = Math.min(icon.getIconHeight(), 16);
            }
            int n9 = Math.max(n7, n8 += 2);
            Dimension dimension = new Dimension(n4, n9);
            if (SynthInternalFrameTitlePane.this.getBorder() != null) {
                Insets insets = SynthInternalFrameTitlePane.this.getBorder().getBorderInsets(container);
                dimension.height += insets.top + insets.bottom;
                dimension.width += insets.left + insets.right;
            }
            synthContext.dispose();
            return dimension;
        }

        public void layoutContainer(Container container) {
            Icon icon;
            int n2;
            boolean bl2 = SynthLookAndFeel.isLeftToRight(SynthInternalFrameTitlePane.this.frame);
            int n3 = SynthInternalFrameTitlePane.this.getWidth();
            int n4 = SynthInternalFrameTitlePane.this.getHeight();
            Icon icon2 = SynthInternalFrameTitlePane.this.closeButton.getIcon();
            int n5 = n2 = icon2 != null ? icon2.getIconHeight() : 12;
            if (n2 == 0) {
                n2 = 12;
            }
            int n6 = (icon = SynthInternalFrameTitlePane.this.frame.getFrameIcon()) != null ? icon.getIconHeight() : n2;
            Insets insets = SynthInternalFrameTitlePane.this.frame.getInsets();
            int n7 = bl2 ? insets.left : n3 - 16 - insets.right;
            SynthInternalFrameTitlePane.this.menuButton.setBounds(n7, (n4 - n6) / 2, 16, 14);
            int n8 = n7 = bl2 ? n3 - 16 - insets.right : insets.left;
            if (SynthInternalFrameTitlePane.this.frame.isClosable()) {
                SynthInternalFrameTitlePane.this.closeButton.setBounds(n7, (n4 - n2) / 2, 16, 14);
                n7 += bl2 ? -18 : 18;
            }
            if (SynthInternalFrameTitlePane.this.frame.isMaximizable()) {
                SynthInternalFrameTitlePane.this.maxButton.setBounds(n7, (n4 - n2) / 2, 16, 14);
                n7 += bl2 ? -18 : 18;
            }
            if (SynthInternalFrameTitlePane.this.frame.isIconifiable()) {
                SynthInternalFrameTitlePane.this.iconButton.setBounds(n7, (n4 - n2) / 2, 16, 14);
            }
        }
    }
}

