/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import sun.font.CharToGlyphMapper;
import sun.font.Type1Font;

public final class Type1GlyphMapper
extends CharToGlyphMapper {
    Type1Font font;

    public Type1GlyphMapper(Type1Font type1Font) {
        this.font = type1Font;
        this.initMapper();
    }

    private void initMapper() {
        if (this.font.pScaler == 0L) {
            this.font.getScaler();
        }
        this.missingGlyph = this.font.getMissingGlyphCode(this.font.pScaler);
    }

    public int getNumGlyphs() {
        return this.font.getNumGlyphs(this.font.pScaler);
    }

    public int getMissingGlyphCode() {
        return this.missingGlyph;
    }

    public boolean canDisplay(char c2) {
        return this.font.getGlyphCode(this.font.pScaler, c2) != this.missingGlyph;
    }

    public int charToGlyph(char c2) {
        return this.font.getGlyphCode(this.font.pScaler, c2);
    }

    public int charToGlyph(int n2) {
        if (n2 < 0 || n2 > 65535) {
            return this.missingGlyph;
        }
        return this.font.getGlyphCode(this.font.pScaler, (char)n2);
    }

    public void charsToGlyphs(int n2, char[] cArray, int[] nArray) {
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2;
            int n3 = cArray[i2];
            if (n3 >= 55296 && n3 <= 56319 && i2 < n2 - 1 && (c2 = cArray[i2 + 1]) >= '\udc00' && c2 <= '\udfff') {
                n3 = (n3 - 55296) * 1024 + c2 - 56320 + 65536;
                nArray[i2 + 1] = 65535;
            }
            nArray[i2] = n3 < 0 || n3 > 65535 ? this.missingGlyph : this.font.getGlyphCode(this.font.pScaler, (char)n3);
            if (n3 < 65536) continue;
            ++i2;
        }
    }

    public void charsToGlyphs(int n2, int[] nArray, int[] nArray2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray2[i2] = nArray[i2] < 0 || nArray[i2] > 65535 ? this.missingGlyph : this.font.getGlyphCode(this.font.pScaler, (char)nArray[i2]);
        }
    }

    public boolean charsToGlyphsNS(int n2, char[] cArray, int[] nArray) {
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2;
            int n3 = cArray[i2];
            if (n3 >= 55296 && n3 <= 56319 && i2 < n2 - 1 && (c2 = cArray[i2 + 1]) >= '\udc00' && c2 <= '\udfff') {
                n3 = (n3 - 55296) * 1024 + c2 - 56320 + 65536;
                nArray[i2 + 1] = 65535;
            }
            nArray[i2] = n3 < 0 || n3 > 65535 ? this.missingGlyph : this.font.getGlyphCode(this.font.pScaler, (char)n3);
            if (n3 < 1424) continue;
            if (n3 <= 1535) {
                return true;
            }
            if (n3 >= 1536 && n3 <= 1791) {
                return true;
            }
            if (n3 >= 2304 && n3 <= 3455) {
                return true;
            }
            if (n3 >= 3584 && n3 <= 3711) {
                return true;
            }
            if (n3 >= 8204 && n3 <= 8205) {
                return true;
            }
            if (n3 >= 8234 && n3 <= 8238) {
                return true;
            }
            if (n3 >= 8298 && n3 <= 8303) {
                return true;
            }
            if (n3 < 65536) continue;
            ++i2;
        }
        return false;
    }
}

