/*
 * Decompiled with CFR 0.152.
 */
package sun.management;

import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryManagerMXBean;
import java.lang.management.MemoryNotificationInfo;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import javax.management.MBeanNotificationInfo;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import sun.management.ManagementFactory;
import sun.management.MemoryNotifInfoCompositeData;
import sun.management.NotificationEmitterSupport;
import sun.management.Util;
import sun.management.VMManagement;
import sun.misc.VM;

class MemoryImpl
extends NotificationEmitterSupport
implements MemoryMXBean {
    private final VMManagement jvm;
    private static MemoryPoolMXBean[] pools = null;
    private static MemoryManagerMXBean[] mgrs = null;
    private static final String notifName = "javax.management.Notification";
    private static final String[] notifTypes = new String[]{"java.management.memory.threshold.exceeded", "java.management.memory.collection.threshold.exceeded"};
    private static final String[] notifMsgs = new String[]{"Memory usage exceeds usage threshold", "Memory usage exceeds collection usage threshold"};
    private MBeanNotificationInfo[] notifInfo = null;
    private static long seqNumber = 0L;
    private static ObjectName objname = null;

    MemoryImpl(VMManagement vMManagement) {
        super(MemoryMXBean.class);
        this.jvm = vMManagement;
    }

    public int getObjectPendingFinalizationCount() {
        return VM.getFinalRefCount();
    }

    public void gc() {
        Runtime.getRuntime().gc();
    }

    public MemoryUsage getHeapMemoryUsage() {
        return this.getMemoryUsage0(true);
    }

    public MemoryUsage getNonHeapMemoryUsage() {
        return this.getMemoryUsage0(false);
    }

    public boolean isVerbose() {
        return this.jvm.getVerboseGC();
    }

    public void setVerbose(boolean bl2) {
        ManagementFactory.checkControlAccess();
        this.setVerboseGC(bl2);
    }

    static synchronized MemoryPoolMXBean[] getMemoryPools() {
        if (pools == null) {
            pools = MemoryImpl.getMemoryPools0();
        }
        return pools;
    }

    static synchronized MemoryManagerMXBean[] getMemoryManagers() {
        if (mgrs == null) {
            mgrs = MemoryImpl.getMemoryManagers0();
        }
        return mgrs;
    }

    private static native MemoryPoolMXBean[] getMemoryPools0();

    private static native MemoryManagerMXBean[] getMemoryManagers0();

    private native MemoryUsage getMemoryUsage0(boolean var1);

    private native void setVerboseGC(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MBeanNotificationInfo[] getNotificationInfo() {
        MemoryImpl memoryImpl = this;
        synchronized (memoryImpl) {
            if (this.notifInfo == null) {
                this.notifInfo = new MBeanNotificationInfo[1];
                this.notifInfo[0] = new MBeanNotificationInfo(notifTypes, notifName, "Memory Notification");
            }
        }
        return this.notifInfo;
    }

    private static String getNotifMsg(String string) {
        for (int i2 = 0; i2 < notifTypes.length; ++i2) {
            if (string != notifTypes[i2]) continue;
            return notifMsgs[i2];
        }
        return "Unknown message";
    }

    private static long getNextSeqNumber() {
        return ++seqNumber;
    }

    private static synchronized ObjectName getObjectName() {
        if (objname != null) {
            return objname;
        }
        try {
            objname = new ObjectName("java.lang:type=Memory");
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw Util.newInternalError(malformedObjectNameException);
        }
        return objname;
    }

    static void createNotification(String string, String string2, MemoryUsage memoryUsage, long l2) {
        MemoryImpl memoryImpl = (MemoryImpl)ManagementFactory.getMemoryMXBean();
        if (!memoryImpl.hasListeners()) {
            return;
        }
        long l3 = System.currentTimeMillis();
        String string3 = MemoryImpl.getNotifMsg(string);
        Notification notification = new Notification(string, MemoryImpl.getObjectName(), MemoryImpl.getNextSeqNumber(), l3, string3);
        MemoryNotificationInfo memoryNotificationInfo = new MemoryNotificationInfo(string2, memoryUsage, l2);
        CompositeData compositeData = MemoryNotifInfoCompositeData.toCompositeData(memoryNotificationInfo);
        notification.setUserData(compositeData);
        memoryImpl.sendNotification(notification);
    }
}

