/***************************************************************************
                          kwifimanager_kcmodule.cpp  -  description
                             -------------------
    begin                : Die Okt  2 19:41:16 CEST 2001
    copyright            : (C) 2001 by Stefan Winter
    email                : mail@stefan-winter.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <qlayout.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qcheckbox.h>
#include <qradiobutton.h>
#include <qgroupbox.h>
#include <qbuttongroup.h>
#include <qlabel.h>
#include <qtabwidget.h>
#include <qcombobox.h>
#include <qdir.h>

#include <klocale.h>
#include <kmessagebox.h>
#include <ksimpleconfig.h>
#include <kprocess.h>
#include <kprocio.h>
#include <kstandarddirs.h>
#include <kdebug.h>

#include <kcmodule.h>
#include <kgenericfactory.h>

#include "kwifimanager_kcmodule.h"
#include "kwifimanager_configwidget.h"
#include "kwifimanager_configwidget2.h"

#include "configcontainer.h"
#include <stdlib.h>
#include <iostream>
#include <fstream>

#include <kaboutdata.h>


/* factory function for module startup, new style */

class KWifimanager_KCModule;
typedef KGenericFactory < KWifimanager_KCModule, QWidget > KWiFiFactory;
K_EXPORT_COMPONENT_FACTORY (kcm_kwifimanager, KWiFiFactory("kcmwifi") )




KWifimanager_KCModule::KWifimanager_KCModule (QWidget * parent , const char *name , const QStringList unnuetz)
    :KCModule (parent, name, unnuetz)
{
    kdDebug() << "hier"<<endl;
  load ();
  setButtons (127);
  QVBoxLayout *stupidlayout = new QVBoxLayout (this);
  configwindow = new QTabWidget (this);
  config1 = new KWifimanager_ConfigWidget (1, configwindow, "configwindow1");
  config2 = new KWifimanager_ConfigWidget (2, configwindow, "configwindow2");
  config3 = new KWifimanager_ConfigWidget (3, configwindow, "configwindow3");
  config4 = new KWifimanager_ConfigWidget (4, configwindow, "configwindow4");
  config_gen = new KWifimanager_ConfigWidget2 (this, "general_setup");
  configwindow->addTab (config1, i18n ("Config &1"));
  configwindow->addTab (config2, i18n ("Config &2"));
  configwindow->addTab (config3, i18n ("Config &3"));
  configwindow->addTab (config4, i18n ("Config &4"));
  configwindow->setFixedSize (configwindow->sizeHint ());
  stupidlayout->addWidget (configwindow, 0, Qt::AlignLeft | Qt::AlignTop);
  stupidlayout->addWidget (config_gen, 0, Qt::AlignLeft | Qt::AlignTop);
  connect (config1, SIGNAL (setChanged (bool)), this, SLOT (configChanged ()));
  connect (config2, SIGNAL (setChanged (bool)), this, SLOT (configChanged ()));
  connect (config3, SIGNAL (setChanged (bool)), this, SLOT (configChanged ()));
  connect (config4, SIGNAL (setChanged (bool)), this, SLOT (configChanged ()));
  connect (config_gen, SIGNAL (setChanged (bool)), this, SLOT (configChanged ()));
  connect (config_gen, SIGNAL (saveInfoNow ()), this, SLOT (slotSave ()));
  connect (config_gen, SIGNAL (callInit ()), this, SLOT (slotCallInit ()));
  connect (config_gen, SIGNAL (callChangeConfig (int, QString)), this,
	   SLOT (slotChangeConfig (int, QString)));
  KProcess iwconfigtest;
  iwconfigtest << "iwconfig";
  if ((geteuid () == 0) && (!iwconfigtest.start (KProcess::DontCare)))
    KMessageBox::sorry (0,
			i18n
			("Error executing iwconfig. WLAN configurations can only be altered if the wireless tools are properly installed."),
			i18n ("No Wireless Tools"));
  if ( geteuid () != 0 )
  {
      config1->makeReadOnly();
      config2->makeReadOnly();
      config3->makeReadOnly();
      config4->makeReadOnly();
      config_gen->makeReadOnly();
  }
  //this->show ();
}


KWifimanager_KCModule::~KWifimanager_KCModule ()
{
}

void
KWifimanager_KCModule::changeConfig (int x, QString used_interface)
{
  QString temp = "";
  // shut down interface
  KProcess ifcon;
  ifcon << "ifconfig";
  ifcon << used_interface.latin1 () << "down";
  kdDebug() << "Shutting down interface via ifconfig\n";
  ifcon.start (KProcess::Block);
  // interface is down

  // call iwconfig to alter configuration
  KProcess changeproc;
  changeproc << "iwconfig";
  changeproc << used_interface;

  // ESSID, operation mode and bitrate

  changeproc << "essid";
  temp =
    (Configcontainer::configs->net_name[x].latin1 () !=
     0) ? Configcontainer::configs->net_name[x].latin1 () : "";
  changeproc << temp;
  changeproc << "mode";
  temp =
    (Configcontainer::configs->managed[x] == true) ? "managed" : "ad-hoc";
  changeproc << temp;
  changeproc << "rate";
  switch (Configcontainer::configs->bitrate[x])
    {
    case AUTO:
      temp = "auto";
      break;
    case M1:
      temp = "1M";
      break;
    case M2:
      temp = "2M";
      break;
    case M55:
      temp = "5.5M";
      break;
    case M11:
      temp = "11M";
      break;
    };
  changeproc << temp;

  // CRYPTOGRAPHY

  changeproc << "key";
  if (Configcontainer::configs->crypto_enabled[x] == false)
    {
      changeproc << "off";
    }
  else
    {
      changeproc << "key";
      temp =
	(Configcontainer::configs->crypto_mode[x] ==
	 OPEN) ? "open" : "restricted";
      changeproc << temp;
      // set active key
      changeproc << "key";
      temp ="";
      switch (Configcontainer::configs->active_crypto_key[x]) {
	case 1:{if (Configcontainer::configs->crypto_is_string1[x]) temp="s:";
		temp=temp+(Configcontainer::configs->crypto1[x]);
		break;
		}
	case 2:{if (Configcontainer::configs->crypto_is_string2[x]) temp="s:";
		temp=temp+(Configcontainer::configs->crypto2[x]);
		break;
		}
	case 3:{if (Configcontainer::configs->crypto_is_string3[x]) temp="s:";
		temp=temp+(Configcontainer::configs->crypto3[x]);
		break;
		}
	case 4:{if (Configcontainer::configs->crypto_is_string4[x]) temp="s:";
		temp=temp+(Configcontainer::configs->crypto4[x]);
		break;
		}
	};
      changeproc << temp;
      changeproc << "key";
      changeproc << "on";
    };

  // power management

  changeproc << "power";
  if (Configcontainer::configs->pm_enabled[x] == false)
    {
      changeproc << "off";
    }
  else
    {
      changeproc << "period";
      changeproc << Configcontainer::configs->sleep_time_string[x] + "m";
      changeproc << "power";
      changeproc << "timeout";
      changeproc << Configcontainer::configs->wake_time_string[x] + "m";
      changeproc << "power";
      switch (Configcontainer::configs->packet[x])
	{
	case UNI:
	  temp = "unicast";
	  break;
	case MULTI:
	  temp = "multicast";
	  break;
	case BOTH:
	  temp = "all";
	  break;
	};
      changeproc << "power";
      changeproc << "on";
    };
  changeproc << temp;
  changeproc.start (KProcess::Block);
  // config changed

  // restart interface
  KProcess ifcon2;
  ifcon2 << "ifconfig";
  ifcon2 << used_interface.latin1 () << "up";
  kdDebug() << "Restarting interface via ifconfig\n";
  ifcon2.start (KProcess::Block);
  // interface restarted

  // execute script
  KProcess scripty;
  QStringList args =
    QStringList::split (" ", Configcontainer::configs->script_name[x]);
  for (QStringList::Iterator it = args.begin (); it != args.end (); ++it)
    {
      scripty << *it;
    }
  scripty.start (KProcess::DontCare);
  // script execution initiated & detached
}

void
KWifimanager_KCModule::load ()
{
  defaults ();
  KStandardDirs finder;
  QString kdedir =
    finder.findResourceDir ("data", "kwifimanager/config/kwifimanagerrc");
  if (kdedir.isEmpty())
    {
      kdedir =
	finder.findResourceDir ("data",
				"kwifimanager/pics/offline.png") +
	"kwifimanager/config/";
      QDir erzeuger;
      erzeuger.mkdir (kdedir);
    }
  else
    {
      kdedir += "kwifimanager/config/";
    }
  KSimpleConfig *conffile =
    new KSimpleConfig (kdedir + "kwifimanagerrc", true);
  conffile->setGroup ("General");
  Configcontainer::use_preset_config =
    conffile->readBoolEntry ("Use preset configuration", false);
  Configcontainer::preset_config_to_use =
    conffile->readNumEntry ("Configuration to use", 1);
  Configcontainer::interface_to_use = conffile->readEntry ("Interface");
  for (int i = 1; i < 5; i++)
    {
      QString temp = QString( "Configuration %1" ).arg( i );
      conffile->setGroup (temp);
      Configcontainer::configs->script_name[i] =
	conffile->readEntry ("Script Name");
      Configcontainer::configs->net_name[i] =
	conffile->readEntry ("Network Name");
      Configcontainer::configs->managed[i] =
	conffile->readBoolEntry ("Infrastructure", false);
      Configcontainer::configs->crypto_enabled[i] =
	conffile->readBoolEntry ("Use cryptography", false);
      Configcontainer::configs->active_crypto_key[i] =
	conffile->readNumEntry ("Active crypto key", 0);
      Configcontainer::configs->active_key_string[i] = "%1";
      Configcontainer::configs->active_key_string[i] =
	Configcontainer::configs->active_key_string[i].
	arg (Configcontainer::configs->active_crypto_key[i]);
      Configcontainer::configs->crypto1[i] =
	conffile->readEntry ("Key 1");
      Configcontainer::configs->crypto_is_string1[i] =
	conffile->readBoolEntry ("Key 1 is string", false);
      Configcontainer::configs->crypto2[i] =
	conffile->readEntry ("Key 2");
      Configcontainer::configs->crypto_is_string2[i] =
	conffile->readBoolEntry ("Key 2 is string", false);
      Configcontainer::configs->crypto3[i] =
	conffile->readEntry ("Key 3");
      Configcontainer::configs->crypto_is_string3[i] =
	conffile->readBoolEntry ("Key 3 is string", false);
      Configcontainer::configs->crypto4[i] =
	conffile->readEntry ("Key 4");
      Configcontainer::configs->crypto_is_string4[i] =
	conffile->readBoolEntry ("Key 4 is string", false);
      (conffile->readEntry ("Crypto mode", "OPEN") ==
       "OPEN" ? Configcontainer::configs->crypto_mode[i] =
       OPEN : Configcontainer::configs->crypto_mode[i] = RESTRICTED);
      Configcontainer::configs->pm_enabled[i] =
	conffile->readBoolEntry ("PM enabled", false);
      Configcontainer::configs->sleep_time[i] =
	conffile->readNumEntry ("Sleep time", 0);
      Configcontainer::configs->wake_time[i] =
	conffile->readNumEntry ("Wake time", 0);
      temp = conffile->readEntry ("Speed", "AUTO");
      if (temp == "AUTO")
	{
	  Configcontainer::configs->bitrate[i] = AUTO;
	}
      else if (temp == "M1")
	{
	  Configcontainer::configs->bitrate[i] = M1;
	}
      else if (temp == "M2")
	{
	  Configcontainer::configs->bitrate[i] = M2;
	}
      else if (temp == "M55")
	{
	  Configcontainer::configs->bitrate[i] = M55;
	}
      else
	Configcontainer::configs->bitrate[i] = M11;
      temp = conffile->readEntry ("Packets", "BOTH");
      if (temp == "UNI")
	{
	  Configcontainer::configs->packet[i] = UNI;
	}
      else if (temp == "MULTI")
	{
	  Configcontainer::configs->packet[i] = MULTI;
	}
      else
	Configcontainer::configs->packet[i] = BOTH;
    };
  delete conffile;

    emit KCModule::changed(false);
}

void
KWifimanager_KCModule::defaults ()
{
  Configcontainer::use_preset_config = false;
  Configcontainer::preset_config_to_use = 1;
  Configcontainer::interface_to_use = "";
  for (int i = 1; i < 5; i++)
    {
      Configcontainer::configs->script_name[i] = "";
      Configcontainer::configs->net_name[i] = "";
      Configcontainer::configs->managed[i] = false;
      Configcontainer::configs->crypto_enabled[i] = false;
      Configcontainer::configs->active_crypto_key[i] = 0;
      Configcontainer::configs->active_key_string[i] = "0";
      Configcontainer::configs->crypto1[i] = "";
      Configcontainer::configs->crypto2[i] = "";
      Configcontainer::configs->crypto3[i] = "";
      Configcontainer::configs->crypto4[i] = "";
      Configcontainer::configs->crypto_is_string1[i] = false;
      Configcontainer::configs->crypto_is_string2[i] = false;
      Configcontainer::configs->crypto_is_string3[i] = false;
      Configcontainer::configs->crypto_is_string4[i] = false;
      Configcontainer::configs->crypto_mode[i] = OPEN;
      Configcontainer::configs->pm_enabled[i] = false;
      Configcontainer::configs->sleep_time[i] = 0;
      Configcontainer::configs->sleep_time_string[i] = "0";
      Configcontainer::configs->wake_time_string[i] = "0";
      Configcontainer::configs->wake_time[i] = 0;
      Configcontainer::configs->bitrate[i] = AUTO;
      Configcontainer::configs->packet[i] = BOTH;
      emit KCModule::changed(true);
    };
}

void
KWifimanager_KCModule::slotSave ()
{
  config1->saveData (1);
  config2->saveData (2);
  config3->saveData (3);
  config4->saveData (4);
  config_gen->saveData ();
  KStandardDirs finder;
  QString kdedir = finder.findResourceDir ("data", "kwifimanager/config/");
  if (kdedir.isEmpty()) {
    kdedir = finder.findResourceDir("data", "kwifimanager");
    kdedir+="kwifimanager" + QDir::separator();
    QDir(kdedir).mkdir("config");
    } else {
    kdedir += "kwifimanager" + QDir::separator();
  }
  KSimpleConfig *conffile =
    new KSimpleConfig (kdedir + "config/kwifimanagerrc", false);
  conffile->setGroup ("General");
  conffile->writeEntry ("Use preset configuration",
			Configcontainer::use_preset_config);
  conffile->writeEntry ("Configuration to use",
			Configcontainer::preset_config_to_use);
  conffile->writeEntry ("Interface", Configcontainer::interface_to_use);
  for (int i = 1; i < 5; i++)
    {
      QString temp = QString( "Configuration %1" ).arg( i );
      conffile->setGroup (temp);
      conffile->writeEntry ("Script Name",
			    Configcontainer::configs->script_name[i]);
      conffile->writeEntry ("Network Name",
			    Configcontainer::configs->net_name[i]);
      conffile->writeEntry ("Infrastructure",
			    Configcontainer::configs->managed[i]);
      conffile->writeEntry ("Use cryptography",
			    Configcontainer::configs->crypto_enabled[i]);
      conffile->writeEntry ("Active crypto key",
			    Configcontainer::configs->active_crypto_key[i]);
      conffile->writeEntry ("Key 1", Configcontainer::configs->crypto1[i]);
      conffile->writeEntry ("Key 1 is string",
			    Configcontainer::configs->crypto_is_string1[i]);
      conffile->writeEntry ("Key 2", Configcontainer::configs->crypto2[i]);
      conffile->writeEntry ("Key 2 is string",
			    Configcontainer::configs->crypto_is_string2[i]);
      conffile->writeEntry ("Key 3", Configcontainer::configs->crypto3[i]);
      conffile->writeEntry ("Key 3 is string",
			    Configcontainer::configs->crypto_is_string3[i]);
      conffile->writeEntry ("Key 4", Configcontainer::configs->crypto4[i]);
      conffile->writeEntry ("Key 4 is string",
			    Configcontainer::configs->crypto_is_string4[i]);
      conffile->writeEntry ("Crypto mode",
			    (Configcontainer::configs->crypto_mode[i] ==
			     "OPEN" ? "OPEN" : "RESTRICTED"));
      conffile->writeEntry ("PM enabled",
			    Configcontainer::configs->pm_enabled[i]);
      conffile->writeEntry ("Sleep time",
			    Configcontainer::configs->sleep_time[i]);
      conffile->writeEntry ("Wake time",
			    Configcontainer::configs->wake_time[i]);
      switch (Configcontainer::configs->bitrate[i])
	{
	case AUTO:
	  conffile->writeEntry ("Speed", "AUTO");
	  break;
	case M1:
	  conffile->writeEntry ("Speed", "M1");
	  break;
	case M2:
	  conffile->writeEntry ("Speed", "M2");
	  break;
	case M55:
	  conffile->writeEntry ("Speed", "M55");
	  break;
	case M11:
	  conffile->writeEntry ("Speed", "M11");
	  break;
	};
      switch (Configcontainer::configs->packet[i])
	{
	case UNI:
	  conffile->writeEntry ("Packets", "UNI");
	  break;
	case MULTI:
	  conffile->writeEntry ("Packets", "MULTI");
	  break;
	case BOTH:
	  conffile->writeEntry ("Packets", "BOTH");
	  break;
	};
    };
  conffile->sync ();
  delete conffile;
  emit KCModule::changed(false);
  KWifimanager_KCModule::init ();
}

int
KWifimanager_KCModule::buttons ()
{
  return 61;
}

void
KWifimanager_KCModule::configChanged ()
{
  emit KCModule::changed(true);
}

QString
KWifimanager_KCModule::quickHelp () const
{
  return i18n ("Helpful information about the kwifimanager_kcmodule module.");
}

// ------------------------------------------------------------------------

void
KWifimanager_KCModule::init ()
{
  KStandardDirs finder;
  QString kdedir =
    finder.findResourceDir ("data", "kwifimanager/config/kwifimanagerrc");
  if (kdedir.isEmpty())
    {
      kdedir =
	finder.findResourceDir ("data",
				"kwifimanager/pics/offline.png") +
	"kwifimanager/config/";
      QDir erzeuger;
      erzeuger.mkdir (kdedir);
    }
  else
    {
      kdedir += "kwifimanager/config/";
    }
  KSimpleConfig *conffile =
    new KSimpleConfig (kdedir + "kwifimanagerrc", true);
  conffile->setGroup ("General");
  Configcontainer::use_preset_config =
    conffile->readBoolEntry ("Use preset configuration", false);
  if (Configcontainer::use_preset_config)
    {
      Configcontainer::preset_config_to_use =
	conffile->readNumEntry ("Configuration to use", 1);
      Configcontainer::interface_to_use =
	conffile->readEntry ("Interface");
      int i = Configcontainer::preset_config_to_use + 1;
      QString temp = QString( "Configuration %1" ).arg( i );
      conffile->setGroup (temp);
      Configcontainer::configs->script_name[i] =
	conffile->readEntry ("Script Name");
      Configcontainer::configs->net_name[i] =
	conffile->readEntry ("Network Name");
      Configcontainer::configs->managed[i] =
	conffile->readBoolEntry ("Infrastructure", false);
      Configcontainer::configs->crypto_enabled[i] =
	conffile->readBoolEntry ("Use cryptography", false);
      Configcontainer::configs->active_crypto_key[i] =
	conffile->readNumEntry ("Active crypto key", 0);
      Configcontainer::configs->active_key_string[i] = "%1";
      Configcontainer::configs->active_key_string[i] =
	Configcontainer::configs->active_key_string[i].
	arg (Configcontainer::configs->active_crypto_key[i]);
      Configcontainer::configs->crypto1[i] =
	conffile->readEntry ("Key 1");
      Configcontainer::configs->crypto_is_string1[i] =
	conffile->readBoolEntry ("Key 1 is string", false);
      Configcontainer::configs->crypto2[i] =
	conffile->readEntry ("Key 2");
      Configcontainer::configs->crypto_is_string2[i] =
	conffile->readBoolEntry ("Key 2 is string", false);
      Configcontainer::configs->crypto3[i] =
	conffile->readEntry ("Key 3");
      Configcontainer::configs->crypto_is_string3[i] =
	conffile->readBoolEntry ("Key 3 is string", false);
      Configcontainer::configs->crypto4[i] =
	conffile->readEntry ("Key 4");
      Configcontainer::configs->crypto_is_string4[i] =
	conffile->readBoolEntry ("Key 4 is string", false);
      (conffile->readEntry ("Crypto mode", "OPEN") ==
       "OPEN" ? Configcontainer::configs->crypto_mode[i] =
       OPEN : Configcontainer::configs->crypto_mode[i] = RESTRICTED);
      Configcontainer::configs->pm_enabled[i] =
	conffile->readBoolEntry ("PM enabled", false);
      Configcontainer::configs->sleep_time[i] =
	conffile->readNumEntry ("Sleep time", 0);
      Configcontainer::configs->wake_time[i] =
	conffile->readNumEntry ("Wake time", 0);
      temp = conffile->readEntry ("Speed", "AUTO");
      if (temp == "AUTO")
	{
	  Configcontainer::configs->bitrate[i] = AUTO;
	}
      else if (temp == "M1")
	{
	  Configcontainer::configs->bitrate[i] = M1;
	}
      else if (temp == "M2")
	{
	  Configcontainer::configs->bitrate[i] = M2;
	}
      else if (temp == "M55")
	{
	  Configcontainer::configs->bitrate[i] = M55;
	}
      else
	Configcontainer::configs->bitrate[i] = M11;
      temp = conffile->readEntry ("Packets", "BOTH");
      if (temp == "UNI")
	{
	  Configcontainer::configs->packet[i] = UNI;
	}
      else if (temp == "MULTI")
	{
	  Configcontainer::configs->packet[i] = MULTI;
	}
      else
	Configcontainer::configs->packet[i] = BOTH;
      KWifimanager_KCModule::changeConfig (Configcontainer::
					   preset_config_to_use + 1,
					   Configcontainer::interface_to_use);
    };
  delete conffile;
}

void
KWifimanager_KCModule::slotCallInit ()
{
  KWifimanager_KCModule::init ();
}

void
KWifimanager_KCModule::slotChangeConfig (int config, QString interface)
{
  KWifimanager_KCModule::changeConfig (config, interface);
}


extern "C"
{

KCModule *create_kwifimanager (QWidget * parent, const char *name)
  {
    KWifimanager_KCModule::init ();
    kdDebug() << "INIT completed...\n";
    KLocale::setMainCatalogue ("kwifimanager");
    KGlobal::locale ()->insertCatalogue ("kwifimanager");
    return new KWifimanager_KCModule (parent, "kcm_kwifimanager_kcmodule");
//    kdDebug() << "Returned new object\n";
  }
}


#include "kwifimanager_kcmodule.moc"
