.TH XWIN 1 __vendorversion__
.SH NAME
XWin \- X Server for the Cygwin environment on Microsoft Windows


.SH SYNOPSIS
.B XWin
[ options ] ...


.SH DESCRIPTION
.I XWin is an X Server for the X Window System on the Cygwin environment
running on Microsoft Windows.


.SH MODES
\fIXWin\fP can operate in five different and incompatible modes:
.br
* \fISingle Window\fP: This is the default option.  The X server
appears as a single Windows window and all X windows are contained
within this window.  This mode requires an external window manager.
.br
* \fINo Decoration\fP: This mode is like single window mode except
that the X server window does not have a title bar or border, thus
maximizing the amount of space available for X windows within the X
server window.  This mode requires an external window manager.
.br
* \fIFull Screen\fP: This mode is like single window mode except that
the X server window takes the full screen, covering completely the
Windows desktop.  This mode requires an external window manager.
.br
* \fIRootless\fP: The X server works on a window covering the whole
screen but the root window (traditionally covered with an X hatch
pattern) is hidden from view.  This mode requires an external window
manager.
.br
* \fIMulti-Window\fP: In this mode \fIXWin\fP uses its own integrated
window manager in order to handle the top-level X windows, in such a
way that they appear as normal Windows windows.
.PP
NOTE: \fIMulti-Window\fP mode will crash if an external window manager
such as \fItwm\fP or \fIfvwm\fP is launched since \fIMulti-Window\fP
uses its own internal window manager; all other modes require an
external window manager in order to move, resize, and perform other
operations on the individual X windows.


.SH LOG
As it runs \fIXWin\fP writes messages indicating the most relevant events
to  the console
from which it was called and to a log file that by default is located at
\fI/tmp/XWin.log\fP.  This file is mainly for debugging purposes.


.SH PREFERENCES FILE
On startup \fIXWin\fP looks for the file \fI$HOME/.XWinrc\fP or, if
the previous file does not exist,
\fI/usr/X11R6/lib/X11/system.XWinrc\fP.  \fI.XWinrc\fP allows setting
preferences for the following:
.br
1- To include items into the menu associated with the \fIXWin\fP icon
which is in the \fIWindows\fP system tray.  This functions in all
modes that have a tray icon.
.br
2- To include items in the menu which is associated with the Windows
window that \fIXWin -multiwindow\fP produces for each top-level X
window.  That can be done both for the generic case and for particular
programs.
.br
3- To change the icon that is associated to the Windows window that
\fIXWin -multiwindow\fP produces for each top-level X-window.  Again,
that can be done both for the generic case and for particular
programs.
.PP
The format of the \fI.XWinrc\fP file is given in the man page XWinrc(5).


.SH OPTIONS
In addition to the normal server options described in the \fIXserver(1)\fP
manual page, \fIXWin\fP accepts the following command line switches,
\fIall\fP of which are optional:
.TP 8
.B \-clipboard
Enables the integration
between the Cygwin/X clipboard and Windows clipboard.  Do not use in
conjunction with the \fIxwinclip\fP program.
.TP 8
.B "\-clipupdates \fInum_boxes\fP"
Specify an optional threshold, above which the boxes in a shadow
update operation will be collected into a GDI clipping region.  The
clipping region is then used to do a single bit block transfer that is
constrained to the updated area by the clipping region.  There is some
overhead involved in creating, installing, destroying, and removing
the clipping region, thus there may not be much benefit for a small
number of boxes (less than 10).  It is even possible that this
functionality does not provide a benefit at any number of boxes; we
can only determine the usefulness of this feature through testing.
This parameter works in conjunction with engines 1, 2, and 4 (Shadow
GDI, Shadow DirectDraw, and Shadow DirectDraw Non-Locking,
respectively).
.TP 8
.B "\-emulate3buttons \fItimeout\fP"
Emulate a three button mouse; pressing both buttons within
.I timeout
milliseconds causes an emulated middle button press.  The default 
.I timeout
is 50 milliseconds.  Note that most mice with scroll wheel have middle
button functionality, usually you will need this option only if you have
a two button mouse without scroll wheel.
.TP 8
.B \-emulatepseudo
Create a depth 8 PseudoColor visual when running in depths 15, 16, 24,
or 32, collectively known as TrueColor depths.
 At this date (April 2004) this option is not still operative.
.TP 8
.B "\-engine \fIengine_type_id\fP"
This option, which is intended for Cygwin/X developers,
overrides the server's automatically supported engine type.  This
parameter will be ignored if the specified engine type is not
supported on the current system.  The supported engine type ids are 1
- Shadow GDI, 2 - Shadow DirectDraw, and 4 - Shadow DirectDraw4.
Additionally, there is a barely functional experimental engine type id
16 - Native GDI.
.TP 8
.B "\-fullscreen [-depth \fIdepth\fP] [-refresh \fIrate_in_Hz\fP]"
Run the server in fullscreen mode, as opposed to the default windowed
mode.
.TP 8
.B "\-depth \fIdepth\fP"
Specify the color depth, in bits per pixel, to use when running in
fullscreen with a DirectDraw engine.  This parameter is ignored if
\fB\-fullscreen\fP is not specified.
.TP 8
.B "\-refresh \fIrate_in_Hz\fP"
Specify an optional refresh rate to use when running in
fullscreen with a DirectDraw engine.  This parameter is ignored if
\fB\-fullscreen\fP is not specified.
.TP 8
.B \-help
Write a help text to the console and to the log file.
.TP 8
.B \-ignoreinput
Ignore keyboard and mouse input.  This is usually only used for testing
and debugging purposes.
.TP 8
.B \-[no]keyhook
Enable [disable] a low-level keyboard hook for catching
special key combinations like Alt+Tab and passing them to the X
Server instead of letting \fIWindows\fP handle them.
.TP 8
.B \-lesspointer
Hide the Windows mouse cursor when the mouse is over any Cygwin/X
window (regardless of whether that window is active or inactive).  This
prevents the Windows mouse cursor from being placed overtop of the X
cursor.
.TP 8
.B "\-logfile \fIFile_Name\fP"
Change the log file from the default located at \fI/tmp/XWin.log\fP to
the one indicated by \fIFile_Name\fP.
.TP 8
.B "\-logverbose \fIlevel\fP"
Control the degree of verbosity of the log messages with the integer
parameter \fIlevel\fP.  For \fIlevel\fP=0 only fatal errors are
reported, for \fIlevel\fP=1 (default) simple information about
configuration is also given, for \fIlevel\fP=2 a detailed log
information (including trace and debug output) is produced.  Bigger
values will yield a still more detailed debug output.  At this date
(April 2004) the option is still not fully operative; the default
value is 2 and the output is insensitive to the level value.
.TP 8
.B \-multimonitors
Create a root window that covers all monitors on a system with
multiple monitors.
.TP 8
.B \-multiwindow
Start the integrated \fIWindowsi\fP-based window manager, which launches each
top-level X window in its own \fIWindows\fP window.  Not to be used together
with \fB\-rootless\fP nor \fB\-fullscreen\fP.
.TP 8
.B \-nodecoration
Do not give the Cygwin/X window a Windows window border, title bar,
etc.  This parameter only applies to windowed mode screens, i.e., this
parameter is ignored when the \fB\-fullscreen\fP parameter is specified.
.TP 8
.B \-nounicodeclipboard
Do not use Unicode clipboard even if NT-based platform.
.TP 8
.B \-rootless
Run the server in rootless mode.  Not to be used with \fB\-multiwindow\fP
nor with \fB\-fullscreen\fP.
.TP 8
.B "\-screen \fIscreen_number\fP \fIwidth\fP \fIheight\fP"
This parameter may be used to specify the
.I screen_number,
.I height,
and
.I width
of one or several Cygwin/X screens; each Cygwin/X screen will be
opened in its own window.  When using multiple screens, be sure not to
duplicate any screen numbers.
.I XWin
default behavior is to create a single screen that is roughly
the size of the current Windows display area.
Screen specific parameters, such as \fB\-fullscreen\fP, can be applied as a
default to all screens by placing those screen specific parameters
before any \fB\-screen\fP parameter.  Screen specific parameters placed after
the first \fB\-screen\fP parameter will apply only to the immediately
preceeding \fB\-screen\fP parameter.
.TP 8
.B \-scrollbars
In windowed mode, allow screens bigger than the Windows desktop.
Moreover, if the window has decorations, one can now resize it.
.TP 8
.B \-[no]trayicon
Do not create a tray icon.  Default is to create one
icon per screen.  You can globally disable tray icons with
\fB\-notrayicon\fP, then enable it for specific screens with
\fB\-trayicon\fP for those screens.
.TP 8
.B \-[no]unixkill
Enable or disable the \fICtrl-Alt-Backspace\fP key combination as a
signal to exit the X Server.  The \fICtrl-Alt-Backspace\fP key combination
is disabled by default.
.TP 8
.B \-[no]winkill
Enable or disable the \fIAlt-F4\fP key combination as a signal to exit the
X Server.
The \fIAlt-F4\fP key combination is enabled by default.
.TP 8
.B \-swcursor
Disable the usage of the windows cursor and use the X11 software cursor instead.
.TP 8
.B "\-xkblayout \fIlayout\fP"
.TP 8
.B "\-xkbmodel \fImodel\fP"
.TP 8
.B "\-xkboptions \fIoption\fP"
.TP 8
.B "\-xkbrules \fIrule\fP"
.TP 8
.B "\-xkbvariant \fIvariant\fp"
These options implement the xkeyboard extension for loading
a particular keyboard map as the X server starts.  The behavior is similar
to the \fIsetxkbmap\fP program.  The layout data is located at
\fI/usr/X11R6/lib/X11/xkb/\fP.  Additional information is found in the
README files therein and in the man page of \fIsetxkbmap\fP.  For example
in order to load a German layout for a pc105 keyboard one uses
the options:
.br
.I " \-xkblayout de \-xkbmodel pc105"
.PP
Alternatively one may use the \fIsetxkbmap\fP program after XWin is
running or even the \fIxmodmap\fP program for loading the old-style
keyboard maps.


.SH "SEE ALSO"
X(__miscmansuffix__), Xserver(1), xdm(1), xinit(1), XWinrc(1), setxkbmap(1)


.SH BUGS
.I XWin
and this man page still have many limitations.  Some of the more obvious
ones are:
.br
- The display mode can not be changed once the X server has started.
.br
- The XWin software is developing rapidly; it is therefore likely that
this man page is not up to date.  It is always prudent to 
look also at the output of \fIXWin -help\fP and to the Cygwin/X User Guide
at /usr/share/doc/cygwin-x-doc-x.x.x/ug/cygwin-x-ug.xxx in order to
check the options that are operative.


.SH AUTHORS
This list is by no means complete, but direct contributors to the
Cygwin/X project include (in alphabetical order by last name): Stuart
Adamson, Michael Bax, Jehan Bing, Lev Bishop, Dr. Peter Busch, Biju G
C, Robert Collins, Nick Crabtree, Early Ehlinger, Christopher Faylor,
John Fortin, Brian Genisio, Fabrizio Gennari, Alexander Gottwald, Ralf
Habacker, Colin Harrison, Matthieu Herrb, Alan Hourihane, Pierre A
Humblet, Harold L Hunt II, Dakshinamurthy Karra, Kensuke Matsuzaki,
Takuma Murakami, Earle F. Philhower III, Benjamin Riefenstahl, Suhaib
Siddiqi, Jack Tanner, and Nicholas Wourms.
