/*
 * Copyright © 2001 Red Hat, Inc.
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Red Hat not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  Red Hat makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * RED HAT DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL RED HAT
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN 
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Author:  Owen Taylor, Red Hat, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 *          Olivier Fourdan: adapted to the "multi-channel" concept
 *          Benedikt Meurer: Added multi-screen support.
 */

#ifndef MCS_MANAGER_H
#define MCS_MANAGER_H

#include <X11/Xlib.h>

#include <glib.h>

#include <libxfce4mcs/mcs-common.h>


G_BEGIN_DECLS;

typedef struct _McsManager McsManager;

typedef void (*McsTerminateFunc) (void *cb_data);
typedef void (*McsShowRequestFunc) (gchar *path, void *cb_data);

McsManager *mcs_manager_new(gboolean std_mcs, Display * display, int screen, McsTerminateFunc terminate, McsShowRequestFunc show, void *cb_data);
void mcs_manager_destroy(McsManager * manager);
void mcs_manager_force_update (McsManager *manager, gboolean force_update);

#if 0 /* incompatible with multi-screen, but not required anyway! */
Window mcs_manager_get_std_window(McsManager * manager);
Window mcs_manager_get_mcs_window(McsManager * manager);
#endif

gboolean mcs_manager_process_event(McsManager * manager, XEvent * xev);

McsChannel *mcs_manager_add_channel(McsManager * manager, const gchar *channel_name);
void mcs_manager_delete_channel(McsManager * manager, const gchar *channel_name);
McsResult mcs_manager_set_raw_channel (McsManager *manager, const gchar *channel_name, gboolean raw);

McsResult mcs_manager_set_setting(McsManager * manager, McsSetting * setting, const gchar *channel_name);
McsResult mcs_manager_delete_setting(McsManager * manager, const gchar *name, const gchar *channel_name);
McsResult mcs_manager_set_int(McsManager * manager, const gchar *name, const gchar *channel_name, int value);
McsResult mcs_manager_set_string(McsManager * manager, const gchar *name, const gchar *channel_name, const gchar *value);
McsResult mcs_manager_set_color(McsManager * manager, const gchar *name, const gchar *channel_name, McsColor * value);
McsResult mcs_manager_notify(McsManager * manager, const gchar *channel_name);

McsList *mcs_manager_list_lookup(McsManager * manager, const gchar *channel_name);
McsSetting *mcs_manager_setting_lookup(McsManager * manager, const gchar *name, const gchar *channel_name);

/* Load/Save options helper functions */

McsChannel *mcs_manager_add_channel_from_file(McsManager *manager, const gchar *channel_name, const gchar *filename);
gboolean mcs_manager_save_channel_to_file(McsManager *manager, const gchar *channel_name, const gchar *filename);

G_END_DECLS;

#endif /* MCS_MANAGER_H */
