/*
 *  xfce-icontheme - a themed icon lookup class
 *
 *  Copyright (c) 2004 Brian Tarricone <bjt23@cornell.edu>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef _XFCE_ICONTHEME_H_
#define _XFCE_ICONTHEME_H_

#include <glib-object.h>
#include <gdk/gdkscreen.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

G_BEGIN_DECLS

#define XFCE_TYPE_ICON_THEME    (xfce_icon_theme_get_type())
#define XFCE_ICON_THEME(obj)    (G_TYPE_CHECK_INSTANCE_CAST((obj), XFCE_TYPE_ICON_THEME, XfceIconTheme))
#define XFCE_IS_ICON_THEME(obj) (G_TYPE_CHECK_INSTANCE_TYPE((obj), XFCE_TYPE_ICON_THEME))

typedef enum
{
	XFCE_ICON_CATEGORY_UNKNOWN = 0,
	XFCE_ICON_CATEGORY_EDITOR,
	XFCE_ICON_CATEGORY_FILEMAN,
	XFCE_ICON_CATEGORY_UTILITY,
	XFCE_ICON_CATEGORY_GAME,
	XFCE_ICON_CATEGORY_HELP,
	XFCE_ICON_CATEGORY_MULTIMEDIA,
	XFCE_ICON_CATEGORY_NETWORK,
	XFCE_ICON_CATEGORY_GRAPHICS,
	XFCE_ICON_CATEGORY_PRINTER,
	XFCE_ICON_CATEGORY_PRODUCTIVITY,
	XFCE_ICON_CATEGORY_SOUND,
	XFCE_ICON_CATEGORY_TERMINAL,
	XFCE_ICON_CATEGORY_DEVELOPMENT,
	XFCE_ICON_CATEGORY_SETTINGS,
	XFCE_ICON_CATEGORY_SYSTEM,
	XFCE_ICON_CATEGORY_WINE,
	XFCE_N_BUILTIN_ICON_CATEGORIES
} XfceIconThemeCategory;

typedef struct _XfceIconTheme XfceIconTheme;
typedef struct _XfceIconThemeClass XfceIconThemeClass;
typedef struct _XfceIconThemePriv XfceIconThemePriv;

struct _XfceIconTheme
{
	GObject gobject;
	
	/*< private >*/
	XfceIconThemePriv *priv;
};

struct _XfceIconThemeClass
{
	GObjectClass gobject_class;
	
	/*< signals >*/
	void (*changed)(XfceIconTheme *icon_theme);
	
	/*< reserved for future expansion >*/
	gpointer (*_xfce_reserved1)();
	gpointer (*_xfce_reserved2)();
};

GType xfce_icon_theme_get_type          () G_GNUC_CONST;

XfceIconTheme *xfce_icon_theme_get_for_screen
                                        (GdkScreen *screen);

gchar *xfce_icon_theme_lookup           (XfceIconTheme *icon_theme,
                                         const gchar *icon_name,
                                         gint icon_size);
gchar *xfce_icon_theme_lookup_list      (XfceIconTheme *icon_theme,
                                         GList *icon_names,
                                         gint icon_size);
gchar *xfce_icon_theme_lookup_category  (XfceIconTheme *icon_theme,
                                         XfceIconThemeCategory category,
                                         gint icon_size);

GdkPixbuf *xfce_icon_theme_load         (XfceIconTheme *icon_theme,
                                         const gchar *icon_name,
                                         gint icon_size);
GdkPixbuf *xfce_icon_theme_load_list    (XfceIconTheme *icon_theme,
                                         GList *icon_names,
                                         gint icon_size);
GdkPixbuf *xfce_icon_theme_load_category(XfceIconTheme *icon_theme,
                                         XfceIconThemeCategory category,
                                         gint icon_size);

GList *xfce_icon_theme_get_search_path  (XfceIconTheme *icon_theme);
void xfce_icon_theme_set_search_path    (XfceIconTheme *icon_theme,
                                         GList *search_paths);
void xfce_icon_theme_prepend_search_path(XfceIconTheme *icon_theme,
                                         const gchar *search_path);
void xfce_icon_theme_append_search_path (XfceIconTheme *icon_theme,
                                         const gchar *search_path);

XfceIconThemeCategory xfce_icon_theme_register_category
                                        (XfceIconTheme *icon_theme,
                                         GList *icon_names);
void xfce_icon_theme_unregister_category(XfceIconTheme *icon_theme,
                                         XfceIconThemeCategory category);

void xfce_icon_theme_set_use_svg        (XfceIconTheme *icon_theme,
                                         gboolean use_svg);
gboolean xfce_icon_theme_get_use_svg    (XfceIconTheme *icon_theme);

G_END_DECLS

#endif
