/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.compiler;

import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.code.CompressedReadStream;
import sun.jvm.hotspot.interpreter.SharedInfo;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMReg;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.utilities.Assert;

public class OopMapValue {
    private short value;
    private short contentReg;
    static int TYPE_BITS;
    static int REGISTER_BITS;
    static int TYPE_SHIFT;
    static int REGISTER_SHIFT;
    static int TYPE_MASK;
    static int TYPE_MASK_IN_PLACE;
    static int REGISTER_MASK;
    static int REGISTER_MASK_IN_PLACE;
    static int UNUSED_VALUE;
    static int OOP_VALUE;
    static int VALUE_VALUE;
    static int DEAD_VALUE;
    static int CALLEE_SAVED_VALUE;
    static int DERIVED_OOP_VALUE;

    private static void initialize(TypeDataBase db) {
        TYPE_BITS = db.lookupIntConstant("OopMapValue::type_bits");
        REGISTER_BITS = db.lookupIntConstant("OopMapValue::register_bits");
        TYPE_SHIFT = db.lookupIntConstant("OopMapValue::type_shift");
        REGISTER_SHIFT = db.lookupIntConstant("OopMapValue::register_shift");
        TYPE_MASK = db.lookupIntConstant("OopMapValue::type_mask");
        TYPE_MASK_IN_PLACE = db.lookupIntConstant("OopMapValue::type_mask_in_place");
        REGISTER_MASK = db.lookupIntConstant("OopMapValue::register_mask");
        REGISTER_MASK_IN_PLACE = db.lookupIntConstant("OopMapValue::register_mask_in_place");
        UNUSED_VALUE = db.lookupIntConstant("OopMapValue::unused_value");
        OOP_VALUE = db.lookupIntConstant("OopMapValue::oop_value");
        VALUE_VALUE = db.lookupIntConstant("OopMapValue::value_value");
        DEAD_VALUE = db.lookupIntConstant("OopMapValue::dead_value");
        CALLEE_SAVED_VALUE = db.lookupIntConstant("OopMapValue::callee_saved_value");
        DERIVED_OOP_VALUE = db.lookupIntConstant("OopMapValue::derived_oop_value");
    }

    public OopMapValue() {
        this.setValue((short)0);
        this.setContentReg(new VMReg(0));
    }

    public OopMapValue(VMReg reg, OopTypes t) {
        this.setReg(reg);
        this.setType(t);
    }

    public OopMapValue(VMReg reg, OopTypes t, VMReg reg2) {
        this.setReg(reg);
        this.setType(t);
        this.setContentReg(reg2);
    }

    public OopMapValue(CompressedReadStream stream) {
        this.readFrom(stream);
    }

    public void readFrom(CompressedReadStream stream) {
        this.setValue((short)stream.readInt());
        if (this.isCalleeSaved() || this.isDerivedOop()) {
            this.setContentReg(new VMReg(stream.readInt()));
        }
    }

    public boolean isOop() {
        return (this.getValue() & TYPE_MASK_IN_PLACE) == OOP_VALUE;
    }

    public boolean isValue() {
        return (this.getValue() & TYPE_MASK_IN_PLACE) == VALUE_VALUE;
    }

    public boolean isDead() {
        return (this.getValue() & TYPE_MASK_IN_PLACE) == DEAD_VALUE;
    }

    public boolean isCalleeSaved() {
        return (this.getValue() & TYPE_MASK_IN_PLACE) == CALLEE_SAVED_VALUE;
    }

    public boolean isDerivedOop() {
        return (this.getValue() & TYPE_MASK_IN_PLACE) == DERIVED_OOP_VALUE;
    }

    public VMReg getReg() {
        return new VMReg((this.getValue() & REGISTER_MASK_IN_PLACE) >> REGISTER_SHIFT);
    }

    public void setReg(VMReg r) {
        this.setValue((short)(r.getValue() << REGISTER_SHIFT | this.getValue() & TYPE_MASK_IN_PLACE));
    }

    public OopTypes getType() {
        int which = this.getValue() & TYPE_MASK_IN_PLACE;
        if (which == UNUSED_VALUE) {
            return OopTypes.UNUSED_VALUE;
        }
        if (which == OOP_VALUE) {
            return OopTypes.OOP_VALUE;
        }
        if (which == VALUE_VALUE) {
            return OopTypes.VALUE_VALUE;
        }
        if (which == DEAD_VALUE) {
            return OopTypes.DEAD_VALUE;
        }
        if (which == CALLEE_SAVED_VALUE) {
            return OopTypes.CALLEE_SAVED_VALUE;
        }
        if (which == DERIVED_OOP_VALUE) {
            return OopTypes.DERIVED_OOP_VALUE;
        }
        throw new InternalError("unknown which " + which + " (TYPE_MASK_IN_PLACE = " + TYPE_MASK_IN_PLACE + ")");
    }

    public void setType(OopTypes t) {
        this.setValue((short)(this.getValue() & REGISTER_MASK_IN_PLACE | t.getValue()));
    }

    public VMReg getContentReg() {
        return new VMReg(this.contentReg);
    }

    public void setContentReg(VMReg r) {
        this.contentReg = (short)r.getValue();
    }

    public boolean isRegisterLoc() {
        VMReg vMReg = this.getReg();
        VM.getVM().getSharedInfo();
        return vMReg.lessThan(SharedInfo.getStack0());
    }

    public boolean isStackLoc() {
        VMReg vMReg = this.getReg();
        VM.getVM().getSharedInfo();
        return vMReg.greaterThanOrEqual(SharedInfo.getStack0());
    }

    public int getStackOffset() {
        Assert.that(this.isStackLoc(), "must be stack location");
        VMReg vMReg = this.getReg();
        VM.getVM().getSharedInfo();
        return vMReg.minus(SharedInfo.getStack0());
    }

    private void setValue(short value) {
        this.value = value;
    }

    private int getValue() {
        return this.value;
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            public void update(Observable o, Object data) {
                OopMapValue.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }

    public static abstract class OopTypes {
        public static final OopTypes UNUSED_VALUE = new OopTypes(){

            int getValue() {
                return UNUSED_VALUE;
            }
        };
        public static final OopTypes OOP_VALUE = new OopTypes(){

            int getValue() {
                return OOP_VALUE;
            }
        };
        public static final OopTypes VALUE_VALUE = new OopTypes(){

            int getValue() {
                return VALUE_VALUE;
            }
        };
        public static final OopTypes DEAD_VALUE = new OopTypes(){

            int getValue() {
                return DEAD_VALUE;
            }
        };
        public static final OopTypes CALLEE_SAVED_VALUE = new OopTypes(){

            int getValue() {
                return CALLEE_SAVED_VALUE;
            }
        };
        public static final OopTypes DERIVED_OOP_VALUE = new OopTypes(){

            int getValue() {
                return DERIVED_OOP_VALUE;
            }
        };

        abstract int getValue();

        protected OopTypes() {
        }
    }
}

