/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.oops;

import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.oops.NamedFieldIdentifier;
import sun.jvm.hotspot.oops.OopField;
import sun.jvm.hotspot.oops.OopVisitor;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.types.CIntegerField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.types.WrongTypeException;

public class ConstantPoolCacheEntry {
    private static long size;
    private static long baseOffset;
    private static CIntegerField indices;
    private static sun.jvm.hotspot.types.OopField f1;
    private static CIntegerField f2;
    private static CIntegerField flags;
    private OopHandle cp;
    private long offset;
    static NamedFieldIdentifier f1FieldName;

    private static synchronized void initialize(TypeDataBase db) throws WrongTypeException {
        Type type = db.lookupType("ConstantPoolCacheEntry");
        size = type.getSize();
        indices = type.getCIntegerField("_indices");
        f1 = type.getOopField("_f1");
        f2 = type.getCIntegerField("_f2");
        flags = type.getCIntegerField("_flags");
        type = db.lookupType("constantPoolCacheOopDesc");
        baseOffset = type.getSize();
    }

    ConstantPoolCacheEntry(OopHandle cp, int index) {
        this.cp = cp;
        this.offset = baseOffset + (long)index * size;
    }

    public int getConstantPoolIndex() {
        return (int)(this.getIndices() & 0xFFFFL);
    }

    private long getIndices() {
        return this.cp.getCIntegerAt(indices.getOffset() + this.offset, indices.getSize(), indices.isUnsigned());
    }

    public void iterateFields(OopVisitor visitor) {
        visitor.doOop(new OopField(f1FieldName, f1.getOffset() + this.offset, true), true);
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            public void update(Observable o, Object data) {
                ConstantPoolCacheEntry.initialize(VM.getVM().getTypeDataBase());
            }
        });
        f1FieldName = new NamedFieldIdentifier("_f1");
    }
}

