/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.runtime;

import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.oops.ObjectHeap;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.runtime.JavaThread;
import sun.jvm.hotspot.runtime.ObjectMonitor;
import sun.jvm.hotspot.runtime.Threads;
import sun.jvm.hotspot.runtime.VM;

public class DeadlockDetector {
    private static Threads threads;
    private static ObjectHeap heap;
    private static HashMap threadTable;

    public static void print(PrintStream tty) {
        tty.println("Deadlock Detection:");
        tty.println();
        int globalDfn = 0;
        int numberOfDeadlocks = 0;
        threads = VM.getVM().getThreads();
        heap = VM.getVM().getObjectHeap();
        DeadlockDetector.createThreadTable();
        Iterator i = threadTable.entrySet().iterator();
        block6: while (i.hasNext()) {
            JavaThread currentThread;
            ObjectMonitor waitingToLock;
            JavaThread thread;
            Map.Entry e = i.next();
            if (DeadlockDetector.dfn(e) >= 0) continue;
            int thisDfn = globalDfn;
            JavaThread previousThread = thread = (JavaThread)e.getKey();
            try {
                waitingToLock = thread.getCurrentPendingMonitor();
            }
            catch (RuntimeException re) {
                tty.println("This version of HotSpot VM doesn't support deadlock detection.");
                return;
            }
            while (waitingToLock != null && (currentThread = threads.owningThreadFromMonitor(waitingToLock)) != null) {
                if (DeadlockDetector.dfn(currentThread) >= 0) {
                    if (DeadlockDetector.dfn(currentThread) < thisDfn || currentThread == previousThread) continue block6;
                    ++numberOfDeadlocks;
                    DeadlockDetector.printOneDeadlock(tty, currentThread);
                    continue block6;
                }
                threadTable.put(currentThread, new Integer(globalDfn++));
                previousThread = currentThread;
                waitingToLock = currentThread.getCurrentPendingMonitor();
            }
        }
        switch (numberOfDeadlocks) {
            case 0: {
                tty.println("No deadlocks found.");
                break;
            }
            case 1: {
                tty.println("Found a total of 1 deadlock.");
                break;
            }
            default: {
                tty.println("Found a total of " + numberOfDeadlocks + " deadlocks.");
            }
        }
        tty.println();
    }

    private static void createThreadTable() {
        threadTable = new HashMap();
        for (JavaThread cur = threads.first(); cur != null; cur = cur.next()) {
            threadTable.put(cur, new Integer(-1));
        }
    }

    private static int dfn(JavaThread thread) {
        Object obj = threadTable.get(thread);
        if (obj != null) {
            return (Integer)obj;
        }
        return -1;
    }

    private static int dfn(Map.Entry e) {
        return (Integer)e.getValue();
    }

    private static void printOneDeadlock(PrintStream tty, JavaThread thread) {
        tty.println("Found one Java-level deadlock:");
        tty.println("=============================");
        JavaThread currentThread = thread;
        do {
            tty.println();
            tty.println("\"" + currentThread.getThreadName() + "\":");
            ObjectMonitor waitingToLock = currentThread.getCurrentPendingMonitor();
            tty.print("  waiting to lock Monitor@" + waitingToLock.getAddress());
            OopHandle obj = waitingToLock.object();
            Oop oop = heap.newOop(obj);
            if (obj != null) {
                tty.print(" (Object@");
                Oop.printOopAddressOn(oop, tty);
                tty.print(", a " + oop.getKlass().getName().asString() + ")");
                tty.print(",\n  which is held by");
            } else {
                tty.print(" (raw monitor),\n  which is held by");
            }
            currentThread = threads.owningThreadFromMonitor(waitingToLock);
            tty.print(" \"" + currentThread.getThreadName() + "\"");
        } while (!currentThread.equals(thread));
        tty.println();
        tty.println();
    }
}

