/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import sun.swing.plaf.synth.SynthUI;

class SynthButtonUI
extends BasicButtonUI
implements PropertyChangeListener,
SynthUI {
    private SynthStyle style;

    SynthButtonUI() {
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new SynthButtonUI();
    }

    protected void installDefaults(AbstractButton abstractButton) {
        this.updateStyle(abstractButton);
        LookAndFeel.installProperty(abstractButton, "rolloverEnabled", Boolean.TRUE);
    }

    protected void installListeners(AbstractButton abstractButton) {
        super.installListeners(abstractButton);
        abstractButton.addPropertyChangeListener(this);
    }

    void updateStyle(AbstractButton abstractButton) {
        SynthContext synthContext = this.getContext(abstractButton, 1);
        SynthStyle synthStyle = this.style;
        this.style = SynthLookAndFeel.updateStyle(synthContext, this);
        if (this.style != synthStyle) {
            Object object;
            if (abstractButton.getMargin() == null || abstractButton.getMargin() instanceof UIResource) {
                object = (Insets)this.style.get(synthContext, this.getPropertyPrefix() + "margin");
                if (object == null) {
                    object = SynthLookAndFeel.EMPTY_UIRESOURCE_INSETS;
                }
                abstractButton.setMargin((Insets)object);
            }
            if ((object = this.style.get(synthContext, this.getPropertyPrefix() + "iconTextGap")) != null) {
                LookAndFeel.installProperty(abstractButton, "iconTextGap", object);
            }
            LookAndFeel.installProperty(abstractButton, "contentAreaFilled", (object = this.style.get(synthContext, this.getPropertyPrefix() + "contentAreaFilled")) != null ? object : Boolean.TRUE);
            if (synthStyle != null) {
                this.uninstallKeyboardActions(abstractButton);
                this.installKeyboardActions(abstractButton);
            }
        }
        synthContext.dispose();
    }

    protected void uninstallListeners(AbstractButton abstractButton) {
        super.uninstallListeners(abstractButton);
        abstractButton.removePropertyChangeListener(this);
    }

    protected void uninstallDefaults(AbstractButton abstractButton) {
        SynthContext synthContext = this.getContext(abstractButton, 1);
        this.style.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.style = null;
    }

    public SynthContext getContext(JComponent jComponent) {
        return this.getContext(jComponent, this.getComponentState(jComponent));
    }

    SynthContext getContext(JComponent jComponent, int n) {
        Region region = this.getRegion(jComponent);
        return SynthContext.getContext(SynthContext.class, jComponent, region, this.style, n);
    }

    private Region getRegion(JComponent jComponent) {
        return SynthLookAndFeel.getRegion(jComponent);
    }

    private int getComponentState(JComponent jComponent) {
        int n = 1;
        if (!jComponent.isEnabled()) {
            n = 8;
        }
        if (SynthLookAndFeel.selectedUI == this) {
            return SynthLookAndFeel.selectedUIState | 1;
        }
        ButtonModel buttonModel = ((AbstractButton)jComponent).getModel();
        if (buttonModel.isPressed()) {
            n = buttonModel.isArmed() ? 4 : 2;
        } else if (buttonModel.isRollover()) {
            n = 2;
        }
        if (buttonModel.isSelected()) {
            n |= 0x200;
        }
        if (jComponent.isFocusOwner()) {
            n |= 0x100;
        }
        if (jComponent instanceof JButton && ((JButton)jComponent).isDefaultButton()) {
            n |= 0x400;
        }
        return n;
    }

    public void update(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        SynthLookAndFeel.update(synthContext, graphics);
        this.paintBackground(synthContext, graphics, jComponent);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    protected void paint(SynthContext synthContext, Graphics graphics) {
        AbstractButton abstractButton = (AbstractButton)synthContext.getComponent();
        graphics.setColor(synthContext.getStyle().getColor(synthContext, ColorType.TEXT_FOREGROUND));
        graphics.setFont(this.style.getFont(synthContext));
        synthContext.getStyle().getGraphicsUtils(synthContext).paintText(synthContext, graphics, abstractButton.getText(), this.getIcon(abstractButton), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalAlignment(), abstractButton.getHorizontalTextPosition(), abstractButton.getVerticalTextPosition(), abstractButton.getIconTextGap(), abstractButton.getDisplayedMnemonicIndex(), this.getTextShiftOffset(synthContext));
    }

    void paintBackground(SynthContext synthContext, Graphics graphics, JComponent jComponent) {
        synthContext.getPainter().paintButtonBackground(synthContext, graphics, 0, 0, jComponent.getWidth(), jComponent.getHeight());
    }

    public void paintBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        synthContext.getPainter().paintButtonBorder(synthContext, graphics, n, n2, n3, n4);
    }

    protected Icon getDefaultIcon(AbstractButton abstractButton) {
        SynthContext synthContext = this.getContext(abstractButton);
        Icon icon = synthContext.getStyle().getIcon(synthContext, this.getPropertyPrefix() + "icon");
        synthContext.dispose();
        return icon;
    }

    protected Icon getIcon(AbstractButton abstractButton) {
        Icon icon = this.getEnabledIcon(abstractButton);
        ButtonModel buttonModel = abstractButton.getModel();
        Icon icon2 = null;
        if (!buttonModel.isEnabled()) {
            icon2 = this.getSynthDisabledIcon(abstractButton);
        } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
            icon2 = this.getPressedIcon(abstractButton);
        } else if (abstractButton.isRolloverEnabled() && buttonModel.isRollover()) {
            icon2 = this.getRolloverIcon(abstractButton);
        } else if (buttonModel.isSelected()) {
            icon2 = this.getSelectedIcon(abstractButton);
        }
        if (icon2 != null) {
            icon = icon2;
        }
        if (icon == null) {
            return this.getDefaultIcon(abstractButton);
        }
        return icon;
    }

    private Icon getSynthIcon(AbstractButton abstractButton, int n) {
        return this.style.getIcon(this.getContext(abstractButton, n), this.getPropertyPrefix() + "icon");
    }

    private Icon getEnabledIcon(AbstractButton abstractButton) {
        Icon icon = abstractButton.getIcon();
        if (icon == null) {
            icon = this.getSynthIcon(abstractButton, 1);
        }
        return icon;
    }

    private Icon getSelectedIcon(AbstractButton abstractButton) {
        Icon icon = abstractButton.getSelectedIcon();
        if (icon == null) {
            icon = this.getSynthIcon(abstractButton, 512);
        }
        return icon;
    }

    private Icon getRolloverIcon(AbstractButton abstractButton) {
        Icon icon;
        ButtonModel buttonModel = abstractButton.getModel();
        if (buttonModel.isSelected()) {
            icon = abstractButton.getRolloverSelectedIcon();
            if (icon == null && (icon = this.getSynthIcon(abstractButton, 512)) == null) {
                icon = this.getSelectedIcon(abstractButton);
            }
        } else {
            icon = abstractButton.getRolloverIcon();
            if (icon == null) {
                icon = this.getSynthIcon(abstractButton, 2);
            }
        }
        return icon;
    }

    private Icon getPressedIcon(AbstractButton abstractButton) {
        Icon icon = abstractButton.getPressedIcon();
        if (icon == null && (icon = this.getSynthIcon(abstractButton, 4)) == null) {
            icon = this.getSelectedIcon(abstractButton);
        }
        return icon;
    }

    private Icon getSynthDisabledIcon(AbstractButton abstractButton) {
        Icon icon;
        ButtonModel buttonModel = abstractButton.getModel();
        if (buttonModel.isSelected()) {
            icon = abstractButton.getDisabledSelectedIcon();
            if (icon == null) {
                icon = this.getSynthIcon(abstractButton, 520);
            }
        } else {
            icon = abstractButton.getDisabledIcon();
            if (icon == null) {
                icon = this.getSynthIcon(abstractButton, 8);
            }
        }
        return icon;
    }

    protected int getTextShiftOffset(SynthContext synthContext) {
        AbstractButton abstractButton = (AbstractButton)synthContext.getComponent();
        ButtonModel buttonModel = abstractButton.getModel();
        if (buttonModel.isArmed() && buttonModel.isPressed() && abstractButton.getPressedIcon() == null) {
            return synthContext.getStyle().getInt(synthContext, this.getPropertyPrefix() + "textShiftOffset", 0);
        }
        return 0;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        if (jComponent.getComponentCount() > 0 && jComponent.getLayout() != null) {
            return null;
        }
        AbstractButton abstractButton = (AbstractButton)jComponent;
        SynthContext synthContext = this.getContext(jComponent);
        Dimension dimension = synthContext.getStyle().getGraphicsUtils(synthContext).getMinimumSize(synthContext, synthContext.getStyle().getFont(synthContext), abstractButton.getText(), this.getSizingIcon(abstractButton), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalAlignment(), abstractButton.getHorizontalTextPosition(), abstractButton.getVerticalTextPosition(), abstractButton.getIconTextGap(), abstractButton.getDisplayedMnemonicIndex());
        synthContext.dispose();
        return dimension;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        if (jComponent.getComponentCount() > 0 && jComponent.getLayout() != null) {
            return null;
        }
        AbstractButton abstractButton = (AbstractButton)jComponent;
        SynthContext synthContext = this.getContext(jComponent);
        Dimension dimension = synthContext.getStyle().getGraphicsUtils(synthContext).getPreferredSize(synthContext, synthContext.getStyle().getFont(synthContext), abstractButton.getText(), this.getSizingIcon(abstractButton), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalAlignment(), abstractButton.getHorizontalTextPosition(), abstractButton.getVerticalTextPosition(), abstractButton.getIconTextGap(), abstractButton.getDisplayedMnemonicIndex());
        synthContext.dispose();
        return dimension;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        if (jComponent.getComponentCount() > 0 && jComponent.getLayout() != null) {
            return null;
        }
        AbstractButton abstractButton = (AbstractButton)jComponent;
        SynthContext synthContext = this.getContext(jComponent);
        Dimension dimension = synthContext.getStyle().getGraphicsUtils(synthContext).getMaximumSize(synthContext, synthContext.getStyle().getFont(synthContext), abstractButton.getText(), this.getSizingIcon(abstractButton), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalAlignment(), abstractButton.getHorizontalTextPosition(), abstractButton.getVerticalTextPosition(), abstractButton.getIconTextGap(), abstractButton.getDisplayedMnemonicIndex());
        synthContext.dispose();
        return dimension;
    }

    protected Icon getSizingIcon(AbstractButton abstractButton) {
        return abstractButton.isEnabled() ? abstractButton.getIcon() : abstractButton.getDisabledIcon();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (SynthLookAndFeel.shouldUpdateStyle(propertyChangeEvent)) {
            this.updateStyle((AbstractButton)propertyChangeEvent.getSource());
        }
    }
}

