/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.awt.X11.IXAnyEvent;
import sun.awt.X11.XAnyEvent;
import sun.awt.X11.XAtom;
import sun.awt.X11.XAwtState;
import sun.awt.X11.XButtonEvent;
import sun.awt.X11.XClientMessageEvent;
import sun.awt.X11.XConfigureEvent;
import sun.awt.X11.XConstants;
import sun.awt.X11.XCreateWindowParams;
import sun.awt.X11.XDestroyWindowEvent;
import sun.awt.X11.XPropertyEvent;
import sun.awt.X11.XRootWindow;
import sun.awt.X11.XSetWindowAttributes;
import sun.awt.X11.XSizeHints;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XUtilConstants;
import sun.awt.X11.XWMHints;
import sun.awt.X11.XlibWrapper;

public class XBaseWindow
implements XConstants,
XUtilConstants {
    private static final Logger log = Logger.getLogger("sun.awt.X11.XBaseWindow");
    private static final Logger insLog = Logger.getLogger("sun.awt.X11.insets.XBaseWindow");
    private static final Logger eventLog = Logger.getLogger("sun.awt.X11.event.XBaseWindow");
    private static final Logger focusLog = Logger.getLogger("sun.awt.X11.focus.XBaseWindow");
    public static final String PARENT_WINDOW = "parent window";
    public static final String BOUNDS = "bounds";
    public static final String OVERRIDE_REDIRECT = "overrideRedirect";
    public static final String EVENT_MASK = "event mask";
    public static final String VALUE_MASK = "value mask";
    public static final String BORDER_PIXEL = "border pixel";
    public static final String COLORMAP = "color map";
    public static final String DEPTH = "visual depth";
    public static final String VISUAL_CLASS = "visual class";
    public static final String VISUAL = "visual";
    public static final String EMBEDDED = "embedded";
    public static final String DELAYED = "delayed";
    public static final String PARENT = "parent";
    public static final String BACKGROUND_PIXMAP = "pixmap";
    public static final String VISIBLE = "visible";
    public static final String SAVE_UNDER = "save under";
    public static final String BACKING_STORE = "backing store";
    public static final String BIT_GRAVITY = "bit gravity";
    private XCreateWindowParams delayedParams;
    long window;
    boolean visible;
    boolean mapped;
    boolean embedded;
    Rectangle maxBounds;
    private boolean disposed;
    private long screen;
    private XSizeHints hints;
    private XWMHints wmHints;
    static final int MIN_SIZE = 1;
    static final int DEF_LOCATION = 1;
    private static XAtom wm_client_leader;
    int x;
    int y;
    int width;
    int height;
    protected StateLock state_lock;

    protected final void init(long l, Rectangle rectangle) {
    }

    protected final void preInit() {
    }

    protected final void postInit() {
    }

    void instantPreInit(XCreateWindowParams xCreateWindowParams) {
        this.state_lock = new StateLock();
    }

    void preInit(XCreateWindowParams xCreateWindowParams) {
        this.state_lock = new StateLock();
        this.embedded = Boolean.TRUE.equals(xCreateWindowParams.get(EMBEDDED));
        this.visible = Boolean.TRUE.equals(xCreateWindowParams.get(VISIBLE));
        this.screen = -1L;
    }

    void postInit(XCreateWindowParams xCreateWindowParams) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("WM name is " + this.getWMName());
        }
        this.setWMName(this.getWMName());
        this.initClientLeader();
    }

    static final Object getAWTLock() {
        return XToolkit.getAWTLock();
    }

    protected final void init(XCreateWindowParams xCreateWindowParams) {
        if (!Boolean.TRUE.equals(xCreateWindowParams.get(DELAYED))) {
            this.preInit(xCreateWindowParams);
            this.create(xCreateWindowParams);
            this.postInit(xCreateWindowParams);
        } else {
            this.instantPreInit(xCreateWindowParams);
            this.delayedParams = xCreateWindowParams;
        }
    }

    XBaseWindow() {
        this(new XCreateWindowParams());
    }

    XBaseWindow(long l, Rectangle rectangle) {
        this(new XCreateWindowParams(new Object[]{BOUNDS, rectangle, PARENT_WINDOW, new Long(l)}));
    }

    XBaseWindow(Rectangle rectangle) {
        this(new XCreateWindowParams(new Object[]{BOUNDS, rectangle}));
    }

    public XBaseWindow(XCreateWindowParams xCreateWindowParams) {
        this.init(xCreateWindowParams);
    }

    XBaseWindow(long l) {
        this(new XCreateWindowParams(new Object[]{PARENT_WINDOW, new Long(l), EMBEDDED, Boolean.TRUE}));
    }

    protected void checkParams(XCreateWindowParams xCreateWindowParams) {
        if (xCreateWindowParams == null) {
            throw new IllegalArgumentException("Window creation parameters are null");
        }
        xCreateWindowParams.putIfNull((Object)PARENT_WINDOW, new Long(XToolkit.getDefaultRootWindow()));
        xCreateWindowParams.putIfNull((Object)BOUNDS, new Rectangle(1, 1, 1, 1));
        xCreateWindowParams.putIfNull((Object)DEPTH, new Integer(0));
        xCreateWindowParams.putIfNull((Object)VISUAL, new Long(0L));
        xCreateWindowParams.putIfNull((Object)VISUAL_CLASS, new Integer(2));
        xCreateWindowParams.putIfNull((Object)VALUE_MASK, new Long(2048L));
        Rectangle rectangle = (Rectangle)xCreateWindowParams.get(BOUNDS);
        rectangle.width = Math.max(1, rectangle.width);
        rectangle.height = Math.max(1, rectangle.height);
        Long l = (Long)xCreateWindowParams.get(EVENT_MASK);
        long l2 = l != null ? l : 0L;
        xCreateWindowParams.put(EVENT_MASK, new Long(l2 |= 0x1400000L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void create(XCreateWindowParams xCreateWindowParams) {
        Object object = XBaseWindow.getAWTLock();
        synchronized (object) {
            XSetWindowAttributes xSetWindowAttributes = new XSetWindowAttributes();
            try {
                Integer n;
                Integer n2;
                Boolean bl;
                Long l;
                Long l2;
                this.checkParams(xCreateWindowParams);
                long l3 = (Long)xCreateWindowParams.get(VALUE_MASK);
                Long l4 = (Long)xCreateWindowParams.get(EVENT_MASK);
                xSetWindowAttributes.set_event_mask(l4);
                l3 |= 0x800L;
                Long l5 = (Long)xCreateWindowParams.get(BORDER_PIXEL);
                if (l5 != null) {
                    xSetWindowAttributes.set_border_pixel(l5);
                    l3 |= 8L;
                }
                if ((l2 = (Long)xCreateWindowParams.get(COLORMAP)) != null) {
                    xSetWindowAttributes.set_colormap(l2);
                    l3 |= 0x2000L;
                }
                if ((l = (Long)xCreateWindowParams.get(BACKGROUND_PIXMAP)) != null) {
                    xSetWindowAttributes.set_background_pixmap(l);
                    l3 |= 1L;
                }
                Long l6 = (Long)xCreateWindowParams.get(PARENT_WINDOW);
                Rectangle rectangle = (Rectangle)xCreateWindowParams.get(BOUNDS);
                Integer n3 = (Integer)xCreateWindowParams.get(DEPTH);
                Integer n4 = (Integer)xCreateWindowParams.get(VISUAL_CLASS);
                Long l7 = (Long)xCreateWindowParams.get(VISUAL);
                Boolean bl2 = (Boolean)xCreateWindowParams.get(OVERRIDE_REDIRECT);
                if (bl2 != null) {
                    xSetWindowAttributes.set_override_redirect(bl2);
                    l3 |= 0x200L;
                }
                if ((bl = (Boolean)xCreateWindowParams.get(SAVE_UNDER)) != null) {
                    xSetWindowAttributes.set_save_under(bl);
                    l3 |= 0x400L;
                }
                if ((n2 = (Integer)xCreateWindowParams.get(BACKING_STORE)) != null) {
                    xSetWindowAttributes.set_backing_store(n2);
                    l3 |= 0x40L;
                }
                if ((n = (Integer)xCreateWindowParams.get(BIT_GRAVITY)) != null) {
                    xSetWindowAttributes.set_bit_gravity(n);
                    l3 |= 0x10L;
                }
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Creating window for " + this + " with the following attributes: \n" + xCreateWindowParams);
                }
                this.window = XlibWrapper.XCreateWindow(XToolkit.getDisplay(), l6, rectangle.x, rectangle.y, rectangle.width, rectangle.height, 0, n3, n4.intValue(), l7, l3, xSetWindowAttributes.pData);
                if (this.window == 0L) {
                    throw new IllegalStateException("Couldn't create window because of wrong parameters. Run with NOISY_AWT to see details");
                }
                XToolkit.addToWinMap(this.window, this);
            }
            finally {
                xSetWindowAttributes.dispose();
            }
        }
    }

    public XCreateWindowParams getDelayedParams() {
        return this.delayedParams;
    }

    protected String getWMName() {
        return XToolkit.getCorrectXIDString(this.getClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initClientLeader() {
        Object object = XBaseWindow.getAWTLock();
        synchronized (object) {
            if (wm_client_leader == null) {
                wm_client_leader = XAtom.get("WM_CLIENT_LEADER");
            }
            wm_client_leader.setWindowProperty(this, XBaseWindow.getXAWTRootWindow());
        }
    }

    static XRootWindow getXAWTRootWindow() {
        return XRootWindow.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroy() {
        Object object = XBaseWindow.getAWTLock();
        synchronized (object) {
            if (this.hints != null) {
                XlibWrapper.XFree(this.hints.pData);
                this.hints = null;
            }
            XToolkit.removeFromWinMap(this.getWindow(), this);
            XlibWrapper.XDestroyWindow(XToolkit.getDisplay(), this.getWindow());
            this.window = -1L;
            if (!this.isDisposed()) {
                this.setDisposed(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flush() {
        Object object = XBaseWindow.getAWTLock();
        synchronized (object) {
            XlibWrapper.XFlush(XToolkit.getDisplay());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setWMHints(XWMHints xWMHints) {
        Object object = XBaseWindow.getAWTLock();
        synchronized (object) {
            XlibWrapper.XSetWMHints(XToolkit.getDisplay(), this.getWindow(), xWMHints.pData);
        }
    }

    public XWMHints getWMHints() {
        if (this.wmHints == null) {
            this.wmHints = new XWMHints(XlibWrapper.XAllocWMHints());
        }
        return this.wmHints;
    }

    public XSizeHints getHints() {
        if (this.hints == null) {
            long l = XlibWrapper.XAllocSizeHints();
            this.hints = new XSizeHints(l);
        }
        return this.hints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSizeHints(long l, int n, int n2, int n3, int n4) {
        if (insLog.isLoggable(Level.FINER)) {
            insLog.finer("Setting hints, flags " + XlibWrapper.hintsToString(l));
        }
        Object object = XBaseWindow.getAWTLock();
        synchronized (object) {
            XSizeHints xSizeHints = this.getHints();
            if ((l & 4L) != 0L) {
                xSizeHints.set_x(n);
                xSizeHints.set_y(n2);
            }
            if ((l & 8L) != 0L) {
                xSizeHints.set_width(n3);
                xSizeHints.set_height(n4);
            }
            if ((l & 0x10L) != 0L) {
                xSizeHints.set_min_width(n3);
                xSizeHints.set_min_height(n4);
            } else if ((xSizeHints.get_flags() & 0x10L) != 0L) {
                l |= 0x10L;
                xSizeHints.set_min_width(1);
                xSizeHints.set_min_height(1);
            }
            if ((l & 0x20L) != 0L) {
                if (this.maxBounds != null) {
                    if (this.maxBounds.width != Integer.MAX_VALUE) {
                        xSizeHints.set_max_width(this.maxBounds.width);
                    } else {
                        xSizeHints.set_max_width(XToolkit.getDefaultScreenWidth());
                    }
                    if (this.maxBounds.height != Integer.MAX_VALUE) {
                        xSizeHints.set_max_height(this.maxBounds.height);
                    } else {
                        xSizeHints.set_max_height(XToolkit.getDefaultScreenHeight());
                    }
                } else {
                    xSizeHints.set_max_width(n3);
                    xSizeHints.set_max_height(n4);
                }
            } else if ((xSizeHints.get_flags() & 0x20L) != 0L) {
                l |= 0x20L;
                if (this.maxBounds != null) {
                    if (this.maxBounds.width != Integer.MAX_VALUE) {
                        xSizeHints.set_max_width(this.maxBounds.width);
                    } else {
                        xSizeHints.set_max_width(XToolkit.getDefaultScreenWidth());
                    }
                    if (this.maxBounds.height != Integer.MAX_VALUE) {
                        xSizeHints.set_max_height(this.maxBounds.height);
                    } else {
                        xSizeHints.set_max_height(XToolkit.getDefaultScreenHeight());
                    }
                }
            }
            xSizeHints.set_flags(l |= 0x200L);
            xSizeHints.set_win_gravity(1);
            if (insLog.isLoggable(Level.FINER)) {
                insLog.finer("Setting hints, resulted flags " + XlibWrapper.hintsToString(l) + ", values " + xSizeHints);
            }
            XlibWrapper.XSetWMNormalHints(XToolkit.getDisplay(), this.getWindow(), xSizeHints.pData);
        }
    }

    Object getStateLock() {
        return this.state_lock;
    }

    public long getWindow() {
        return this.window;
    }

    public long getContentWindow() {
        return this.window;
    }

    public Rectangle getBounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public Dimension getSize() {
        return new Dimension(this.width, this.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toFront() {
        Object object = XBaseWindow.getAWTLock();
        synchronized (object) {
            XlibWrapper.XRaiseWindow(XToolkit.getDisplay(), this.getWindow());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void xRequestFocus(long l) {
        Object object = XBaseWindow.getAWTLock();
        synchronized (object) {
            if (focusLog.isLoggable(Level.FINER)) {
                focusLog.finer("XSetInputFocus on " + this.getWindow() + " with time " + l);
            }
            XlibWrapper.XSetInputFocus2(XToolkit.getDisplay(), this.getWindow(), l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void xRequestFocus() {
        Object object = XBaseWindow.getAWTLock();
        synchronized (object) {
            if (focusLog.isLoggable(Level.FINER)) {
                focusLog.finer("XSetInputFocus on " + this.getWindow());
            }
            XlibWrapper.XSetInputFocus(XToolkit.getDisplay(), this.getWindow());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long xGetInputFocus() {
        Object object = XBaseWindow.getAWTLock();
        synchronized (object) {
            return XlibWrapper.XGetInputFocus(XToolkit.getDisplay());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void xSetVisible(boolean bl) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Setting visible on " + this + " to " + bl);
        }
        Object object = XBaseWindow.getAWTLock();
        synchronized (object) {
            this.visible = bl;
            if (bl) {
                XlibWrapper.XMapWindow(XToolkit.getDisplay(), this.getWindow());
            } else {
                XlibWrapper.XUnmapWindow(XToolkit.getDisplay(), this.getWindow());
            }
            XlibWrapper.XFlush(XToolkit.getDisplay());
        }
    }

    boolean isMapped() {
        return this.mapped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setWMName(String string) {
        Object object = XBaseWindow.getAWTLock();
        synchronized (object) {
            XAtom xAtom = XAtom.get(39L);
            if (string == null) {
                string = " ";
            }
            xAtom.setProperty(this.getWindow(), string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setWMClass(String[] stringArray) {
        if (stringArray.length != 2) {
            throw new IllegalArgumentException("WM_CLASS_NAME consists of exactly two strings");
        }
        Object object = XBaseWindow.getAWTLock();
        synchronized (object) {
            XAtom xAtom = XAtom.get(67L);
            xAtom.setProperty8(this.getWindow(), stringArray[0] + '\u0000' + stringArray[1]);
        }
    }

    boolean isVisible() {
        return this.visible;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long getScreenOfWindow(long l) {
        Object object = XBaseWindow.getAWTLock();
        synchronized (object) {
            return XlibWrapper.getScreenOfWindow(XToolkit.getDisplay(), l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getScreenNumber() {
        Object object = XBaseWindow.getAWTLock();
        synchronized (object) {
            return XlibWrapper.XScreenNumberOfScreen(this.getScreen());
        }
    }

    long getScreen() {
        if (this.screen == -1L) {
            this.screen = XBaseWindow.getScreenOfWindow(this.window);
        }
        return this.screen;
    }

    public void xSetBounds(Rectangle rectangle) {
        this.xSetBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void xSetBounds(int n, int n2, int n3, int n4) {
        if (this.getWindow() == 0L) {
            insLog.warning("Attempt to resize uncreated window");
            throw new IllegalStateException("Attempt to resize uncreated window");
        }
        insLog.fine("Setting bounds on " + this + " to (" + n + ", " + n2 + "), " + n3 + "x" + n4);
        if (n3 <= 0) {
            n3 = 1;
        }
        if (n4 <= 0) {
            n4 = 1;
        }
        Object object = XBaseWindow.getAWTLock();
        synchronized (object) {
            XlibWrapper.XMoveResizeWindow(XToolkit.getDisplay(), this.getWindow(), n, n2, n3, n4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Point toOtherWindow(long l, long l2, int n, int n2) {
        Point point = new Point(0, 0);
        Object object = XBaseWindow.getAWTLock();
        synchronized (object) {
            XlibWrapper.XTranslateCoordinates(XToolkit.getDisplay(), l, l2, n, n2, XlibWrapper.larg1, XlibWrapper.larg2, XlibWrapper.larg3);
            point.x = XlibWrapper.unsafe.getInt(XlibWrapper.larg1);
            point.y = XlibWrapper.unsafe.getInt(XlibWrapper.larg2);
            return point;
        }
    }

    Rectangle toGlobal(Rectangle rectangle) {
        rectangle.setLocation(this.toGlobal(rectangle.getLocation()));
        return rectangle;
    }

    Point toGlobal(Point point) {
        return this.toGlobal(point.x, point.y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Point toGlobal(int n, int n2) {
        long l;
        Object object = XBaseWindow.getAWTLock();
        synchronized (object) {
            l = XlibWrapper.RootWindow(XToolkit.getDisplay(), this.getScreenNumber());
        }
        return XBaseWindow.toOtherWindow(this.getContentWindow(), l, n, n2);
    }

    Point toLocal(Point point) {
        return this.toLocal(point.x, point.y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Point toLocal(int n, int n2) {
        long l;
        Object object = XBaseWindow.getAWTLock();
        synchronized (object) {
            l = XlibWrapper.RootWindow(XToolkit.getDisplay(), this.getScreenNumber());
        }
        return XBaseWindow.toOtherWindow(l, this.getContentWindow(), n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean grabInput() {
        Object object = XBaseWindow.getAWTLock();
        synchronized (object) {
            if (XAwtState.getGrabWindow() == this && XAwtState.isManualGrab()) {
                return true;
            }
            int n = XlibWrapper.XGrabPointer(XToolkit.getDisplay(), this.getContentWindow(), 1, 8316, 1, 1, 0L, XToolkit.arrowCursor, 0L);
            if (n != 0) {
                XAwtState.setGrabWindow(null);
                return false;
            }
            int n2 = XlibWrapper.XGrabKeyboard(XToolkit.getDisplay(), this.getContentWindow(), 1, 1, 1, 0L);
            if (n2 != 0) {
                XlibWrapper.XUngrabKeyboard(XToolkit.getDisplay(), 0L);
                XAwtState.setGrabWindow(null);
                return false;
            }
            XAwtState.setGrabWindow(this);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void ungrabInput() {
        Object object = XBaseWindow.getAWTLock();
        synchronized (object) {
            XBaseWindow xBaseWindow = XAwtState.getGrabWindow();
            if (xBaseWindow != null) {
                xBaseWindow.ungrabInputImpl();
                XlibWrapper.XUngrabPointer(XToolkit.getDisplay(), 0L);
                XlibWrapper.XUngrabKeyboard(XToolkit.getDisplay(), 0L);
                XAwtState.setGrabWindow(null);
            }
        }
    }

    void ungrabInputImpl() {
    }

    static void checkSecurity() {
        if (XToolkit.isSecurityWarningEnabled() && XToolkit.isToolkitThread()) {
            StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
            log.warning(stackTraceElementArray[1] + ": Security violation: calling user code on toolkit thread");
        }
    }

    public void handleMapNotifyEvent(long l) {
        this.mapped = true;
    }

    public void handleUnmapNotifyEvent(long l) {
        this.mapped = false;
    }

    public void handleReparentNotifyEvent(long l) {
    }

    public void handlePropertyNotify(long l) {
        if (eventLog.isLoggable(Level.FINER)) {
            XPropertyEvent xPropertyEvent = new XPropertyEvent(l);
            eventLog.finer(xPropertyEvent.toString());
        }
    }

    public void handleDestroyNotify(long l) {
        XDestroyWindowEvent xDestroyWindowEvent = new XDestroyWindowEvent(l);
        if (xDestroyWindowEvent.get_window() == this.getWindow()) {
            XToolkit.removeFromWinMap(this.getWindow(), this);
        }
    }

    public void handleClientMessage(long l) {
        if (eventLog.isLoggable(Level.FINER)) {
            XClientMessageEvent xClientMessageEvent = new XClientMessageEvent(l);
            eventLog.finer(xClientMessageEvent.toString());
        }
    }

    public void handleVisibilityEvent(long l) {
    }

    public void handleKeyPress(long l) {
    }

    public void handleKeyRelease(long l) {
    }

    public void handleExposeEvent(int n, long l) {
    }

    public void handleButtonPressRelease(int n, long l) {
        XButtonEvent xButtonEvent = new XButtonEvent(l);
        int n2 = xButtonEvent.get_state() & 0x1F00;
        switch (xButtonEvent.get_type()) {
            case 4: {
                if (n2 != 0) break;
                XAwtState.setAutoGrabWindow(this);
                break;
            }
            case 5: {
                if (!XBaseWindow.isFullRelease(n2, xButtonEvent.get_button())) break;
                XAwtState.setAutoGrabWindow(null);
            }
        }
    }

    public void handleMotionNotify(long l) {
    }

    public void handleXCrossingEvent(long l) {
    }

    public void handleConfigureNotifyEvent(long l) {
        XConfigureEvent xConfigureEvent = new XConfigureEvent(l);
        this.x = xConfigureEvent.get_x();
        this.y = xConfigureEvent.get_y();
        this.width = xConfigureEvent.get_width();
        this.height = xConfigureEvent.get_height();
    }

    static boolean isFullRelease(int n, int n2) {
        switch (n2) {
            case 1: {
                return n == 256;
            }
            case 2: {
                return n == 512;
            }
            case 3: {
                return n == 1024;
            }
            case 4: {
                return n == 2048;
            }
            case 5: {
                return n == 4096;
            }
        }
        return n == 0;
    }

    static boolean isGrabbedEvent(XAnyEvent xAnyEvent) {
        switch (xAnyEvent.get_type()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    static void dispatchToWindow(XAnyEvent xAnyEvent) {
        XBaseWindow xBaseWindow = XAwtState.getGrabWindow();
        if (xBaseWindow == null || !XBaseWindow.isGrabbedEvent(xAnyEvent)) {
            xBaseWindow = XToolkit.windowToXWindow(xAnyEvent.get_window());
        }
        if (xBaseWindow != null) {
            xBaseWindow.dispatchEvent(xAnyEvent);
        }
    }

    public void dispatchEvent(XAnyEvent xAnyEvent) {
        if (eventLog.isLoggable(Level.FINER)) {
            eventLog.finer(xAnyEvent.toString());
        }
        int n = xAnyEvent.get_type();
        long l = xAnyEvent.pData;
        if (this.isDisposed()) {
            return;
        }
        switch (n) {
            case 15: {
                this.handleVisibilityEvent(l);
                break;
            }
            case 33: {
                this.handleClientMessage(l);
                break;
            }
            case 12: 
            case 13: {
                this.handleExposeEvent(n, l);
                break;
            }
            case 4: 
            case 5: {
                this.handleButtonPressRelease(n, l);
                break;
            }
            case 6: {
                this.handleMotionNotify(l);
                break;
            }
            case 2: {
                this.handleKeyPress(l);
                break;
            }
            case 3: {
                this.handleKeyRelease(l);
                break;
            }
            case 7: 
            case 8: {
                this.handleXCrossingEvent(l);
                break;
            }
            case 22: {
                this.handleConfigureNotifyEvent(l);
                break;
            }
            case 19: {
                this.handleMapNotifyEvent(l);
                break;
            }
            case 18: {
                this.handleUnmapNotifyEvent(l);
                break;
            }
            case 21: {
                this.handleReparentNotifyEvent(l);
                break;
            }
            case 28: {
                this.handlePropertyNotify(l);
                break;
            }
            case 17: {
                this.handleDestroyNotify(l);
            }
        }
    }

    protected boolean isEventDisabled(IXAnyEvent iXAnyEvent) {
        return false;
    }

    int getX() {
        return this.x;
    }

    int getY() {
        return this.y;
    }

    int getWidth() {
        return this.width;
    }

    int getHeight() {
        return this.height;
    }

    void setDisposed(boolean bl) {
        this.disposed = bl;
    }

    boolean isDisposed() {
        return this.disposed;
    }

    static class StateLock {
        StateLock() {
        }
    }
}

