/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.systemresource;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;

public class SystemResourceURLConnection
extends URLConnection {
    URL delegateUrl;
    URLConnection delegateConnection;

    SystemResourceURLConnection(URL uRL) throws MalformedURLException, IOException {
        super(uRL);
        this.delegateUrl = this.makeDelegateUrl(uRL);
        this.delegateConnection = this.delegateUrl.openConnection();
    }

    private URL makeDelegateUrl(URL uRL) throws MalformedURLException {
        boolean bl = false;
        String string = uRL.getFile();
        if (string.startsWith("/FILE")) {
            bl = true;
        }
        int n = bl ? 5 : 4;
        int n2 = string.lastIndexOf("/+/");
        if (n2 < 0) {
            throw new MalformedURLException("no /+/ found in URL");
        }
        string = bl ? "file:" + string.substring(n, n2) + File.separatorChar + string.substring(n2 + 3, string.length()) : "jar:file:" + string.substring(n, n2) + "!/" + string.substring(n2 + 3, string.length());
        return new URL(string);
    }

    public void connect() throws IOException {
        this.delegateConnection.connect();
    }

    public Object getContent() throws IOException {
        return this.delegateConnection.getContent();
    }

    public String getContentType() {
        return this.delegateConnection.getContentType();
    }

    public InputStream getInputStream() throws IOException {
        return this.delegateConnection.getInputStream();
    }

    public String getHeaderField(String string) {
        return this.delegateConnection.getHeaderField(string);
    }

    public Permission getPermission() throws IOException {
        return this.delegateConnection.getPermission();
    }
}

