#!/usr/bin/perl -w
#
#	this script is designed to take a x-cdrecord playlist
#	playlist.lst and change it to an xmms playlist for ease of editing
#	where the format is /path/to/your_artist/album/trackname.mp3
#
#	note that this is kind of an in-between translator type thing
#	and just parses one file format into another.  no actual file
#	moving or copying or burning will take place as a result of 
#	running this script. 
#
#	
#	usage: cd2xm.pl <xcdroast.lst> <xmms.mp3>
#	where xcdroast.lst is the name of the playist for xcdroast file
#	and xmms.mp3 is the name of the file you want to write the 
#	xmms playlist to (can be a new file)
#
#	everything else should just work
#
#	by Steve Glista <smiley@fish.malachiarts.org>
#

use strict;
use vars qw($DEBUGGING $done_headers);

# Configuration
#

# this should be an xcdr path/track list
my $cdrlist = $ARGV[0];

# and this should come out looking like a .m3u playlist
my $xmmslist ="\>$ARGV[1]";

# End configuration
#
#
# the working bits:
# 

# first, open the tracklist for reading
open(INPATHS, $cdrlist)
  or die "Can't open $cdrlist: $!\n";

## store all lines 
my @paths = <INPATHS>;

## close file cause we don't need it anymore
close(INPATHS);

## open the output file
open(OUTPATHS, $xmmslist)
  or die "Can't open $xmmslist: $!\n";

## loop the part that does the actual work
foreach my $i (0..@paths-1) {
	my @track = split /\"/, $paths[$i];
	print OUTPATHS "$track[1]\n";
};

close OUTPATHS;
