.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided ``as is'' without express or implied warranty.
.\" 
.\" $XFree86: xc/doc/man/X11/XButEvent.man,v 1.2 2001/01/27 18:19:56 dawes Exp $
.\" $XdotOrg: xc/doc/man/X11/XButEvent.man,v 1.2 2004/04/23 18:42:09 eich Exp $
.\"
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.na
.de Ds
.nf
.\\$1D \\$2 \\$1
.ft 1
.\".ps \\n(PS
.\".if \\n(VS>=40 .vs \\n(VSu
.\".if \\n(VS<=39 .vs \\n(VSp
..
.de De
.ce 0
.if \\n(BD .DF
.nr BD 0
.in \\n(OIu
.if \\n(TM .ls 2
.sp \\n(DDu
.fi
..
.de FD
.LP
.KS
.TA .5i 3i
.ta .5i 3i
.nf
..
.de FN
.fi
.KE
.LP
..
.de IN		\" send an index entry to the stderr
..
.de C{
.KS
.nf
.D
.\"
.\"	choose appropriate monospace font
.\"	the imagen conditional, 480,
.\"	may be changed to L if LB is too
.\"	heavy for your eyes...
.\"
.ie "\\*(.T"480" .ft L
.el .ie "\\*(.T"300" .ft L
.el .ie "\\*(.T"202" .ft PO
.el .ie "\\*(.T"aps" .ft CW
.el .ft R
.ps \\n(PS
.ie \\n(VS>40 .vs \\n(VSu
.el .vs \\n(VSp
..
.de C}
.DE
.R
..
.de Pn
.ie t \\$1\fB\^\\$2\^\fR\\$3
.el \\$1\fI\^\\$2\^\fP\\$3
..
.de ZN
.ie t \fB\^\\$1\^\fR\\$2
.el \fI\^\\$1\^\fP\\$2
..
.de hN
.ie t <\fB\\$1\fR>\\$2
.el <\fI\\$1\fP>\\$2
..
.de NT
.ne 7
.ds NO Note
.if \\n(.$>$1 .if !'\\$2'C' .ds NO \\$2
.if \\n(.$ .if !'\\$1'C' .ds NO \\$1
.ie n .sp
.el .sp 10p
.TB
.ce
\\*(NO
.ie n .sp
.el .sp 5p
.if '\\$1'C' .ce 99
.if '\\$2'C' .ce 99
.in +5n
.ll -5n
.R
..
.		\" Note End -- doug kraft 3/85
.de NE
.ce 0
.in -5n
.ll +5n
.ie n .sp
.el .sp 10p
..
.ny0
.TH XButtonEvent 3X11 __xorgversion__ "XLIB FUNCTIONS"
.SH NAME
XButtonEvent, XKeyEvent, XMotionEvent \- KeyPress, KeyRelease, ButtonPress, ButtonRelease, and MotionNotify event structures
.SH STRUCTURES
The structures for
.ZN KeyPress ,
.ZN KeyRelease ,
.ZN ButtonPress ,
.ZN ButtonRelease ,
and
.ZN MotionNotify
events contain:
.LP
.Ds 0
.TA .5i 3i
.ta .5i 3i
typedef struct {
	int type;	/\(** ButtonPress or ButtonRelease */
	unsigned long serial;	/\(** # of last request processed by server */
	Bool send_event;	/\(** true if this came from a SendEvent request */
	Display *display;	/\(** Display the event was read from */
	Window window;	/\(** ``event'' window it is reported relative to */
	Window root;	/\(** root window that the event occurred on */
	Window subwindow;	/\(** child window */
	Time time;	/\(** milliseconds */
	int x, y;	/\(** pointer x, y coordinates in event window */
	int x_root, y_root;	/\(** coordinates relative to root */
	unsigned int state;	/\(** key or button mask */
	unsigned int button;	/\(** detail */
	Bool same_screen;	/\(** same screen flag */
} XButtonEvent;
typedef XButtonEvent XButtonPressedEvent;
typedef XButtonEvent XButtonReleasedEvent;
.De
.LP
.Ds 0
.TA .5i 3i
.ta .5i 3i
typedef struct {
	int type;	/\(** KeyPress or KeyRelease */
	unsigned long serial;	/\(** # of last request processed by server */
	Bool send_event;	/\(** true if this came from a SendEvent request */
	Display *display;	/\(** Display the event was read from */
	Window window;	/\(** ``event'' window it is reported relative to */
	Window root;	/\(** root window that the event occurred on */
	Window subwindow;	/\(** child window */
	Time time;	/\(** milliseconds */
	int x, y;	/\(** pointer x, y coordinates in event window */
	int x_root, y_root;	/\(** coordinates relative to root */
	unsigned int state;	/\(** key or button mask */
	unsigned int keycode;	/\(** detail */
	Bool same_screen;	/\(** same screen flag */
} XKeyEvent;
typedef XKeyEvent XKeyPressedEvent;
typedef XKeyEvent XKeyReleasedEvent;
.De
.LP
.Ds 0
.TA .5i 3i
.ta .5i 3i
typedef struct {
	int type;	/\(** MotionNotify */
	unsigned long serial;	/\(** # of last request processed by server */
	Bool send_event;	/\(** true if this came from a SendEvent request */
	Display *display;	/\(** Display the event was read from */
	Window window;	/\(** ``event'' window reported relative to */
	Window root;	/\(** root window that the event occurred on */
	Window subwindow;	/\(** child window */
	Time time;	/\(** milliseconds */
	int x, y;	/\(** pointer x, y coordinates in event window */
	int x_root, y_root;	/\(** coordinates relative to root */
	unsigned int state;	/\(** key or button mask */
	char is_hint;	/\(** detail */
	Bool same_screen;	/\(** same screen flag */
} XMotionEvent;
typedef XMotionEvent XPointerMovedEvent;
.De
.LP
When you receive these events,
their structure members are set as follows.
.LP
The type member is set to the event type constant name that uniquely identifies
it.
For example, when the X server reports a
.ZN GraphicsExpose
event to a client application, it sends an
.ZN XGraphicsExposeEvent
structure with the type member set to
.ZN GraphicsExpose .
The display member is set to a pointer to the display the event was read on.
The send_event member is set to
.ZN True
if the event came from a
.ZN SendEvent
protocol request.
The serial member is set from the serial number reported in the protocol
but expanded from the 16-bit least-significant bits to a full 32-bit value.
The window member is set to the window that is most useful to toolkit
dispatchers.
.LP
These structures have the following common members:
window, root, subwindow, time, x, y, x_root, y_root, state, and same_screen.
The window member is set to the window on which the
event was generated and is referred to as the event window. 
As long as the conditions previously discussed are met,
this is the window used by the X server to report the event.
The root member is set to the source window's root window.
The x_root and y_root members are set to the pointer's coordinates
relative to the root window's origin at the time of the event.
.LP
The same_screen member is set to indicate whether the event 
window is on the same screen
as the root window and can be either
.ZN True 
or
.ZN False .
If
.ZN True ,
the event and root windows are on the same screen.
If
.ZN False ,
the event and root windows are not on the same screen.
.LP
If the source window is an inferior of the event window, 
the subwindow member of the structure is set to the child of the event window
that is the source window or the child of the event window that is
an ancestor of the source window.
Otherwise, the X server sets the subwindow member to
.ZN None .
The time member is set to the time when the event was generated 
and is expressed in milliseconds.
.LP
If the event window is on the same screen as the root window, 
the x and y members
are set to the coordinates relative to the event window's origin.
Otherwise, these members are set to zero.
.LP
The state member is set to indicate the logical state of the pointer buttons 
and modifier keys just prior to the event,
which is the bitwise inclusive OR of one or more of the
button or modifier key masks:
.ZN Button1Mask ,
.ZN Button2Mask ,
.ZN Button3Mask ,
.ZN Button4Mask ,
.ZN Button5Mask ,
.ZN ShiftMask ,
.ZN LockMask ,
.ZN ControlMask ,
.ZN Mod1Mask ,
.ZN Mod2Mask ,
.ZN Mod3Mask ,
.ZN Mod4Mask ,
and
.ZN Mod5Mask .
.LP
Each of these structures also has a member that indicates the detail.
For the
.ZN XKeyPressedEvent
and
.ZN XKeyReleasedEvent
structures, this member is called a keycode.
It is set to a number that represents a physical key on the keyboard.
The keycode is an arbitrary representation for any key on the keyboard
(see sections 12.7 and 16.1).
.LP
For the
.ZN XButtonPressedEvent
and
.ZN XButtonReleasedEvent
structures, this member is called button.
It represents the pointer button that changed state and can be the
.ZN Button1 ,
.ZN Button2 ,
.ZN Button3 ,
.ZN Button4 ,
or
.ZN Button5 
value.
For the
.ZN XPointerMovedEvent
structure, this member is called is_hint.
It can be set to 
.ZN NotifyNormal
or
.ZN NotifyHint .
.SH "SEE ALSO"
XAnyEvent(3X11),
XCreateWindowEvent(3X11),
XCirculateEvent(3X11),
XCirculateRequestEvent(3X11),
XColormapEvent(3X11),
XConfigureEvent(3X11),
XConfigureRequestEvent(3X11),
XCrossingEvent(3X11),
XDestroyWindowEvent(3X11),
XErrorEvent(3X11),
XExposeEvent(3X11),
XFocusChangeEvent(3X11),
XGraphicsExposeEvent(3X11),
XGravityEvent(3X11),
XKeymapEvent(3X11),
XMapEvent(3X11),
XMapRequestEvent(3X11),
XPropertyEvent(3X11),
XReparentEvent(3X11),
XResizeRequestEvent(3X11),
XSelectionClearEvent(3X11),
XSelectionEvent(3X11),
XSelectionRequestEvent(3X11),
XUnmapEvent(3X11),
XVisibilityEvent(3X11)
.br
\fI\*(xL\fP
