/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger.cdbg.basic;

import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.cdbg.FieldIdentifier;
import sun.jvm.hotspot.debugger.cdbg.ObjectVisitor;
import sun.jvm.hotspot.debugger.cdbg.RefType;
import sun.jvm.hotspot.debugger.cdbg.Type;
import sun.jvm.hotspot.debugger.cdbg.TypeVisitor;
import sun.jvm.hotspot.debugger.cdbg.basic.BasicCDebugInfoDataBase;
import sun.jvm.hotspot.debugger.cdbg.basic.BasicType;
import sun.jvm.hotspot.debugger.cdbg.basic.ResolveListener;

public class BasicRefType
extends BasicType
implements RefType {
    private Type targetType;

    public BasicRefType(String name, int size, Type targetType) {
        this(name, size, targetType, 0);
    }

    private BasicRefType(String name, int size, Type targetType, int cvAttributes) {
        super(name, size, cvAttributes);
        this.targetType = targetType;
        if (!((BasicType)targetType).isLazy()) {
            this.computeName();
        }
    }

    public RefType asRef() {
        return this;
    }

    public Type getTargetType() {
        return this.targetType;
    }

    Type resolveTypes(BasicCDebugInfoDataBase db, ResolveListener listener) {
        super.resolveTypes(db, listener);
        this.targetType = db.resolveType(this, this.targetType, listener, "resolving ref type");
        this.computeName();
        return this;
    }

    public void iterateObject(Address a, ObjectVisitor v, FieldIdentifier f) {
        v.doRef(f, a.getAddressAt(0L));
    }

    protected Type createCVVariant(int cvAttributes) {
        return new BasicRefType(this.getName(), this.getSize(), this.getTargetType(), cvAttributes);
    }

    public void visit(TypeVisitor v) {
        v.doRefType(this);
    }

    private void computeName() {
        this.setName(this.targetType.getName() + " &");
    }
}

