/*
 * Decompiled with CFR 0.152.
 */
package java2d;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Date;
import java2d.DemoGroup;
import java2d.DemoPanel;
import java2d.Java2Demo;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;

public class RunWindow
extends JPanel
implements Runnable,
ActionListener {
    static JButton runB;
    static int delay;
    static int numRuns;
    static boolean exit;
    static JCheckBox zoomCB;
    static JCheckBox printCB;
    static boolean buffersFlag;
    static int bufBeg;
    static int bufEnd;
    private JTextField delayTextField;
    private JTextField runsTextField;
    private Thread thread;
    private JProgressBar pb;
    private DemoGroup dg = null;
    private DemoPanel dp = null;

    public RunWindow() {
        this.setLayout(new GridBagLayout());
        EmptyBorder emptyBorder = new EmptyBorder(5, 5, 5, 5);
        this.setBorder(new CompoundBorder(emptyBorder, new BevelBorder(1)));
        Font font = new Font("serif", 0, 10);
        runB = new JButton("Run");
        runB.setBackground(Color.GREEN);
        runB.addActionListener(this);
        runB.setMinimumSize(new Dimension(70, 30));
        Java2Demo.addToGridBag(this, runB, 0, 0, 1, 1, 0.0, 0.0);
        this.pb = new JProgressBar();
        this.pb.setPreferredSize(new Dimension(100, 30));
        this.pb.setMinimum(0);
        Java2Demo.addToGridBag(this, this.pb, 1, 0, 2, 1, 1.0, 0.0);
        JPanel jPanel = new JPanel(new GridLayout(2, 2));
        JPanel jPanel2 = new JPanel();
        JLabel jLabel = new JLabel("Runs:");
        jLabel.setFont(font);
        jLabel.setForeground(Color.BLACK);
        jPanel2.add(jLabel);
        this.runsTextField = new JTextField(String.valueOf(numRuns));
        jPanel2.add(this.runsTextField);
        this.runsTextField.setPreferredSize(new Dimension(30, 20));
        this.runsTextField.addActionListener(this);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel();
        jLabel = new JLabel("Delay:");
        jLabel.setFont(font);
        jLabel.setForeground(Color.BLACK);
        jPanel2.add(jLabel);
        this.delayTextField = new JTextField(String.valueOf(delay));
        jPanel2.add(this.delayTextField);
        this.delayTextField.setPreferredSize(new Dimension(30, 20));
        this.delayTextField.addActionListener(this);
        jPanel.add(jPanel2);
        zoomCB.setHorizontalAlignment(0);
        zoomCB.setFont(font);
        printCB.setFont(font);
        jPanel.add(zoomCB);
        jPanel.add(printCB);
        printCB.addActionListener(this);
        Java2Demo.addToGridBag(this, jPanel, 0, 1, 3, 1, 1.0, 1.0);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(printCB)) {
            Java2Demo.printCB.setSelected(printCB.isSelected());
        } else if (actionEvent.getSource().equals(this.delayTextField)) {
            delay = Integer.parseInt(this.delayTextField.getText().trim());
        } else if (actionEvent.getSource().equals(this.runsTextField)) {
            numRuns = Integer.parseInt(this.runsTextField.getText().trim());
        } else if (actionEvent.getActionCommand() == "Run") {
            this.doRunAction();
        } else if (actionEvent.getActionCommand() == "Stop") {
            this.stop();
        }
    }

    public void doRunAction() {
        runB.setText("Stop");
        runB.setBackground(Color.RED);
        this.start();
    }

    public void start() {
        this.thread = new Thread(this);
        this.thread.setPriority(6);
        this.thread.setName("RunWindow");
        this.thread.start();
    }

    public synchronized void stop() {
        if (this.thread != null) {
            this.thread.interrupt();
        }
        this.thread = null;
        this.notifyAll();
    }

    public void sleepPerTab() {
        for (int i = 0; i < delay + 1 && this.thread != null; ++i) {
            for (int j = 0; j < 10 && this.thread != null; ++j) {
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Runnable runnable = new Runnable(){

                public void run() {
                    RunWindow.this.pb.setValue(RunWindow.this.pb.getValue() + 1);
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    private void printDemo(final DemoGroup demoGroup) {
        Runnable runnable = new Runnable(){

            public void run() {
                if (!Java2Demo.controls.toolBarCB.isSelected()) {
                    Java2Demo.controls.toolBarCB.setSelected(true);
                    demoGroup.invalidate();
                }
                for (Component component : demoGroup.getPanel().getComponents()) {
                    DemoPanel demoPanel = (DemoPanel)component;
                    if (demoPanel.tools == null) continue;
                    if (demoPanel.surface.animating != null && demoPanel.surface.animating.thread != null) {
                        demoPanel.tools.startStopB.doClick();
                    }
                    demoPanel.tools.printB.doClick();
                }
            }
        };
        RunWindow.invokeAndWait(runnable);
    }

    public void run() {
        System.out.println("\nJava2D Demo RunWindow : " + numRuns + " Runs, " + delay + " second delay between tabs\n" + "java version: " + System.getProperty("java.version") + "\n" + System.getProperty("os.name") + " " + System.getProperty("os.version") + "\n");
        Runtime runtime = Runtime.getRuntime();
        for (int i = 0; i < numRuns && this.thread != null; ++i) {
            Date date = new Date();
            System.out.print("#" + i + " " + date.toString() + ", ");
            runtime.gc();
            float f = runtime.freeMemory();
            float f2 = runtime.totalMemory();
            System.out.println((f2 - f) / 1024.0f + "K used");
            for (int j = 0; j < Java2Demo.tabbedPane.getTabCount() && this.thread != null; ++j) {
                final int n = j;
                Runnable runnable = new Runnable(){

                    public void run() {
                        RunWindow.this.pb.setValue(0);
                        RunWindow.this.pb.setMaximum(delay);
                        if (n != 0) {
                            RunWindow.this.dg = Java2Demo.group[n - 1];
                            RunWindow.this.dg.invalidate();
                        }
                        Java2Demo.tabbedPane.setSelectedIndex(n);
                    }
                };
                RunWindow.invokeAndWait(runnable);
                if (j != 0 && (zoomCB.isSelected() || buffersFlag)) {
                    this.dp = (DemoPanel)this.dg.getPanel().getComponent(0);
                    if (this.dg.tabbedPane == null && this.dp.surface != null) {
                        Runnable runnable2 = new Runnable(){

                            public void run() {
                                RunWindow.this.dg.mouseClicked(new MouseEvent(((RunWindow)RunWindow.this).dp.surface, 500, 0L, 0, 10, 10, 1, false));
                            }
                        };
                        RunWindow.invokeAndWait(runnable2);
                    }
                    for (int k = 1; k < this.dg.tabbedPane.getTabCount() && this.thread != null; ++k) {
                        final int n2 = k;
                        Runnable runnable3 = new Runnable(){

                            public void run() {
                                RunWindow.this.pb.setValue(0);
                                RunWindow.this.pb.setMaximum(delay);
                                ((RunWindow)RunWindow.this).dg.tabbedPane.setSelectedIndex(n2);
                            }
                        };
                        RunWindow.invokeAndWait(runnable3);
                        final JPanel jPanel = this.dg.getPanel();
                        if (buffersFlag && jPanel.getComponentCount() == 1) {
                            this.dp = (DemoPanel)jPanel.getComponent(0);
                            if (this.dp.surface.animating != null) {
                                this.dp.surface.animating.stop();
                            }
                            int n3 = bufBeg;
                            while (n3 <= bufEnd && this.thread != null) {
                                final int n4 = n3++;
                                Runnable runnable4 = new Runnable(){

                                    public void run() {
                                        ((RunWindow)RunWindow.this).dp.tools.cloneB.doClick();
                                        int n = jPanel.getComponentCount();
                                        DemoPanel demoPanel = (DemoPanel)jPanel.getComponent(n - 1);
                                        if (demoPanel.surface.animating != null) {
                                            demoPanel.surface.animating.stop();
                                        }
                                        demoPanel.tools.issueRepaint = true;
                                        demoPanel.tools.screenCombo.setSelectedIndex(n4);
                                        demoPanel.tools.issueRepaint = false;
                                    }
                                };
                                RunWindow.invokeAndWait(runnable4);
                            }
                        }
                        if (printCB.isSelected()) {
                            this.printDemo(this.dg);
                        }
                        this.sleepPerTab();
                    }
                    continue;
                }
                if (j != 0 && printCB.isSelected()) {
                    this.printDemo(this.dg);
                    this.sleepPerTab();
                    continue;
                }
                this.sleepPerTab();
            }
            if (i + 1 != numRuns) continue;
            System.out.println("Finished.");
            if (!exit || this.thread == null) continue;
            System.out.println("System.exit(0).");
            System.exit(0);
        }
        Runnable runnable = new Runnable(){

            public void run() {
                runB.setText("Run");
                runB.setBackground(Color.GREEN);
                RunWindow.this.pb.setValue(0);
            }
        };
        RunWindow.invokeAndWait(runnable);
        this.thread = null;
        this.dg = null;
        this.dp = null;
    }

    private static void invokeAndWait(Runnable runnable) {
        try {
            SwingUtilities.invokeAndWait(runnable);
        }
        catch (Exception exception) {
            System.err.println("ERROR invokeAndWait : " + exception);
            exception.printStackTrace();
        }
    }

    static {
        delay = 10;
        numRuns = 20;
        zoomCB = new JCheckBox("Zoom");
        printCB = new JCheckBox("Print");
    }
}

