/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.event;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.EventListener;
import java.util.Hashtable;
import javax.swing.event.EventListenerList;

public final class SwingPropertyChangeSupport
extends PropertyChangeSupport {
    private static final long serialVersionUID = 7162625831330845068L;
    private transient EventListenerList listeners;
    private Hashtable propertyListeners;
    private Object source;

    public SwingPropertyChangeSupport(Object source) {
        super(source);
        this.source = source;
        this.listeners = new EventListenerList();
        this.propertyListeners = new Hashtable();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
    }

    private void readObject(ObjectInputStream stream) throws ClassNotFoundException, IOException {
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.add(SwingPropertyChangeSupport.class$("java.beans.PropertyChangeListener"), listener);
    }

    static /* synthetic */ Class class$(String type$) throws NoClassDefFoundError {
        try {
            return Class.forName(type$);
        }
        catch (ClassNotFoundException write_parm_value$) {
            throw new NoClassDefFoundError(write_parm_value$.getMessage());
        }
    }

    public synchronized void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        EventListenerList list = (EventListenerList)this.propertyListeners.get(propertyName);
        if (list == null) {
            list = new EventListenerList();
            this.propertyListeners.put(propertyName, list);
        }
        list.add(SwingPropertyChangeSupport.class$("java.beans.PropertyChangeListener"), listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.remove(SwingPropertyChangeSupport.class$("java.beans.PropertyChangeListener"), listener);
    }

    public synchronized void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        EventListenerList list = (EventListenerList)this.propertyListeners.get(propertyName);
        if (list == null) {
            return;
        }
        list.remove(SwingPropertyChangeSupport.class$("java.beans.PropertyChangeListener"), listener);
        if (list.getListenerCount() == 0) {
            this.propertyListeners.remove(propertyName);
        }
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        PropertyChangeEvent event = new PropertyChangeEvent(this.source, propertyName, oldValue, newValue);
        this.firePropertyChange(event);
    }

    public void firePropertyChange(PropertyChangeEvent event) {
        PropertyChangeListener listener;
        int index;
        if (event.getOldValue() == null || event.getNewValue() == null || event.getOldValue().equals(event.getNewValue())) {
            return;
        }
        EventListener[] listenerList = this.listeners.getListeners(SwingPropertyChangeSupport.class$("java.beans.PropertyChangeListener"));
        for (index = 0; index < listenerList.length; ++index) {
            listener = (PropertyChangeListener)listenerList[index];
            listener.propertyChange(event);
        }
        EventListenerList list = (EventListenerList)this.propertyListeners.get(event.getPropertyName());
        if (list != null) {
            listenerList = list.getListeners(SwingPropertyChangeSupport.class$("java.beans.PropertyChangeListener"));
            for (index = 0; index < listenerList.length; ++index) {
                listener = (PropertyChangeListener)listenerList[index];
                listener.propertyChange(event);
            }
        }
    }

    public synchronized boolean hasListeners(String propertyName) {
        return this.propertyListeners.get(propertyName) != null;
    }
}

