/*
**	config.h
**
**	Getty configuration for Linux 2.0 and after.
*/

/*
**	Copyright 1989,1990 by Paul Sutcliffe Jr.
**	Portions copyright 2000,2002 by Christine Jamison.
**
**	Permission is hereby granted to copy, reproduce, redistribute,
**	or otherwise use this software as long as: there is no monetary
**	profit gained specifically from the use or reproduction of this
**	software; it is not sold, rented, traded or otherwise marketed;
**	and this copyright notice is included prominently in any copy
**	made.
**
**	The authors make no claims as to the fitness or correctness of
**	this software for any use whatsoever, and it is provided as is. 
**	Any use of this software is at the user's own risk.
*/


#include "tune.h"			/* defs needed below */

#define	GETTYTAB  "/etc/gettydefs"	/* file used for speed/termio table */

#define	index	  strchr		/* use these instead */
#define	rindex	  strrchr

#ifndef	UTMP_FILE
#define	UTMP_FILE "/var/run/utmp"	/* name of the utmp file */
#endif	/* UTMP_FILE */

#ifndef	WTMP_FILE
#define	WTMP_FILE "/var/log/wtmp"	/* FSSTND compliant wtmp file */
#endif	/* WTMP_FILE */

			/* The following define activates a routine to	    */
			/* lookup (in the specified file) and set the       */
			/* initial TERM value for the login shell - CSJ.    */
#define TTYTYPE "/etc/ttytype"		/* name of the ttytype file */
/*			   Uncomment to disable TTYTYPE.
#undef TTYTYPE
*/

#define	ASCIIPID			/* PID stored in ASCII */
#define	BOTHPID				/* ... or perhaps not */
			/* The following puts all non-logged in ports in    */
			/* the same group, which follows the new standards  */
			/* for security - CSJ.				    */
#define	TTYGID 5			/* gid of "tty" group */
			/* The following puts all uucp non-logged in ports  */
			/* to the same owner, which allows uucp to work     */
			/* with just one (modem-controlled) port! (i.e.,    */
			/* *without* the "cua" port!) - CSJ.		    */
#define	UUCPID 10			/* uid of UUCP account */
			/* The following controls the delay used by uugetty */
			/* to keep the stdin, stdout, and stderr closed,    */
			/* forcing DTR to drop, which allows modems and     */
			/* such to do a reset (which *should* do a drop     */
			/* carrier).  This is *NOT* done with GETTY, as     */
			/* POSIX compliant serial ports are by default modem*/
			/* control enabled, and this *might* disable the    */
			/* "trick" of wiring DTR, DSR and CD together (in   */
			/* addition to wiring RTS and CTS together) for a   */
			/* non-modem control device (like a dumb VDT).      */
#define UUDELAY 1			/* number of secs uugetty drops DTR */
#define	LOCK "/var/lock/LCK..%s"	/* lock file name */
#define LIBRARIES 1			/* Level of Library calls	    */
					/* -1: Really old libc libraries    */
					/*  0: pre-glibc libraries	    */
					/*  1: glibc1 (& higher) libraries  */

/* end of config.h */
