.TH sane-fujitsu 5 "2006-06-06" "@PACKAGEVERSION@" "SANE Scanner Access Now Easy"
.IX sane-fujitsu

.SH NAME
sane-fujitsu \- SANE backend for Fujitsu flatbed and ADF scanners

.SH DESCRIPTION
The 
.B sane-fujitsu
library implements a SANE (Scanner Access Now Easy) backend which
provides access to most Fujitsu flatbed and ADF scanners.

This document describes the rewritten backend versions 1.0.21 and greater.

The backend supports lineart, halftone, grayscale, and color
scanning for most USB and SCSI scanners, depending on hardware capabilities.
Most simple scanning related features are exposed.
This version features at least basic support for many more models.
See KNOWN ISSUES.

.SH HARDWARE SUPPORT
The following scanners are thought to have at least basic scanning 
capability, either because they have been tested with a prior
version, or because documentation indicates they are compatible
with a tested model.
.PP
.RS
.ft CR
.nf
WORKGROUP SIZED SCANNERS:
--------------------------------------
SCSI:        SCSI/USB:    USB:
------------ ------------ ------------
M3091DC      fi-4120C     fi-5110C
M3092DC      fi-4220C     fi-5110EOX
SP-93GX      fi-4120C2
             fi-4220C2
             fi-5120C
             fi-5220C
.fi
.ft R
.RE
.P
.PP
.RS
.ft CR
.nf
DEPARTMENTAL SIZED SCANNERS:
--------------------------------------
SCSI:        SCSI/USB:
------------ ------------
M3093GX/DG   fi-4340C
M3096G/GX    fi-4530C
M3097G+/DG   fi-5530C
fi-4640S
fi-4750C
.fi
.ft R
.RE
.P
.PP
.RS
.ft CR
.nf
PRODUCTION SIZED SCANNERS:
--------------------------------------
SCSI:        SCSI/USB:
------------ ------------
M3099G/GH/GX fi-5650C
M4097D       fi-5750C
fi-4750L     fi-5900C
fi-4860C
M4099D
.fi
.ft R
.RE
.P
The following scanners are known NOT to work with this backend,
either because they have a non-fujitsu chipset, or an unsupported
interface type. Some of these scanners may be supported by another
backend.
.PP
.RS
.ft CR
.nf
UNSUPPORTED SCANNERS:
--------------------------------------
SCSI:        SERIAL:      USB:
------------ ------------ ------------
ScanStation  M3093E/DE/EX fi-4110EOX2
ScanPartner  M3096EX      fi-4010CU
SP-Jr        M3097E+/DE
SP-10/10C    M3099A/EH/EX 
SP-15C/300C
SP-600C/620C
.fi
.ft R
.RE
.P
This backend may support scanners not listed here. The best
way to determine level of support is to test the scanner directly.
Fujitsu equipment has historically been good enough to not be 
damaged by incorrect commands if the scanner is incompatible.
Please contact the author with test results, positive or negative.

.SH OPTIONS
A modest effort has been made to expose the standard options to the API.
This allows a frontend to set scanning region, resolution, bit-depth,
color mode, and enable the automatic document feeder. The fujitsu backend
supports the following basic options for most scanners:
.PP
source s
.RS
Selects the source for the scan. Options
may include "Flatbed", "ADF Front", "ADF Back", "ADF Duplex".
.RE
.PP
mode m
.RS
Selects the mode for the scan. Options
may include "Lineart", "Halftone", "Gray", and "Color".
.RE
.PP
resolution, y-resolution
.RS
Controls scan resolution. Setting --resolution also sets --y-resolution
but not vice versa. This behavior is overridden by some frontends.
.RE
.PP
tlx, tly, brx, bry
.RS
Sets scan area upper left and lower right coordinates. Often converted
to t, l, x, y by frontend code.
.RE
.PP
pagewidth, pageheight
.RS
Sets paper size. Used by scanner to determine centering of scan
coordinates when using ADF.
.RE
.PP
Other options will be available based on the capabilities of the scanner.
Use 'scanimage --help' to get a list. Be aware that some options may
appear only when another option has been set.
.PP
.SH CONFIGURATION FILE
The configuration file "fujitsu.conf" is used to tell the backend how to look for
scanners, and provide options controlling the operation of the backend.
This file is read each time the frontend asks the backend for a list 
of scanners, generally only when the frontend starts. If the configuration
file is missing, the backend will use a set of compiled defaults, which
are identical to the default configuration file shipped with SANE.
.PP
Scanners can be specified in the configuration file in 4 ways:
.PP
"scsi FUJITSU"
.RS
Requests backend to search all scsi busses in the system for a device 
which reports itself to be a scanner made by 'FUJITSU'. 
.RE
.PP
"scsi /dev/sg0" (or other scsi device file)
.RS
Requests backend to open the named scsi device. Only useful if you have
multiple compatible scanners connected to your system, and need to
specify one. Probably should not be used with the other "scsi" line above.
.RE
.PP
"usb 0x04c5 0x1042" (or other vendor/product ids)
.RS
Requests backend to search all usb busses in the system for a device 
which uses that vendor and product id. The device will then be queried
to determine if it is a Fujitsu scanner.
.RE
.PP
"usb /dev/usb/scanner0" (or other device file)
.RS
Some systems use a kernel driver to access usb scanners. This method is untested.
.RE
.PP
The only configuration option supported is "buffer-size=xxx", allowing you
to set the number of bytes in the data buffer to something other than the 
compiled-in default, 65536 (64K). Some users report that their scanner will
"hang" mid-page, or fail to transmit the image if the buffer is not large
enough.
.PP
Note: This option may appear multiple times in the configuration file. It only
applies to scanners discovered by 'scsi/usb' lines that follow this option.
.PP
Note: The backend does not place an upper bound on this value, as some users
required it to be quite large. Values above the default are not recommended,
and may crash your OS or lockup your scsi card driver. You have been
warned.
.PP

.SH ENVIRONMENT
The backend uses a single environment variable, SANE_DEBUG_FUJITSU, which
enables debugging output to stderr. Valid values are:
.PP
.RS
5  Errors
.br
10 Function trace
.br
15 Function detail
.br
20 Option commands
.br
25 SCSI/USB trace
.br
30 SCSI/USB detail
.RE

.SH OLDER VERSIONS
Backend versions prior to this were numbered with a two part version,
or with no version number at all. At the time this version was written,
all older versions were retroactively renumbered, 1.0.2 - 1.0.20.
.PP
The current backend may have lost support for some feature you were using.
The last of the "old" backends, 1.0.20, is still available as source from:
.PP
http://www2.pfeiffer.edu/~anoah/fujitsu/
.PP
If you find that you need to use the older version, please contact the
author, to try and get those features restored to a later version.

.SH KNOWN ISSUES
.PP
.RS
All IPC, imprinter, and compression options are disabled.
.br
.br
Most scanner specific 'quirks' are not accounted for, making it possible
to set some options in ways that the scanner does not support.
.br
.br
Some flatbed options are affected by adf settings.
.br
.br
Any model that does not support VPD during inquiry will not function.
.RE

.SH HISTORY
m3091 backend: Frederik Ramm <frederik a t remote d o t org>
.br
m3096g backend: Randolph Bentson <bentson a t holmsjoen d o t com>
.br
  (with credit to the unnamed author of the coolscan driver)
.br
fujitsu backend, 3093, fi-4340C, ipc, cmp, long-time maintainer:
.br
  Oliver Schirrmeister <oschirr a t abm d o t de>
.br
3092: Mario Goppold <mgoppold a t tbzpariv d o t tcc-chemnitz d o t de>
.br
fi-4220C and basic USB support: Ron Cemer <ron a t roncemer d o t com>
.br
fi-4120, fi-series color support, backend re-write, current maintainer:
  M. Allan Noah: <anoah a t pfeiffer d o t edu>

.SH "SEE ALSO"
sane(7),
sane-scsi(5),
sane-usb(5),
sane-sp15c(5),
sane-avision(5)

.SH AUTHOR
M. Allan Noah: <anoah a t pfeiffer d o t edu>

