/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.jdi;

import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.VirtualMachine;
import java.util.ArrayList;
import java.util.List;
import sun.jvm.hotspot.jdi.ObjectReferenceImpl;
import sun.jvm.hotspot.jdi.ThreadReferenceImpl;
import sun.jvm.hotspot.oops.Instance;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.oops.OopUtilities;
import sun.jvm.hotspot.runtime.JavaThread;

public class ThreadGroupReferenceImpl
extends ObjectReferenceImpl
implements ThreadGroupReference {
    ThreadGroupReferenceImpl(VirtualMachine aVm, Oop oRef) {
        super(aVm, oRef);
    }

    protected String description() {
        return "ThreadGroupReference " + this.uniqueID();
    }

    public String name() {
        return OopUtilities.threadGroupOopGetName(this.ref());
    }

    public ThreadGroupReference parent() {
        return this.vm.threadGroupMirror((Instance)OopUtilities.threadGroupOopGetParent(this.ref()));
    }

    public void suspend() {
        this.vm.throwNotReadOnlyException("ThreadGroupReference.suspend()");
    }

    public void resume() {
        this.vm.throwNotReadOnlyException("ThreadGroupReference.resume()");
    }

    public List threads() {
        Oop[] myThreads = OopUtilities.threadGroupOopGetThreads(this.ref());
        ArrayList<ThreadReferenceImpl> myList = new ArrayList<ThreadReferenceImpl>(myThreads.length);
        for (int ii = 0; ii < myThreads.length; ++ii) {
            JavaThread jt = OopUtilities.threadOopGetJavaThread(myThreads[ii]);
            if (jt == null) continue;
            ThreadReferenceImpl xx = this.vm.threadMirror(jt);
            myList.add(xx);
        }
        return myList;
    }

    public List threadGroups() {
        Oop[] myGroups = OopUtilities.threadGroupOopGetGroups(this.ref());
        ArrayList<ThreadGroupReferenceImpl> myList = new ArrayList<ThreadGroupReferenceImpl>(myGroups.length);
        for (int ii = 0; ii < myGroups.length; ++ii) {
            ThreadGroupReferenceImpl xx = this.vm.threadGroupMirror((Instance)myGroups[ii]);
            myList.add(xx);
        }
        return myList;
    }

    public String toString() {
        return "instance of " + this.referenceType().name() + "(name='" + this.name() + "', " + "id=" + this.uniqueID() + ")";
    }
}

