/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.memory;

import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.memory.ProtectionDomainEntry;
import sun.jvm.hotspot.oops.InstanceKlass;
import sun.jvm.hotspot.oops.Klass;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.oops.Symbol;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObjectFactory;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.OopField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.utilities.HashtableEntry;

public class DictionaryEntry
extends HashtableEntry {
    private static AddressField pdSetField;
    private static OopField loaderField;

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("DictionaryEntry");
        pdSetField = type.getAddressField("_pd_set");
        loaderField = type.getOopField("_loader");
    }

    public ProtectionDomainEntry pdSet() {
        Address tmp = pdSetField.getValue(this.addr);
        return (ProtectionDomainEntry)VMObjectFactory.newObject(ProtectionDomainEntry.class, tmp);
    }

    public Oop loader() {
        return VM.getVM().getObjectHeap().newOop(loaderField.getValue(this.addr));
    }

    public Klass klass() {
        return (Klass)this.literal();
    }

    public DictionaryEntry(Address addr) {
        super(addr);
    }

    public boolean equals(Symbol className, Oop classLoader) {
        InstanceKlass ik = (InstanceKlass)this.klass();
        Oop loader = this.loader();
        if (!ik.getName().equals(className)) {
            return false;
        }
        return loader == null ? classLoader == null : loader.equals(classLoader);
    }

    public boolean isValidProtectionDomain(Oop protectionDomain) {
        if (protectionDomain == null) {
            return true;
        }
        return this.containsProtectionDomain(protectionDomain);
    }

    public boolean containsProtectionDomain(Oop protectionDomain) {
        InstanceKlass ik = (InstanceKlass)this.klass();
        if (protectionDomain.equals(ik.getProtectionDomain())) {
            return true;
        }
        for (ProtectionDomainEntry current = this.pdSet(); current != null; current = current.next()) {
            if (!protectionDomain.equals(current.protectionDomain())) continue;
            return true;
        }
        return false;
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            public void update(Observable o, Object data) {
                DictionaryEntry.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

